/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.remoteconsole.common.repodef.CustomTableDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.TableDef;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicRestEditPageRepoDef;
import weblogic.remoteconsole.customizers.Source;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;

public class ProviderMBeanCustomizer {
    private static final Map<String, String> providerClassNameToType = new HashMap<String, String>();

    public static SettableValue getType(@Source(property="Type") SettableValue type, @Source(property="ProviderClassName") SettableValue providerClassName) {
        if (type != null) {
            return type;
        }
        if (providerClassName == null) {
            return null;
        }
        String pcn = providerClassName.getValue().asString().getValue();
        String value = providerClassNameToType.get(pcn);
        if (value == null) {
            value = pcn;
        }
        return new SettableValue((Value)new StringValue(value), false);
    }

    public static PageDef customizeTableDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        if (ic.getPagePath().getPagesPath().getPageRepoDef() instanceof WebLogicRestEditPageRepoDef) {
            return uncustomizedPageDef;
        }
        TableDef uncustomizedTableDef = uncustomizedPageDef.asTableDef();
        return new CustomTableDef(uncustomizedTableDef).actionDefs(List.of());
    }

    private ProviderMBeanCustomizer() {
    }

    static {
        providerClassNameToType.put("weblogic.security.providers.authentication.DBMSPluggableRuntimeAuthenticationProviderImpl", "weblogic.security.providers.authentication.CustomDBMSAuthenticator");
        providerClassNameToType.put("weblogic.security.providers.authentication.DBMSAuthenticationProviderImpl", "weblogic.security.providers.authentication.DBMSAuthenticator");
        providerClassNameToType.put("weblogic.security.providers.authentication.DefaultAuthenticationProviderImpl", "weblogic.security.providers.authentication.DefaultAuthenticator");
        providerClassNameToType.put("weblogic.security.providers.authentication.DefaultIdentityAsserterProviderImpl", "weblogic.security.providers.authentication.DefaultIdentityAsserter");
        providerClassNameToType.put("weblogic.security.providers.authentication.LDAPAuthenticationProviderImpl", "weblogic.security.providers.authentication.LDAPAuthenticator");
        providerClassNameToType.put("weblogic.security.providers.authentication.LDAPX509IdentityAsserterProviderImpl", "weblogic.security.providers.authentication.LDAPX509IdentityAsserter");
        providerClassNameToType.put("weblogic.security.providers.authentication.NegotiateIdentityAsserterProviderImpl", "weblogic.security.providers.authentication.NegotiateIdentityAsserter");
        providerClassNameToType.put("weblogic.security.providers.authentication.OIDCIdentityAsserterProviderImpl", "weblogic.security.providers.authentication.OIDCIdentityAsserter");
        providerClassNameToType.put("weblogic.security.providers.authentication.IDCSIntegratorProviderImpl", "weblogic.security.providers.authentication.OracleIdentityCloudIntegrator");
        providerClassNameToType.put("weblogic.security.providers.authentication.DBMSSQLReadOnlyAuthenticationProviderImpl", "weblogic.security.providers.authentication.ReadOnlySQLAuthenticator");
        providerClassNameToType.put("weblogic.security.providers.saml.SAMLAuthenticationProviderImpl", "weblogic.security.providers.saml.SAMLAuthenticator");
        providerClassNameToType.put("weblogic.security.providers.saml.SAMLIdentityAsserterV2ProviderImpl", "weblogic.security.providers.saml.SAMLIdentityAsserterV2");
        providerClassNameToType.put("com.bea.security.saml2.providers.SAML2IdentityAsserterProviderImpl", "com.bea.security.saml2.providers.SAML2IdentityAsserter");
        providerClassNameToType.put("weblogic.security.providers.authentication.DBMSSQLAuthenticationProviderImpl", "weblogic.security.providers.authentication.SQLAuthenticator");
        providerClassNameToType.put("weblogic.security.providers.authentication.VirtualUserAuthenticationProviderImpl", "weblogic.security.providers.authentication.VirtualUserAuthenticator");
        providerClassNameToType.put("oracle.security.agent.access.wls.asserter.CSAAsserterProvider", "oracle.security.agent.access.filter.CloudSecurityAgentAsserter");
        providerClassNameToType.put("oracle.security.jps.wls.providers.authentication.idm.CrossTenantAuthenticationProviderImpl", "oracle.security.jps.wls.providers.authentication.idm.CrossTenantAuthenticator");
        providerClassNameToType.put("oracle.security.wls.oam.providers.authenticator.OAMAuthenticationProviderImpl", "oracle.security.wls.oam.providers.authenticator.OAMAuthenticator");
        providerClassNameToType.put("oracle.security.wls.oam.providers.asserter.OAMIdentityAssertionProviderImpl", "oracle.security.wls.oam.providers.asserter.OAMIdentityAsserter");
        providerClassNameToType.put("oracle.security.jps.wls.providers.trust.TrustServiceAsserterProviderImpl", "oracle.security.jps.wls.providers.trust.TrustServiceIdentityAsserter");
        providerClassNameToType.put("weblogic.security.providers.authorization.DefaultRoleMapperProviderImpl", "weblogic.security.providers.authorization.DefaultRoleMapper");
        providerClassNameToType.put("weblogic.security.providers.xacml.authorization.XACMLRoleMapperProviderImpl", "weblogic.security.providers.xacml.authorization.XACMLRoleMapper");
        providerClassNameToType.put("weblogic.security.providers.authorization.DefaultAuthorizationProviderImpl", "weblogic.security.providers.authorization.DefaultAuthorizer");
        providerClassNameToType.put("weblogic.security.providers.xacml.authorization.XACMLAuthorizationProviderImpl", "weblogic.security.providers.xacml.authorization.XACMLAuthorizer");
        providerClassNameToType.put("weblogic.security.providers.credentials.DefaultCredentialMapperProviderImpl", "weblogic.security.providers.credentials.DefaultCredentialMapper");
        providerClassNameToType.put("weblogic.security.providers.credentials.PKICredentialMapperProviderImpl", "weblogic.security.providers.credentials.PKICredentialMapper");
        providerClassNameToType.put("weblogic.security.providers.saml.SAMLCredentialMapperV2ProviderImpl", "weblogic.security.providers.saml.SAMLCredentialMapperV2");
        providerClassNameToType.put("com.bea.security.saml2.providers.SAML2CredentialMapperProviderImpl", "com.bea.security.saml2.providers.SAML2CredentialMapper");
        providerClassNameToType.put("oracle.security.wls.oam.providers.credentials.OAMCredentialMappingProviderImpl", "oracle.security.wls.oam.providers.credentials.OAMCredentialMapper");
        providerClassNameToType.put("weblogic.security.providers.pk.CertificateRegistryRuntimeImpl", "weblogic.security.providers.pk.CertificateRegistry");
        providerClassNameToType.put("weblogic.security.providers.pk.WebLogicCertPathProviderRuntimeImpl", "weblogic.security.providers.pk.WebLogicCertPathProvider");
        providerClassNameToType.put("weblogic.security.providers.authorization.DefaultAdjudicationProviderImpl", "weblogic.security.providers.authorization.DefaultAdjudicator");
        providerClassNameToType.put("weblogic.security.providers.audit.DefaultAuditProviderImpl", "weblogic.security.providers.audit.DefaultAuditor");
        providerClassNameToType.put("com.bea.security.providers.authentication.passwordvalidator.SystemPasswordValidatorProviderImpl", "com.bea.security.providers.authentication.passwordvalidator.SystemPasswordValidator");
    }
}

