/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.customizers.Source;
import weblogic.remoteconsole.server.repo.DownloadValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.LabelValue;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.Value;

public class NodeManagerRuntimeMBeanCustomizer {
    private NodeManagerRuntimeMBeanCustomizer() {
    }

    public static SettableValue getDownloadLogLink(InvocationContext ic, @Source(property="Reachable") SettableValue reachable) {
        Value value = null;
        if (reachable.getValue().asBoolean().getValue()) {
            if (!NodeManagerRuntimeMBeanCustomizer.supportsLogDownload(ic)) {
                String label = ic.getLocalizer().localizeString(LocalizedConstants.NODE_MANAGER_LOG_DOWNLOAD_NOT_SUPPORTED, new Object[0]);
                value = new LabelValue(label);
            } else {
                String machine = ic.getBeanTreePath().getLastSegment().getKey();
                Path path = new Path("domainRuntime.downloads.NodeManagerLogs");
                path.addComponent(machine);
                String label = ic.getLocalizer().localizeString(LocalizedConstants.NODE_MANAGER_LOG_DOWNLOAD_LABEL, new Object[0]);
                String download = machine + "NodeManager.log";
                value = new DownloadValue(label, path, "text/plain", download);
            }
        } else {
            String label = ic.getLocalizer().localizeString(LocalizedConstants.NODE_MANAGER_LOG_NOT_AVAILABLE_LABEL, new Object[0]);
            value = new LabelValue(label);
        }
        return new SettableValue(value);
    }

    private static boolean supportsLogDownload(InvocationContext ic) {
        boolean support = ic.getPageRepo().getBeanRepo().getBeanRepoDef().supportsCapabilities(List.of("NodeManagerLog"));
        return support;
    }
}

