/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CustomActionInputFormDef;
import weblogic.remoteconsole.common.repodef.CustomLegalValueDef;
import weblogic.remoteconsole.common.repodef.CustomPageActionParamDef;
import weblogic.remoteconsole.common.repodef.LegalValueDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageActionParamDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BeanActionArg;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.repo.Value;

public class MigrationCoordinatorMBeanCustomizer {
    private static final String PROP_NAME = "Name";
    private static final String PROP_USER_PREFERRED_SERVER = "UserPreferredServer";
    private static final String PROP_HOSTING_SERVER = "HostingServer";
    private static final String PROP_CLUSTER = "Cluster";
    private static final String PROP_MACHINE = "Machine";
    private static final String PROP_STATE = "State";
    private static final String PROP_AUTO_MIGRATION_ENABLED = "AutoMigrationEnabled";
    private static final String PROP_ALL_CANDIDATE_SERVERS = "AllCandidateServers";
    private static final String RUNNING_STATE = "RUNNING";
    private static final String PROP_CANDIDATE_MACHINES = "CandidateMachines";
    private static final String PROP_CANDIDATE_MACHINES_FOR_MIGRATABLE_SERVERS = "CandidateMachinesForMigratableServers";

    private MigrationCoordinatorMBeanCustomizer() {
    }

    public static Value migrate(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        return MigrationCoordinatorMBeanCustomizer.commonSetupMigrateParams(ic, formProperties, "migrate");
    }

    public static Value migrateJTA(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        return MigrationCoordinatorMBeanCustomizer.commonSetupMigrateParams(ic, formProperties, "migrateJTA");
    }

    private static Value commonSetupMigrateParams(InvocationContext ic, List<FormProperty> formProperties, String migrateMethodName) {
        String migratableTarget = ic.getIdentifier();
        String destination = formProperties.get(0).getValue().asSettable().getValue().asString().getValue();
        List<Map<String, Value>> migratableTargetList = MigrationCoordinatorMBeanCustomizer.getMigratableTargetList(ic, "Domain.MigratableTargets", migratableTarget);
        String hostingServer = MigrationCoordinatorMBeanCustomizer.getHostingServerNameFromListMap(ic, migratableTargetList);
        if (hostingServer.equals("")) {
            throw Response.userBadRequestException().addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.NO_HOSTING_SERVER_FOR_MT, new Object[0]));
        }
        Boolean sourceUp = MigrationCoordinatorMBeanCustomizer.isServerRunning(ic, hostingServer);
        Boolean destinationUp = MigrationCoordinatorMBeanCustomizer.isServerRunning(ic, destination);
        BeanTreePath destinationBTPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain.Servers").childPath(destination));
        BeanTreePath targetBTPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain.MigratableTargets").childPath(migratableTarget));
        BeanActionDef actionDef = ic.getBeanTreePath().getTypeDef().getActionDef(new Path(migrateMethodName));
        ArrayList<BeanActionArg> args = new ArrayList<BeanActionArg>();
        args.add(new BeanActionArg(actionDef.getParamDef("migratableTarget"), targetBTPath));
        args.add(new BeanActionArg(actionDef.getParamDef("destination"), destinationBTPath));
        args.add(new BeanActionArg(actionDef.getParamDef("sourceUp"), new BooleanValue(sourceUp)));
        args.add(new BeanActionArg(actionDef.getParamDef("destinationUp"), new BooleanValue(destinationUp)));
        Response<Value> response = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().invokeAction(ic, actionDef, args);
        if (response.isUserBadRequest() && response.getMessages().isEmpty()) {
            response.addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.REFER_TO_MIGRATION_TASKS, new Object[0]));
        }
        return response.getResults();
    }

    public static Value migrateSingleton(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        String singleton = ic.getIdentifier();
        String destination = formProperties.get(0).getValue().asSettable().getValue().asString().getValue();
        BeanTreePath destinationBTPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain.Servers").childPath(destination));
        BeanTreePath singletonBTPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain.SingletonServices").childPath(singleton));
        BeanActionDef actionDef = ic.getBeanTreePath().getTypeDef().getActionDef(new Path("migrateSingleton"));
        ArrayList<BeanActionArg> args = new ArrayList<BeanActionArg>();
        args.add(new BeanActionArg(actionDef.getParamDef("singletonService"), singletonBTPath));
        args.add(new BeanActionArg(actionDef.getParamDef("destination"), destinationBTPath));
        Response<Value> response = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().invokeAction(ic, actionDef, args);
        if (response.isUserBadRequest() && response.getMessages().isEmpty()) {
            response.addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.REFER_TO_MIGRATION_TASKS, new Object[0]));
        }
        return response.getResults();
    }

    public static Value migrateServer(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        String serverName = ic.getIdentifier();
        String destinationMachine = formProperties.get(0).getValue().asSettable().getValue().asString().getValue();
        BeanTreePath serverBeanPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain.Servers").childPath(serverName));
        BeanTypeDef serverTypeDef = serverBeanPath.getTypeDef();
        BeanPropertyDef machinePropertyDef = serverTypeDef.getPropertyDef(new Path(PROP_MACHINE));
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        builder.addProperty(serverBeanPath, machinePropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults beanResults = searchResults.getBean(serverBeanPath);
        String sourceMachine = beanResults.getValue(machinePropertyDef).asBeanTreePath().getLastSegment().getKey();
        boolean sourceDown = false;
        boolean destinationDown = false;
        BeanActionDef actionDef = ic.getBeanTreePath().getTypeDef().getActionDef(new Path("migrateServer"));
        ArrayList<BeanActionArg> args = new ArrayList<BeanActionArg>();
        args.add(new BeanActionArg(actionDef.getParamDef("serverName"), new StringValue(serverName)));
        args.add(new BeanActionArg(actionDef.getParamDef("sourceMachine"), new StringValue(sourceMachine)));
        args.add(new BeanActionArg(actionDef.getParamDef("destinationMachine"), new StringValue(destinationMachine)));
        args.add(new BeanActionArg(actionDef.getParamDef("sourceDown"), new BooleanValue(sourceDown)));
        args.add(new BeanActionArg(actionDef.getParamDef("destinationDown"), new BooleanValue(destinationDown)));
        Response<Value> response = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().invokeAction(ic, actionDef, args);
        if (response.isUserBadRequest() && response.getMessages().isEmpty()) {
            response.addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.REFER_TO_MIGRATION_TASKS, new Object[0]));
        }
        return response.getResults();
    }

    public static List<TableRow> getMigrateJMSSliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults overallSearchResults) {
        return MigrationCoordinatorMBeanCustomizer.getCommonSliceTableRows(ic, overallSearchResults, "Domain.MigratableTargets");
    }

    public static List<TableRow> getSingletonServiceSliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults overallSearchResults) {
        return MigrationCoordinatorMBeanCustomizer.getCommonSliceTableRows(ic, overallSearchResults, "Domain.SingletonServices");
    }

    public static List<TableRow> getMigrateServerSliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults overallSearchResults) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        List<Map<String, Value>> serverList = MigrationCoordinatorMBeanCustomizer.getMigratableServersList(ic, "Domain.Servers");
        if (serverList.isEmpty()) {
            return rows;
        }
        for (Map<String, Value> oneServer : serverList) {
            TableRow row = new TableRow();
            String serverName = oneServer.get(PROP_NAME).asString().getValue();
            if (!MigrationCoordinatorMBeanCustomizer.isServerRunning(ic, serverName) || oneServer.get(PROP_CLUSTER).isNullReference() || !oneServer.get(PROP_AUTO_MIGRATION_ENABLED).asBoolean().getValue()) continue;
            row.setIdentifier(oneServer.get(PROP_NAME).asString().getValue());
            row.getCells().add(MigrationCoordinatorMBeanCustomizer.createTableCell(PROP_NAME, oneServer.get(PROP_NAME)));
            row.getCells().add(MigrationCoordinatorMBeanCustomizer.createTableCell(PROP_CLUSTER, oneServer.get(PROP_CLUSTER)));
            row.getCells().add(MigrationCoordinatorMBeanCustomizer.createTableCell(PROP_MACHINE, oneServer.get(PROP_MACHINE)));
            row.getCells().add(MigrationCoordinatorMBeanCustomizer.createTableCell(PROP_AUTO_MIGRATION_ENABLED, oneServer.get(PROP_AUTO_MIGRATION_ENABLED)));
            rows.add(row);
        }
        return rows;
    }

    private static TableCell createTableCell(String name, Value value) {
        return new TableCell(name, value);
    }

    private static boolean isServerRunning(InvocationContext ic, String serverName) {
        BeanTreePath serverBeanPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("DomainRuntime.ServerLifeCycleRuntimes.").childPath(serverName));
        BeanTypeDef serverRuntimeTypeDef = serverBeanPath.getTypeDef();
        BeanPropertyDef statePropertyDef = serverRuntimeTypeDef.getPropertyDef(new Path(PROP_STATE));
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        builder.addProperty(serverBeanPath, statePropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults beanResults = searchResults.getBean(serverBeanPath);
        Value stateValue = beanResults.getValue(statePropertyDef);
        return RUNNING_STATE.equals(stateValue.asString().getValue());
    }

    private static List<TableRow> getCommonSliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults overallSearchResults, String path) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        List<Map<String, Value>> migratableTargetList = MigrationCoordinatorMBeanCustomizer.getMigratableTargetList(ic, path, null);
        if (migratableTargetList.isEmpty()) {
            return rows;
        }
        for (Map<String, Value> oneMigratableTarget : migratableTargetList) {
            TableRow row = new TableRow();
            row.setIdentifier(oneMigratableTarget.get(PROP_NAME).asString().getValue());
            row.getCells().add(MigrationCoordinatorMBeanCustomizer.createTableCell(PROP_NAME, oneMigratableTarget.get(PROP_NAME)));
            row.getCells().add(MigrationCoordinatorMBeanCustomizer.createTableCell(PROP_USER_PREFERRED_SERVER, oneMigratableTarget.get(PROP_USER_PREFERRED_SERVER)));
            row.getCells().add(MigrationCoordinatorMBeanCustomizer.createTableCell(PROP_HOSTING_SERVER, oneMigratableTarget.get(PROP_HOSTING_SERVER)));
            row.getCells().add(MigrationCoordinatorMBeanCustomizer.createTableCell(PROP_CLUSTER, oneMigratableTarget.get(PROP_CLUSTER)));
            rows.add(row);
        }
        return rows;
    }

    private static List<Map<String, Value>> getMigratableTargetList(InvocationContext ic, String pathString, String filteredName) {
        BeanTreePath migratableTargetsBeanPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path(pathString));
        BeanTypeDef migratableTargetTypeDef = migratableTargetsBeanPath.getTypeDef();
        BeanPropertyDef identityPropertyDef = migratableTargetTypeDef.getIdentityPropertyDef();
        BeanPropertyDef userPreferredServerPropertyDef = migratableTargetTypeDef.getPropertyDef(new Path(PROP_USER_PREFERRED_SERVER));
        BeanPropertyDef hostingServerPropertyDef = migratableTargetTypeDef.getPropertyDef(new Path(PROP_HOSTING_SERVER));
        BeanPropertyDef clusterPropertyDef = migratableTargetTypeDef.getPropertyDef(new Path(PROP_CLUSTER));
        BeanPropertyDef allCandidateServersPropertyDef = migratableTargetTypeDef.getPropertyDef(new Path(PROP_ALL_CANDIDATE_SERVERS));
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        builder.addProperty(migratableTargetsBeanPath, identityPropertyDef);
        builder.addProperty(migratableTargetsBeanPath, userPreferredServerPropertyDef);
        builder.addProperty(migratableTargetsBeanPath, hostingServerPropertyDef);
        builder.addProperty(migratableTargetsBeanPath, clusterPropertyDef);
        builder.addProperty(migratableTargetsBeanPath, allCandidateServersPropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        ArrayList<Map<String, Value>> migratableTargetList = new ArrayList<Map<String, Value>>();
        for (BeanSearchResults migratableTargetResults : searchResults.getCollection(migratableTargetsBeanPath)) {
            String id;
            HashMap<String, Value> infoMap = new HashMap<String, Value>();
            if (filteredName != null && !filteredName.equals(id = migratableTargetResults.getValue(identityPropertyDef).asBeanTreePath().getLastSegment().getKey()) || migratableTargetResults.getValue(clusterPropertyDef).isNullReference()) continue;
            infoMap.put(PROP_CLUSTER, MigrationCoordinatorMBeanCustomizer.getStringValue(migratableTargetResults.getValue(clusterPropertyDef)));
            infoMap.put(PROP_NAME, MigrationCoordinatorMBeanCustomizer.getStringValue(migratableTargetResults.getValue(identityPropertyDef)));
            infoMap.put(PROP_USER_PREFERRED_SERVER, MigrationCoordinatorMBeanCustomizer.getStringValue(migratableTargetResults.getValue(userPreferredServerPropertyDef)));
            infoMap.put(PROP_HOSTING_SERVER, MigrationCoordinatorMBeanCustomizer.getStringValue(migratableTargetResults.getValue(hostingServerPropertyDef)));
            infoMap.put(PROP_ALL_CANDIDATE_SERVERS, migratableTargetResults.getValue(allCandidateServersPropertyDef));
            migratableTargetList.add(infoMap);
        }
        return migratableTargetList;
    }

    private static List<Map<String, Value>> getMigratableServersList(InvocationContext ic, String pathString) {
        BeanTreePath serversBeanPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path(pathString));
        BeanTypeDef serversTypeDef = serversBeanPath.getTypeDef();
        BeanPropertyDef identityPropertyDef = serversTypeDef.getIdentityPropertyDef();
        BeanPropertyDef clusterPropertyDef = serversTypeDef.getPropertyDef(new Path(PROP_CLUSTER));
        BeanPropertyDef machinePropertyDef = serversTypeDef.getPropertyDef(new Path(PROP_MACHINE));
        BeanPropertyDef autoMigrationEnabledPropertyDef = serversTypeDef.getPropertyDef(new Path(PROP_AUTO_MIGRATION_ENABLED));
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        builder.addProperty(serversBeanPath, identityPropertyDef);
        builder.addProperty(serversBeanPath, clusterPropertyDef);
        builder.addProperty(serversBeanPath, machinePropertyDef);
        builder.addProperty(serversBeanPath, autoMigrationEnabledPropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        ArrayList<Map<String, Value>> serversList = new ArrayList<Map<String, Value>>();
        for (BeanSearchResults serverResults : searchResults.getCollection(serversBeanPath)) {
            HashMap<String, Value> infoMap = new HashMap<String, Value>();
            infoMap.put(PROP_NAME, MigrationCoordinatorMBeanCustomizer.getStringValue(serverResults.getValue(identityPropertyDef)));
            infoMap.put(PROP_CLUSTER, MigrationCoordinatorMBeanCustomizer.getStringValue(serverResults.getValue(clusterPropertyDef)));
            infoMap.put(PROP_MACHINE, MigrationCoordinatorMBeanCustomizer.getStringValue(serverResults.getValue(machinePropertyDef)));
            infoMap.put(PROP_AUTO_MIGRATION_ENABLED, MigrationCoordinatorMBeanCustomizer.getBooleanValue(serverResults.getValue(autoMigrationEnabledPropertyDef), false));
            serversList.add(infoMap);
        }
        return serversList;
    }

    private static StringValue getStringValue(Value value) {
        if (value == null || value.isNullReference()) {
            return new StringValue("");
        }
        return new StringValue(value.asBeanTreePath().getLastSegment().getKey());
    }

    private static BooleanValue getBooleanValue(Value value, boolean defaultValue) {
        if (value == null) {
            return new BooleanValue(defaultValue);
        }
        return new BooleanValue(value.asBoolean().getValue());
    }

    public static PageDef customizeMigrationActionInputFormDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        CustomActionInputFormDef customActionInputFormDef = new CustomActionInputFormDef(uncustomizedPageDef.asActionInputFormDef());
        if (ic.getIdentifiers() == null || ic.getIdentifiers().isEmpty()) {
            return uncustomizedPageDef;
        }
        String migratableTargetName = ic.getIdentifiers().get(0);
        List<String> candidateServersList = MigrationCoordinatorMBeanCustomizer.getCandidateServerList(ic, "Domain.MigratableTargets", migratableTargetName);
        customActionInputFormDef.setParamDefs(MigrationCoordinatorMBeanCustomizer.customizeCandidatesInParams(customActionInputFormDef.getParamDefs(), candidateServersList, "destination"));
        return customActionInputFormDef;
    }

    public static PageDef customizeMigrateSingletonActionInputFormDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        CustomActionInputFormDef customActionInputFormDef = new CustomActionInputFormDef(uncustomizedPageDef.asActionInputFormDef());
        if (ic.getIdentifiers() == null || ic.getIdentifiers().isEmpty()) {
            return uncustomizedPageDef;
        }
        String singletonName = ic.getIdentifiers().get(0);
        List<String> candidateServersList = MigrationCoordinatorMBeanCustomizer.getCandidateServerList(ic, "Domain.SingletonServices", singletonName);
        customActionInputFormDef.setParamDefs(MigrationCoordinatorMBeanCustomizer.customizeCandidatesInParams(customActionInputFormDef.getParamDefs(), candidateServersList, "destination"));
        return customActionInputFormDef;
    }

    private static List<PageActionParamDef> customizeCandidatesInParams(List<PageActionParamDef> uncustomizedPageActionParamDefs, List<String> serverList, String parmName) {
        ArrayList<PageActionParamDef> customizedPageActionParamDefs = new ArrayList<PageActionParamDef>();
        for (PageActionParamDef uncustomizedPageActionParamDef : uncustomizedPageActionParamDefs) {
            if (parmName.equals(uncustomizedPageActionParamDef.getParamName())) {
                PageActionParamDef paramDef = MigrationCoordinatorMBeanCustomizer.customizeServerList(uncustomizedPageActionParamDef, serverList);
                customizedPageActionParamDefs.add(paramDef);
                continue;
            }
            customizedPageActionParamDefs.add(uncustomizedPageActionParamDef);
        }
        return customizedPageActionParamDefs;
    }

    private static PageActionParamDef customizeServerList(PageActionParamDef uncustomizedPageActionParamDef, List<String> serverList) {
        ArrayList<LegalValueDef> customizedLegalValueDefs = new ArrayList<LegalValueDef>();
        CustomPageActionParamDef customPageActionParamDef = new CustomPageActionParamDef(uncustomizedPageActionParamDef);
        for (String server : serverList) {
            customizedLegalValueDefs.add(new CustomLegalValueDef().fieldDef(uncustomizedPageActionParamDef).value(new StringValue(server)).label(new LocalizableString(server)));
        }
        return customPageActionParamDef.legalValueDefs(customizedLegalValueDefs);
    }

    private static String getHostingServerNameFromListMap(InvocationContext ic, List<Map<String, Value>> migratableTargetList) {
        if (migratableTargetList.isEmpty()) {
            throw Response.userBadRequestException().addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.MIGRATION_TARGET_NOT_FOUND, new Object[0]));
        }
        Map<String, Value> migratableTargetInfo = migratableTargetList.get(0);
        Value hostingServerValue = migratableTargetInfo.get(PROP_HOSTING_SERVER);
        String hostingServer = hostingServerValue == null ? "" : hostingServerValue.asString().getValue();
        return hostingServer;
    }

    private static List<String> getCandidateServerList(InvocationContext ic, String pathString, String migratableTargetName) {
        List<Map<String, Value>> migratableTargetList = MigrationCoordinatorMBeanCustomizer.getMigratableTargetList(ic, pathString, migratableTargetName);
        Map<String, Value> migratableTargetInfo = migratableTargetList.get(0);
        String hostingServer = MigrationCoordinatorMBeanCustomizer.getHostingServerNameFromListMap(ic, migratableTargetList);
        ArrayValue allCandidatesValue = migratableTargetInfo.get(PROP_ALL_CANDIDATE_SERVERS).asArray();
        ArrayList<String> serverList = new ArrayList<String>();
        for (Value oneCandidateV : allCandidatesValue.getValues()) {
            String oneServer = oneCandidateV.asBeanTreePath().getLastSegment().getKey();
            if (oneServer.equals(hostingServer)) continue;
            serverList.add(oneServer);
        }
        return serverList;
    }

    public static PageDef customizeMigrateServerInputFormDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        CustomActionInputFormDef customActionInputFormDef = new CustomActionInputFormDef(uncustomizedPageDef.asActionInputFormDef());
        if (ic.getIdentifiers() == null || ic.getIdentifiers().isEmpty()) {
            return uncustomizedPageDef;
        }
        String serverName = ic.getIdentifiers().get(0);
        List<String> candidateMachineList = MigrationCoordinatorMBeanCustomizer.getCandidateMachineList(ic, serverName);
        customActionInputFormDef.setParamDefs(MigrationCoordinatorMBeanCustomizer.customizeCandidatesInParams(customActionInputFormDef.getParamDefs(), candidateMachineList, "destinationMachine"));
        return customActionInputFormDef;
    }

    private static List<String> getCandidateMachineList(InvocationContext ic, String serverName) {
        BeanTreePath serverBeanPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain.Servers").childPath(serverName));
        Map<String, Object> infoMap = MigrationCoordinatorMBeanCustomizer.getMachines(ic, serverBeanPath, PROP_CANDIDATE_MACHINES, true);
        List candidateMachinesList = (List)infoMap.get(PROP_CANDIDATE_MACHINES);
        String currentMachine = (String)infoMap.get(PROP_MACHINE);
        if (candidateMachinesList == null || candidateMachinesList.isEmpty()) {
            BeanTreePath clusterBeanPath = (BeanTreePath)infoMap.get(PROP_CLUSTER);
            infoMap = MigrationCoordinatorMBeanCustomizer.getMachines(ic, clusterBeanPath, PROP_CANDIDATE_MACHINES_FOR_MIGRATABLE_SERVERS, false);
            candidateMachinesList = (List)infoMap.get(PROP_CANDIDATE_MACHINES_FOR_MIGRATABLE_SERVERS);
        }
        ArrayList<String> machineList = new ArrayList<String>();
        if (candidateMachinesList != null && !candidateMachinesList.isEmpty()) {
            for (BeanTreePath oneMachine : candidateMachinesList) {
                String machineName = oneMachine.asBeanTreePath().getLastSegment().getKey();
                if (machineName.equals(currentMachine)) continue;
                machineList.add(machineName);
            }
        }
        if (machineList.isEmpty()) {
            machineList.add(ic.getLocalizer().localizeString(LocalizedConstants.NONE_CONFIGURED, new Object[0]));
        }
        return machineList;
    }

    private static Map<String, Object> getMachines(InvocationContext ic, BeanTreePath beanTreePath, String propertyName, boolean includeCluster) {
        BeanTypeDef serverTypeDef = beanTreePath.getTypeDef();
        BeanPropertyDef identityPropertyDef = serverTypeDef.getIdentityPropertyDef();
        BeanPropertyDef candidateMachinesPropertyDef = serverTypeDef.getPropertyDef(new Path(propertyName));
        BeanPropertyDef clusterPropertyDef = null;
        BeanPropertyDef machinePropertyDef = null;
        if (includeCluster) {
            clusterPropertyDef = serverTypeDef.getPropertyDef(new Path(PROP_CLUSTER));
            machinePropertyDef = serverTypeDef.getPropertyDef(new Path(PROP_MACHINE));
        }
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        builder.addProperty(beanTreePath, identityPropertyDef);
        builder.addProperty(beanTreePath, candidateMachinesPropertyDef);
        if (includeCluster) {
            builder.addProperty(beanTreePath, clusterPropertyDef);
            builder.addProperty(beanTreePath, machinePropertyDef);
        }
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults beanResults = searchResults.getBean(beanTreePath);
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put(propertyName, beanResults.getValue(candidateMachinesPropertyDef).asArray().getValues());
        if (includeCluster) {
            infoMap.put(PROP_CLUSTER, beanResults.getValue(clusterPropertyDef).asBeanTreePath());
            infoMap.put(PROP_MACHINE, beanResults.getValue(machinePropertyDef).asBeanTreePath().getLastSegment().getKey());
        }
        return infoMap;
    }
}

