/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.remoteconsole.customizers.Source;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Option;
import weblogic.remoteconsole.server.repo.Value;

public class MBeanClusterServersCustomizer {
    private static final String IDENTITY = "identity";
    private static final String CLUSTER = "Cluster";

    private MBeanClusterServersCustomizer() {
    }

    public static List<Option> getServersOfSameCluster(InvocationContext invocationContext, @Source(collection="/Domain/Servers", properties={"identity", "Cluster"}) List<Map<String, Value>> servers, @Source(property="Cluster") Value clusterWant) {
        return MBeanClusterServersCustomizer.extractServersOfSameCluster(invocationContext, servers, clusterWant);
    }

    private static List<Option> extractServersOfSameCluster(InvocationContext invocationContext, List<Map<String, Value>> servers, Value clusterWant) {
        ArrayList<Option> options = new ArrayList<Option>();
        for (Map<String, Value> server : servers) {
            Value serverIdentity = server.get(IDENTITY);
            Value serverCluster = server.get(CLUSTER);
            if (!MBeanClusterServersCustomizer.clusterMatches(serverCluster, clusterWant)) continue;
            options.add(new Option(invocationContext, serverIdentity));
        }
        return options;
    }

    private static boolean clusterMatches(Value clusterHave, Value clusterWant) {
        if (clusterWant.isNullReference()) {
            return true;
        }
        if (clusterHave.isNullReference()) {
            return false;
        }
        return MBeanClusterServersCustomizer.getIdentity(clusterHave).equals(MBeanClusterServersCustomizer.getIdentity(clusterWant));
    }

    private static String getIdentity(Value ref) {
        return ref.asBeanTreePath().getPath().getDotSeparatedPath();
    }
}

