/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.CustomPagePropertyDef;
import weblogic.remoteconsole.common.repodef.CustomSliceFormDef;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.SliceFormDef;
import weblogic.remoteconsole.customizers.CustomizerUtils;
import weblogic.remoteconsole.customizers.JMSMessageManagementRuntimeMBeanCollectionChildResource;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.DateAsLongValue;
import weblogic.remoteconsole.server.repo.Form;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.IntValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.Option;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestInvoker;
import weblogic.remoteconsole.server.webapp.BaseResource;

public class JMSMessageManagementRuntimeMBeanCustomizer {
    private static long MAX_DISPLAYABLE_MESSAGE_SIZE = Long.getLong("JMSMaximumDisplayableMessageSize", 204800L);
    private static int MAX_DISPLAYED_MESSAGE_BODY_LENGTH = Integer.getInteger("JMSMaximumDisplayedMessageBodyLength", 10000);
    private static String CONFIGURATION_LOCK = new String();
    private static MessageFilters GLOBAL_MESSAGE_FILTERS = new MessageFilters();

    private JMSMessageManagementRuntimeMBeanCustomizer() {
    }

    public static BaseResource createResource(InvocationContext ic) {
        if (ic.getBeanTreePath().isCollectionChild()) {
            return new JMSMessageManagementRuntimeMBeanCollectionChildResource();
        }
        return null;
    }

    public static PageDef customizeMessagesFilterSliceDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        SliceFormDef uncustomizedSliceFormDef = uncustomizedPageDef.asSliceFormDef();
        ArrayList<PagePropertyDef> customizedPropertyDefs = new ArrayList<PagePropertyDef>();
        for (PagePropertyDef uncustomizedPropertyDef : uncustomizedSliceFormDef.getPropertyDefs()) {
            if (uncustomizedPropertyDef.getPropertyName().equals("JMSMessageSelectorFromFilters")) {
                customizedPropertyDefs.add(uncustomizedPropertyDef);
                continue;
            }
            customizedPropertyDefs.add(new CustomPagePropertyDef(uncustomizedPropertyDef).writable(true));
        }
        return new CustomSliceFormDef(uncustomizedSliceFormDef).propertyDefs(customizedPropertyDefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void customizeMessagesFilterSlice(InvocationContext ic, Page page) {
        String string = CONFIGURATION_LOCK;
        synchronized (string) {
            Form form = page.asForm();
            form.setExists(true);
            HashMap<String, PagePropertyDef> nameToPropertyDef = new HashMap<String, PagePropertyDef>();
            for (PagePropertyDef propertyDef : page.getPageDef().getAllPropertyDefs()) {
                nameToPropertyDef.put(propertyDef.getFormFieldName(), propertyDef);
            }
            JMSMessageManagementRuntimeMBeanCustomizer.getMessageFilters(ic, false).customizeMessageFiltersSlice(nameToPropertyDef, form);
        }
    }

    public static void customizeExportMessagesActionInputForm(InvocationContext ic, Page page) {
        JMSMessageManagementRuntimeMBeanCustomizer.initializeActionInputFormSelector(ic, page);
    }

    public static void customizeDeleteMessagesActionInputForm(InvocationContext ic, Page page) {
        JMSMessageManagementRuntimeMBeanCustomizer.initializeActionInputFormSelector(ic, page);
    }

    public static void customizeMoveMessagesActionInputForm(InvocationContext ic, Page page) {
        for (FormProperty property : page.asForm().getProperties()) {
            if (!"destinationID".equals(property.getName())) continue;
            property.setOptions(JMSMessageManagementRuntimeMBeanCustomizer.getAllDestinations(ic));
        }
        JMSMessageManagementRuntimeMBeanCustomizer.initializeActionInputFormSelector(ic, page);
    }

    public static void customizeViewMessageActionInputForm(InvocationContext ic, Page page) {
        List<FormProperty> properties = page.asForm().getProperties();
        ArrayList<FormProperty> originalProperties = new ArrayList<FormProperty>(properties);
        properties.clear();
        String messageID = ic.getIdentifiers().get(0);
        JsonObject metaData = JMSMessageManagementRuntimeMBeanCustomizer.getJMSMessage(ic, messageID).getJsonObject("metaData");
        long messageSize = metaData.getJsonNumber("messageSize").longValueExact();
        String messageType = metaData.getString("messageType");
        if (!"text".equals(messageType) && !"xml".equals(messageType)) {
            page.setLocalizedIntroductionHTML(ic.getLocalizer().localizeString(LocalizedConstants.JMS_CANNOT_VIEW_MESSAGE_BODY_BECAUSE_WRONG_TYPE, messageID));
            return;
        }
        if (messageSize > MAX_DISPLAYABLE_MESSAGE_SIZE) {
            page.setLocalizedIntroductionHTML(ic.getLocalizer().localizeString(LocalizedConstants.JMS_CANNOT_VIEW_MESSAGE_BODY_BECAUSE_TOO_BIG, messageID));
            return;
        }
        Object messageBody = JMSMessageManagementRuntimeMBeanCustomizer.getJMSTextMessage(ic, messageID).getString("text");
        int messageLength = ((String)messageBody).length();
        if (messageLength > MAX_DISPLAYED_MESSAGE_BODY_LENGTH) {
            messageBody = ((String)messageBody).substring(0, MAX_DISPLAYED_MESSAGE_BODY_LENGTH) + "...";
            page.setLocalizedIntroductionHTML(ic.getLocalizer().localizeString(LocalizedConstants.JMS_DISPLAYED_TRIMMED_MESSAGE_BODY, messageID));
        } else {
            page.setLocalizedIntroductionHTML(ic.getLocalizer().localizeString(LocalizedConstants.JMS_DISPLAYED_MESSAGE_BODY, messageID));
        }
        properties.add(new FormProperty(FormProperty.findProperty("MessageBody", originalProperties).getFieldDef(), new StringValue((String)messageBody)));
    }

    private static JsonObject getJMSMessage(InvocationContext ic, String messageID) {
        JsonObject invokeResponse = WebLogicRestInvoker.post(ic, JMSMessageManagementRuntimeMBeanCustomizer.getJMSMessageManagementRuntimeWlsPath(ic).childPath("getJMSMessage"), Json.createObjectBuilder().add("messageID", messageID).build(), false, false, false).getResults();
        if (invokeResponse.isNull("return")) {
            throw Response.notFoundException();
        }
        return invokeResponse.getJsonObject("return");
    }

    private static JsonObject getJMSTextMessage(InvocationContext ic, String messageID) {
        JsonObject invokeResponse = WebLogicRestInvoker.post(ic, JMSMessageManagementRuntimeMBeanCustomizer.getJMSMessageManagementRuntimeWlsPath(ic).childPath("getJMSTextMessage"), Json.createObjectBuilder().add("messageID", messageID).build(), false, false, false).getResults();
        if (invokeResponse.isNull("return")) {
            throw Response.notFoundException();
        }
        return invokeResponse.getJsonObject("return");
    }

    private static Path getJMSMessageManagementRuntimeWlsPath(InvocationContext ic) {
        List components = ic.getBeanTreePath().getPath().getComponents();
        String server = (String)components.get(2);
        String jmsServer = (String)components.get(6);
        String destination = (String)components.get(8);
        Path wlsPath = new Path().childPath("domainRuntime").childPath("serverRuntimes").childPath(server).childPath("JMSRuntime").childPath("JMSServers").childPath(jmsServer).childPath("destinations").childPath(destination);
        if (components.size() >= 11) {
            String durableSubscriber = (String)components.get(10);
            wlsPath = wlsPath.childPath("durableSubscribers").childPath(durableSubscriber);
        }
        return wlsPath;
    }

    private static List<Option> getAllDestinations(InvocationContext ic) {
        ArrayList destinations = new ArrayList();
        String serverName = ic.getBeanTreePath().getSegments().get(1).getKey();
        String thisJMSServerName = ic.getBeanTreePath().getSegments().get(4).getKey();
        String thisDestName = ic.getBeanTreePath().getSegments().get(5).getKey();
        BeanTreePath jmsServersBTP = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("DomainRuntime").childPath("ServerRuntimes").childPath(serverName).childPath("JMSRuntime").childPath("JMSServers"));
        BeanTreePath destsBTP = jmsServersBTP.childPath(new Path("Destinations"));
        BeanPropertyDef destTypePropDef = destsBTP.getTypeDef().getPropertyDef(new Path("DestinationType"));
        BeanPropertyDef destIDPropDef = destsBTP.getTypeDef().getPropertyDef(new Path("DestinationID"));
        BeanReaderRepoSearchBuilder searchBuilder = destsBTP.getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        searchBuilder.addProperty(destsBTP, destsBTP.getTypeDef().getIdentityPropertyDef());
        searchBuilder.addProperty(destsBTP, destTypePropDef);
        searchBuilder.addProperty(destsBTP, destIDPropDef);
        BeanReaderRepoSearchResults searchResults = searchBuilder.search().getResults();
        TreeMap<CallSite, Option> jmsServerAndDestToOption = new TreeMap<CallSite, Option>();
        for (BeanSearchResults jmsServerResults : searchResults.getCollection(jmsServersBTP)) {
            BeanTreePath jmsServerBTP = jmsServerResults.getBeanTreePath();
            String jmsServerName = jmsServerBTP.getLastSegment().getKey();
            BeanTreePath jmsServerDestsBTP = jmsServerBTP.childPath(new Path("Destinations"));
            for (BeanSearchResults destResults : searchResults.getCollection(jmsServerDestsBTP)) {
                BeanTreePath destBTP = destResults.getBeanTreePath();
                String destType = destResults.getValue(destTypePropDef).asString().getValue();
                if (!"Queue".equals(destType)) continue;
                String destName = destBTP.getLastSegment().getKey();
                if (thisJMSServerName.equals(jmsServerName) && thisDestName.equals(destName)) continue;
                Value destID = destResults.getValue(destIDPropDef);
                String label = jmsServerName + ", " + destName;
                Option option = new Option(label, destID);
                String jmsServerAndDest = jmsServerName + "," + destName;
                jmsServerAndDestToOption.put((CallSite)((Object)jmsServerAndDest), option);
            }
        }
        return new ArrayList<Option>(jmsServerAndDestToOption.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeActionInputFormSelector(InvocationContext ic, Page page) {
        String string = CONFIGURATION_LOCK;
        synchronized (string) {
            List<FormProperty> properties = page.asForm().getProperties();
            ArrayList<FormProperty> newProperties = new ArrayList<FormProperty>();
            for (FormProperty property : properties) {
                if ("selector".equals(property.getName())) {
                    newProperties.add(new FormProperty(property.getFieldDef(), new StringValue(JMSMessageManagementRuntimeMBeanCustomizer.getMessageFilters(ic, false).getMessageSelector())));
                    continue;
                }
                newProperties.add(property);
            }
            properties.clear();
            properties.addAll(newProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response<Void> updateMessageFilters(InvocationContext ic, List<FormProperty> properties) {
        String string = CONFIGURATION_LOCK;
        synchronized (string) {
            HashMap<String, FormProperty> nameToProperty = new HashMap<String, FormProperty>();
            for (FormProperty property : properties) {
                nameToProperty.put(property.getName(), property);
            }
            JMSMessageManagementRuntimeMBeanCustomizer.getMessageFilters(ic, true).updateMessageFilters(nameToProperty);
            return new Response<Object>().setSuccess(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void customizeMessagesViewPage(InvocationContext ic, Page page) {
        String string = CONFIGURATION_LOCK;
        synchronized (string) {
            JsonObject messages = JMSMessageManagementRuntimeMBeanCustomizer.getMessages(ic);
            List<TableRow> rows = JMSMessageManagementRuntimeMBeanCustomizer.processMessages(messages.getJsonArray("jmsMessages"));
            page.asTable().getRows().addAll(rows);
            page.setLocalizedIntroductionHTML(ic.getLocalizer().localizeString(page.getPageDef().getIntroductionHTML(), new Object[0]) + JMSMessageManagementRuntimeMBeanCustomizer.getViewMessagesIntro(ic, rows.size(), messages.getJsonNumber("totalCount").longValueExact(), messages.getJsonNumber("totalFilteredCount").longValueExact()));
        }
    }

    private static String getViewMessagesIntro(InvocationContext ic, long returnedMessages, long totalUnfilteredMessages, long totalFilteredMessages) {
        MessageFilters filters = JMSMessageManagementRuntimeMBeanCustomizer.getMessageFilters(ic, false);
        String messageSelector = filters.getMessageSelector();
        String sortOn = filters.getSortOn();
        boolean ascending = filters.isAscending();
        boolean unfiltered = StringUtils.isEmpty((String)messageSelector);
        if (totalUnfilteredMessages == 0L) {
            return ic.getLocalizer().localizeString(LocalizedConstants.NO_JMS_MESSAGES, new Object[0]);
        }
        if (unfiltered) {
            if (returnedMessages == totalUnfilteredMessages) {
                return ic.getLocalizer().localizeString(LocalizedConstants.ALL_UNFILTERED_JMS_MESSAGES, totalUnfilteredMessages);
            }
            return ic.getLocalizer().localizeString(LocalizedConstants.SOME_UNFILTERED_JMS_MESSAGES, totalUnfilteredMessages, returnedMessages, sortOn, ascending);
        }
        if (totalFilteredMessages == 0L) {
            return ic.getLocalizer().localizeString(LocalizedConstants.NO_FILTERED_JMS_MESSAGES, totalUnfilteredMessages, messageSelector);
        }
        if (returnedMessages == totalFilteredMessages) {
            return ic.getLocalizer().localizeString(LocalizedConstants.ALL_FILTERED_JMS_MESSAGES, totalUnfilteredMessages, totalFilteredMessages, messageSelector);
        }
        return ic.getLocalizer().localizeString(LocalizedConstants.SOME_FILTERED_JMS_MESSAGES, totalUnfilteredMessages, totalFilteredMessages, returnedMessages, messageSelector, sortOn, ascending);
    }

    private static JsonObject getMessages(InvocationContext ic) {
        Path cbePath = ic.getBeanTreePath().getPath();
        Path wlsPath = new Path("domainRuntime.serverRuntimes");
        wlsPath.addComponent((String)cbePath.getComponents().get(2));
        wlsPath.addComponent("JMSRuntime");
        wlsPath.addComponent("JMSServers");
        wlsPath.addComponent((String)cbePath.getComponents().get(6));
        wlsPath.addComponent("destinations");
        wlsPath.addComponent((String)cbePath.getComponents().get(8));
        if (cbePath.length() > 9) {
            wlsPath.addComponent("durableSubscribers");
            wlsPath.addComponent((String)cbePath.getComponents().get(10));
        }
        wlsPath.addComponent("getJMSMessages");
        JsonObjectBuilder args = Json.createObjectBuilder();
        MessageFilters filters = JMSMessageManagementRuntimeMBeanCustomizer.getMessageFilters(ic, false);
        args.add("selector", StringUtils.nonNull((String)filters.getMessageSelector()));
        args.add("max", filters.getMax());
        JsonArrayBuilder sortOnArg = Json.createArrayBuilder();
        JsonArrayBuilder ascendingArg = Json.createArrayBuilder();
        String sortOn = filters.getSortOn();
        if (!StringUtils.isEmpty((String)sortOn)) {
            sortOnArg.add(sortOn);
            ascendingArg.add(filters.isAscending());
        }
        args.add("sortOn", sortOnArg);
        args.add("ascending", ascendingArg);
        JsonObject invokeResponse = WebLogicRestInvoker.post(ic, wlsPath, args.build(), false, false, false).getResults();
        return invokeResponse.getJsonObject("return");
    }

    private static List<TableRow> processMessages(JsonArray messages) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        for (int i = 0; i < messages.size(); ++i) {
            rows.add(JMSMessageManagementRuntimeMBeanCustomizer.processMessage(messages.getJsonObject(i)));
        }
        return rows;
    }

    private static TableRow processMessage(JsonObject message) {
        JsonObject metaData = message.getJsonObject("metaData");
        JsonObject header = message.getJsonObject("header");
        TableRow row = new TableRow();
        row.setIdentifier(CustomizerUtils.getStringField(header, "jmsMessageID"));
        row.getCells().add(new TableCell("JMSMessageID", new StringValue(CustomizerUtils.getStringField(header, "jmsMessageID"))));
        row.getCells().add(new TableCell("JMSCorrelationID", new StringValue(CustomizerUtils.getStringField(header, "jmsCorrelationID"))));
        row.getCells().add(new TableCell("JMSTimestamp", new DateAsLongValue(header.getJsonNumber("jmsTimestamp").longValueExact())));
        row.getCells().add(new TableCell("State", new StringValue(CustomizerUtils.getStringField(metaData, "state"))));
        row.getCells().add(new TableCell("JMSDeliveryMode", new StringValue(CustomizerUtils.getStringField(header, "jmsDeliveryMode"))));
        row.getCells().add(new TableCell("MessageSize", new LongValue(metaData.getJsonNumber("messageSize").longValueExact())));
        row.getCells().add(new TableCell("JMSType", new StringValue(CustomizerUtils.getStringField(header, "jmsType"))));
        row.getCells().add(new TableCell("JMSPriority", new IntValue(header.getInt("jmsPriority"))));
        row.getCells().add(new TableCell("Xid", new StringValue(CustomizerUtils.getStringField(metaData, "xid"))));
        row.getCells().add(new TableCell("JMSExpiration", new DateAsLongValue(header.getJsonNumber("jmsExpiration").longValueExact())));
        row.getCells().add(new TableCell("JMSRedelivered", new BooleanValue(header.getBoolean("jmsRedelivered"))));
        row.getCells().add(new TableCell("JMSRedeliveryLimit", new StringValue(JMSMessageManagementRuntimeMBeanCustomizer.getHeaderProperty(header, "JMS_BEA_RedeliveryLimit"))));
        row.getCells().add(new TableCell("JMSDeliveryTime", new DateAsLongValue(JMSMessageManagementRuntimeMBeanCustomizer.getLongHeaderProperty(header, "JMS_BEA_DeliveryTime"))));
        row.getCells().add(new TableCell("SequenceNumber", new IntValue(metaData.getInt("sequenceNumber"))));
        return row;
    }

    private static long getLongHeaderProperty(JsonObject header, String property) {
        String str = JMSMessageManagementRuntimeMBeanCustomizer.getHeaderProperty(header, property);
        if (str == null) {
            return 0L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)(property + " must be a long: " + str));
        }
    }

    private static String getHeaderProperty(JsonObject header, String property) {
        JsonArray props = header.getJsonArray("properties");
        for (int i = 0; props != null && i < props.size(); ++i) {
            JsonObject prop = props.getJsonObject(i);
            String name = CustomizerUtils.getStringField(prop, "name");
            if (!property.equals(name)) continue;
            return CustomizerUtils.getStringField(prop, "value");
        }
        return null;
    }

    private static MessageFilters getMessageFilters(InvocationContext ic, boolean forUpdate) {
        return GLOBAL_MESSAGE_FILTERS;
    }

    static class MessageFilters {
        private boolean useCustomMessageSelector = false;
        private String customMessageSelector;
        private String sortOn = "JMS_BEA_SequenceNumber";
        private boolean ascending = true;
        private int max = 1000;
        private List<Filter> filters = List.of(new StringFilter("JMSCorrelationID"), new StringFilter("JMSDeliveryMode").value("PERSISTENT"), new DateAsLongFilter("JMSDeliveryTime", "JMSDeliveryTime"), new DateAsLongFilter("JMSExpiration"), new StringFilter("JMSMessageID"), new IntFilter("JMSPriority").value(4), new BooleanFilter("JMSRedelivered").value(false), new IntFilter("JMSRedeliveryLimit", "JMS_BEA_RedeliveryLimit"), new DateAsLongFilter("JMSTimestamp"), new StringFilter("JMSType"), new LongFilter("MessageSize", "JMS_BEA_Size"), new StringFilter("State", "JMS_BEA_State").value("visible"), new StringFilter("Xid", "JMS_BEA_Xid"));

        MessageFilters() {
        }

        String getSortOn() {
            return this.sortOn;
        }

        boolean isAscending() {
            return this.ascending;
        }

        int getMax() {
            return this.max;
        }

        String getMessageSelector() {
            return this.useCustomMessageSelector ? this.customMessageSelector : this.computeMessageSelectorFromFilters();
        }

        private String computeMessageSelectorFromFilters() {
            boolean addedAFilter = false;
            StringBuilder sb = new StringBuilder();
            for (Filter filter : this.filters) {
                if (!filter.addToSelector()) continue;
                if (addedAFilter) {
                    sb.append(" AND ");
                }
                sb.append(filter.toSelector());
                addedAFilter = true;
            }
            return sb.toString();
        }

        void updateMessageFilters(Map<String, FormProperty> nameToProperty) {
            FormProperty property = nameToProperty.get("UseCustomJMSMessageSelector");
            if (property != null) {
                this.useCustomMessageSelector = property.getValue().asSettable().getValue().asBoolean().getValue();
            }
            if ((property = nameToProperty.get("CustomJMSMessageSelector")) != null) {
                this.customMessageSelector = property.getValue().asSettable().getValue().asString().getValue();
            }
            if ((property = nameToProperty.get("SortOn")) != null) {
                this.sortOn = property.getValue().asSettable().getValue().asString().getValue();
            }
            if ((property = nameToProperty.get("Ascending")) != null) {
                this.ascending = property.getValue().asSettable().getValue().asBoolean().getValue();
            }
            if ((property = nameToProperty.get("MaximumMatches")) != null) {
                this.max = property.getValue().asSettable().getValue().asInt().getValue();
            }
            for (Filter filter : this.filters) {
                filter.updateMessageFilter(nameToProperty);
            }
        }

        void customizeMessageFiltersSlice(Map<String, PagePropertyDef> nameToPropertyDef, Form form) {
            PagePropertyDef propertyDef = nameToPropertyDef.get("UseCustomJMSMessageSelector");
            if (propertyDef != null) {
                form.getProperties().add(new FormProperty(propertyDef, new BooleanValue(this.useCustomMessageSelector)));
            }
            if ((propertyDef = nameToPropertyDef.get("CustomJMSMessageSelector")) != null) {
                form.getProperties().add(new FormProperty(propertyDef, new StringValue(this.customMessageSelector)));
            }
            if ((propertyDef = nameToPropertyDef.get("JMSMessageSelectorFromFilters")) != null) {
                form.getProperties().add(new FormProperty(propertyDef, new StringValue(this.computeMessageSelectorFromFilters())));
            }
            if ((propertyDef = nameToPropertyDef.get("SortOn")) != null) {
                form.getProperties().add(new FormProperty(propertyDef, new StringValue(this.sortOn)));
            }
            if ((propertyDef = nameToPropertyDef.get("Ascending")) != null) {
                form.getProperties().add(new FormProperty(propertyDef, new BooleanValue(this.ascending)));
            }
            if ((propertyDef = nameToPropertyDef.get("MaximumMatches")) != null) {
                form.getProperties().add(new FormProperty(propertyDef, new IntValue(this.max)));
            }
            for (Filter filter : this.filters) {
                filter.customizeMessageFiltersSlice(nameToPropertyDef, form);
            }
        }
    }

    static class StringFilter
    extends Filter {
        private String value;

        StringFilter(String property) {
            this(property, property);
        }

        StringFilter(String formProperty, String selectorProperty) {
            super(formProperty, selectorProperty);
        }

        String getValue() {
            return this.value;
        }

        StringFilter value(String val) {
            this.value = val;
            return this;
        }

        @Override
        String toSelector() {
            String selectorValue = StringUtils.nonNull((String)this.value).replaceAll("'", "''");
            if ("equals".equals(this.getCriteria())) {
                return "( " + this.getSelectorProperty() + " = '" + selectorValue + "' )";
            }
            if ("notEquals".equals(this.getCriteria())) {
                return "( " + this.getSelectorProperty() + " <> '" + selectorValue + "' )";
            }
            if ("contains".equals(this.getCriteria())) {
                return "( " + this.getSelectorProperty() + " LIKE '%" + selectorValue + "%' )";
            }
            throw this.unsupportedCriteria();
        }

        @Override
        protected void updateMessageFilterValue(Value val) {
            this.value = val.asString().getValue();
        }

        @Override
        protected Value getFormValue() {
            return new StringValue(this.value);
        }
    }

    static class BooleanFilter
    extends Filter {
        private boolean value;

        BooleanFilter(String property) {
            this(property, property);
        }

        BooleanFilter(String formProperty, String selectorProperty) {
            super(formProperty, selectorProperty);
        }

        boolean getValue() {
            return this.value;
        }

        BooleanFilter value(boolean val) {
            this.value = val;
            return this;
        }

        @Override
        String toSelector() {
            if ("equals".equals(this.getCriteria())) {
                String selectorValue = this.value ? "TRUE" : "FALSE";
                return "( " + this.getSelectorProperty() + " = " + selectorValue + " )";
            }
            throw this.unsupportedCriteria();
        }

        @Override
        protected void updateMessageFilterValue(Value val) {
            this.value = val.asBoolean().getValue();
        }

        @Override
        protected Value getFormValue() {
            return new BooleanValue(this.value);
        }
    }

    static class IntFilter
    extends NumberFilter {
        private int value;

        IntFilter(String property) {
            this(property, property);
        }

        IntFilter(String formProperty, String selectorProperty) {
            super(formProperty, selectorProperty);
        }

        int getValue() {
            return this.value;
        }

        IntFilter value(int val) {
            this.value = val;
            return this;
        }

        @Override
        protected String getSelectorValue() {
            return "" + this.value;
        }

        @Override
        protected void updateMessageFilterValue(Value val) {
            this.value = val.asInt().getValue();
        }

        @Override
        protected Value getFormValue() {
            return new IntValue(this.value);
        }
    }

    static class DateAsLongFilter
    extends LongFilter {
        DateAsLongFilter(String property) {
            this(property, property);
        }

        DateAsLongFilter(String formProperty, String selectorProperty) {
            super(formProperty, selectorProperty);
            this.value(System.currentTimeMillis());
        }

        @Override
        String toSelector() {
            long thisSecondInMillis = super.getFormValue().asLong().getValue();
            long nextSecondInMillis = thisSecondInMillis + 1000L;
            if ("equals".equals(this.getCriteria())) {
                return "( ( " + this.getSelectorProperty() + " >= " + thisSecondInMillis + " ) AND ( " + this.getSelectorProperty() + " < " + nextSecondInMillis + " ) )";
            }
            if ("notEquals".equals(this.getCriteria())) {
                return "( ( " + this.getSelectorProperty() + " < " + thisSecondInMillis + " ) OR ( " + this.getSelectorProperty() + " >= " + nextSecondInMillis + " ) )";
            }
            if ("lessThan".equals(this.getCriteria())) {
                return "( " + this.getSelectorProperty() + " < " + thisSecondInMillis + " )";
            }
            if ("lessThanOrEquals".equals(this.getCriteria())) {
                return "( " + this.getSelectorProperty() + " < " + nextSecondInMillis + " )";
            }
            if ("greaterThan".equals(this.getCriteria())) {
                return "( " + this.getSelectorProperty() + " >= " + nextSecondInMillis + " )";
            }
            if ("greaterThanOrEquals".equals(this.getCriteria())) {
                return "( " + this.getSelectorProperty() + " >= " + thisSecondInMillis + " )";
            }
            throw this.unsupportedCriteria();
        }

        @Override
        protected void updateMessageFilterValue(Value val) {
            super.updateMessageFilterValue(val.asDateAsLong().asLong());
        }

        @Override
        protected Value getFormValue() {
            return new DateAsLongValue(super.getFormValue().asLong().getValue());
        }
    }

    static class LongFilter
    extends NumberFilter {
        private long value;

        LongFilter(String property) {
            this(property, property);
        }

        LongFilter(String formProperty, String selectorProperty) {
            super(formProperty, selectorProperty);
        }

        long getValue() {
            return this.value;
        }

        LongFilter value(long val) {
            this.value = val;
            return this;
        }

        @Override
        protected String getSelectorValue() {
            return "" + this.value;
        }

        @Override
        protected void updateMessageFilterValue(Value val) {
            this.value = val.asLong().getValue();
        }

        @Override
        protected Value getFormValue() {
            return new LongValue(this.value);
        }
    }

    static abstract class NumberFilter
    extends Filter {
        NumberFilter(String formProperty, String selectorProperty) {
            super(formProperty, selectorProperty);
        }

        protected abstract String getSelectorValue();

        @Override
        String toSelector() {
            String operator = null;
            if ("equals".equals(this.getCriteria())) {
                operator = "=";
            } else if ("notEquals".equals(this.getCriteria())) {
                operator = "<>";
            } else if ("lessThan".equals(this.getCriteria())) {
                operator = "<";
            } else if ("lessThanOrEquals".equals(this.getCriteria())) {
                operator = "<=";
            } else if ("greaterThan".equals(this.getCriteria())) {
                operator = ">";
            } else if ("greaterThanOrEquals".equals(this.getCriteria())) {
                operator = ">=";
            } else {
                throw this.unsupportedCriteria();
            }
            return "( " + this.getSelectorProperty() + " " + operator + " " + this.getSelectorValue() + " )";
        }
    }

    static abstract class Filter {
        protected static final String CRITERIA_UNFILTERED = "unfiltered";
        protected static final String CRITERIA_EQUALS = "equals";
        protected static final String CRITERIA_NOT_EQUALS = "notEquals";
        protected static final String CRITERIA_LESS_THAN = "lessThan";
        protected static final String CRITERIA_LESS_THAN_OR_EQUALS = "lessThanOrEquals";
        protected static final String CRITERIA_GREATER_THAN = "greaterThan";
        protected static final String CRITERIA_GREATER_THAN_OR_EQUALS = "greaterThanOrEquals";
        protected static final String CRITERIA_CONTAINS = "contains";
        private String formProperty;
        private String selectorProperty;
        private String criteria = "unfiltered";

        protected Filter(String formProperty, String selectorProperty) {
            this.formProperty = formProperty;
            this.selectorProperty = selectorProperty;
        }

        String getCriteria() {
            return this.criteria;
        }

        String getSelectorProperty() {
            return this.selectorProperty;
        }

        String getFormProperty() {
            return this.formProperty;
        }

        boolean addToSelector() {
            return !CRITERIA_UNFILTERED.equals(this.criteria);
        }

        abstract String toSelector();

        protected AssertionError unsupportedCriteria() {
            return new AssertionError((Object)("Unsupported criteria: " + this.getSelectorProperty() + " " + this.getCriteria()));
        }

        void updateMessageFilter(Map<String, FormProperty> nameToProperty) {
            FormProperty property = nameToProperty.get(this.getCriteriaFormProperty());
            if (property != null) {
                this.criteria = property.getValue().asSettable().getValue().asString().getValue();
            }
            if ((property = nameToProperty.get(this.getValueFormProperty())) != null) {
                this.updateMessageFilterValue(property.getValue().asSettable().getValue());
            }
        }

        protected abstract void updateMessageFilterValue(Value var1);

        void customizeMessageFiltersSlice(Map<String, PagePropertyDef> nameToPropertyDef, Form form) {
            PagePropertyDef propertyDef = nameToPropertyDef.get(this.getCriteriaFormProperty());
            if (propertyDef != null) {
                form.getProperties().add(new FormProperty(propertyDef, new StringValue(this.criteria)));
            }
            if ((propertyDef = nameToPropertyDef.get(this.getValueFormProperty())) != null) {
                form.getProperties().add(new FormProperty(propertyDef, this.getFormValue()));
            }
        }

        private String getCriteriaFormProperty() {
            return this.getFormProperty() + "Criteria";
        }

        private String getValueFormProperty() {
            return this.getFormProperty() + "Value";
        }

        protected abstract Value getFormValue();
    }
}

