/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.Map;
import weblogic.remoteconsole.common.utils.JDBCDriversUtils;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverAttribute;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoFactory;

public class JDBCSystemResourceMBeanCustomizerUtils {
    public static final String DATASOURCE_TYPE_GENERIC = "GENERIC";
    public static final String DATASOURCE_TYPE_GRIDLINK = "AGL";
    public static final String DATASOURCE_TYPE_UCP = "UCP";
    public static final String DATASOURCE_TYPE_MDS = "MDS";
    public static final String GENERIC_OTHER_DATABASE = JDBCSystemResourceMBeanCustomizerUtils.genericScopedName("OtherDatabase");
    private static final String PROPERTY_DATABASE_DRIVER = "DatabaseDriver";
    public static final String PROPERTY_DATASOURCE_TYPE = "JDBCResource.DatasourceType";
    public static final String PROPERTY_DBMS_NAME = "DbmsName";
    public static final String PROPERTY_DBMS_HOST = "DbmsHost";
    public static final String PROPERTY_DBMS_PORT = "DbmsPort";
    public static final String PROPERTY_DBMS_USER_NAME = "DbmsUsername";
    public static final String PROPERTY_DBMS_PASSWORD = "DbmsPassword";
    public static final String PROPERTY_GENERIC_DATABASE_TYPE = JDBCSystemResourceMBeanCustomizerUtils.genericScopedName("DatabaseType");
    public static final String PROPERTY_GLOBAL_TRANSACTIONS_PROTOTOL = "JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol";
    public static final String PROPERTY_URL = "JDBCResource.JDBCDriverParams.Url";
    public static final String PROPERTY_UCP_DATABASE_DRIVER = JDBCSystemResourceMBeanCustomizerUtils.ucpScopedName("DatabaseDriver");
    public static final String PROPERTY_GRIDLINK_DATABASE_DRIVER = JDBCSystemResourceMBeanCustomizerUtils.gridLinkScopedName("DatabaseDriver");
    public static final String PROPERTY_GRIDLINK_LISTENERS = "Listeners";
    public static final String PROPERTY_GRIDLINK_FAN_ENABLED = "JDBCResource.JDBCOracleParams.FanEnabled";
    public static final String PROPERTY_GRIDLINK_ONS_NODE_LIST = "JDBCResource.JDBCOracleParams.OnsNodeList";
    public static final String PROPERTY_GRIDLINK_ONS_WALLET_FILE = "JDBCResource.JDBCOracleParams.OnsWalletFile";
    public static final String PROPERTY_GRIDLINK_ONS_WALLET_PASSWORD = "JDBCResource.JDBCOracleParams.OnsWalletPassword";
    private static JDBCDriverInfoFactory DRIVER_INFO_FACTORY = JDBCDriversUtils.getJDBCDriverInfoFactory();

    private JDBCSystemResourceMBeanCustomizerUtils() {
    }

    public static JDBCDriverInfoFactory getDriverInfoFactory() {
        return DRIVER_INFO_FACTORY;
    }

    public static String[] getDBMSVendorNames() {
        return JDBCSystemResourceMBeanCustomizerUtils.getDriverInfoFactory().getDBMSVendorNames();
    }

    public static Map<String, JDBCDriverAttribute> getDriverAttributes(JDBCDriverInfo driverInfo) {
        Map<String, JDBCDriverAttribute> driverAttributes = driverInfo.getDriverAttributes();
        return driverAttributes;
    }

    public static String driverName(JDBCDriverInfo driverInfo) {
        return driverInfo.toString();
    }

    public static String genericDatabaseDriverProperty(String vendorName) {
        return JDBCSystemResourceMBeanCustomizerUtils.vendorScopedName(DATASOURCE_TYPE_GENERIC, vendorName, PROPERTY_DATABASE_DRIVER);
    }

    public static String driverScopedName(String datasourceType, JDBCDriverInfo driverInfo, String name) {
        return JDBCSystemResourceMBeanCustomizerUtils.scopedName(JDBCSystemResourceMBeanCustomizerUtils.vendorScopedDriverName(datasourceType, driverInfo), name);
    }

    private static String vendorScopedDriverName(String datasourceType, JDBCDriverInfo driverInfo) {
        return JDBCSystemResourceMBeanCustomizerUtils.datasourceTypeScopedName(datasourceType, JDBCSystemResourceMBeanCustomizerUtils.driverName(driverInfo));
    }

    public static String otherDatabaseScopedName(String name) {
        return JDBCSystemResourceMBeanCustomizerUtils.vendorScopedName(DATASOURCE_TYPE_GENERIC, "OtherDatabase", name);
    }

    private static String vendorScopedName(String datasourceType, String vendorName, String name) {
        return JDBCSystemResourceMBeanCustomizerUtils.datasourceTypeScopedName(datasourceType, JDBCSystemResourceMBeanCustomizerUtils.scopedName(vendorName, name));
    }

    private static String genericScopedName(String name) {
        return JDBCSystemResourceMBeanCustomizerUtils.datasourceTypeScopedName(DATASOURCE_TYPE_GENERIC, name);
    }

    private static String gridLinkScopedName(String name) {
        return JDBCSystemResourceMBeanCustomizerUtils.datasourceTypeScopedName(DATASOURCE_TYPE_GRIDLINK, name);
    }

    private static String ucpScopedName(String name) {
        return JDBCSystemResourceMBeanCustomizerUtils.datasourceTypeScopedName(DATASOURCE_TYPE_UCP, name);
    }

    private static String datasourceTypeScopedName(String datasourceType, String name) {
        return JDBCSystemResourceMBeanCustomizerUtils.scopedName(datasourceType, name);
    }

    public static String driverNameToFormPropertyName(String driverName) {
        String formName = driverName;
        formName = formName.replaceAll("\\(", "_LPAREN_");
        formName = formName.replaceAll("\\)", "_RPAREN_");
        formName = formName.replaceAll("'", "_APOS_");
        formName = formName.replaceAll("\\*", "_STAR_");
        formName = formName.replaceAll(" ", "_SPACE_");
        formName = formName.replaceAll("\\.", "_DOT_");
        formName = formName.replaceAll(";", "_SEMI_");
        formName = formName.replaceAll(":", "_COLON_");
        formName = formName.replaceAll("/", "_SLASH_");
        formName = formName.replaceAll("-", "_DASH_");
        return formName;
    }

    public static String formPropertyNameToDriverName(String formName) {
        String driverName = formName;
        driverName = driverName.replaceAll("_LPAREN_", "(");
        driverName = driverName.replaceAll("_RPAREN_", ")");
        driverName = driverName.replaceAll("_APOS_", "'");
        driverName = driverName.replaceAll("_STAR_", "*");
        driverName = driverName.replaceAll("_SPACE_", " ");
        driverName = driverName.replaceAll("_DOT_", ".");
        driverName = driverName.replaceAll("_SEMI_", ";");
        driverName = driverName.replaceAll("_COLON_", ":");
        driverName = driverName.replaceAll("_SLASH_", "/");
        driverName = driverName.replaceAll("_DASH_", "-");
        return driverName;
    }

    public static Boolean isXADriver(String driverName) {
        JDBCDriverInfo driverInfo = JDBCSystemResourceMBeanCustomizerUtils.getDriverInfoFactory().getDriverInfoByClass(driverName);
        if (driverInfo == null) {
            return null;
        }
        return driverInfo.isForXA();
    }

    private static String scopedName(String scope, String name) {
        return scope + "_" + name;
    }
}

