/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.schema.PageDefSource;
import weblogic.remoteconsole.customizers.JDBCSystemResourceMBeanCreatableCollectionResource;
import weblogic.remoteconsole.customizers.JDBCSystemResourceMBeanCreateFormSourceCustomizer;
import weblogic.remoteconsole.customizers.JDBCSystemResourceMBeanCustomizerUtils;
import weblogic.remoteconsole.customizers.JDBCSystemResourceMBeanEditableCollectionChildResource;
import weblogic.remoteconsole.customizers.Source;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Option;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.BaseResource;

public class JDBCSystemResourceMBeanCustomizer {
    private static final String JDBC_SYSTEM_RESOURCES = "/Domain/JDBCSystemResources";
    private static final String IDENTITY = "identity";
    private static final String DATA_SOURCE_LIST = "JDBCResource.JDBCDataSourceParams.DataSourceList";
    private static final String GLOBAL_TXN_PROTOCOL = "JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol";

    private JDBCSystemResourceMBeanCustomizer() {
    }

    public static void customizeCreateFormPageDefSource(PagePath pagePath, PageDefSource pageDefSource) {
        new JDBCSystemResourceMBeanCreateFormSourceCustomizer(pagePath, pageDefSource).customize();
    }

    public static BaseResource createResource(InvocationContext ic) {
        if (ic.getPageRepo().isPageEditorRepo()) {
            BeanTreePath btp = ic.getBeanTreePath();
            if (btp.isCollection()) {
                return new JDBCSystemResourceMBeanCreatableCollectionResource();
            }
            if (btp.isCollectionChild()) {
                return new JDBCSystemResourceMBeanEditableCollectionChildResource();
            }
        }
        return null;
    }

    public static List<Option> getXADataSourceOptions(InvocationContext ic, @Source(collection="/Domain/JDBCSystemResources", properties={"identity", "JDBCResource.JDBCDataSourceParams.DataSourceList", "JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol"}) List<Map<String, Value>> dataSources) {
        return JDBCSystemResourceMBeanCustomizer.getDataSourceOptions(ic, dataSources, true);
    }

    public static List<Option> getNonXADataSourceOptions(InvocationContext ic, @Source(collection="/Domain/JDBCSystemResources", properties={"identity", "JDBCResource.JDBCDataSourceParams.DataSourceList", "JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol"}) List<Map<String, Value>> dataSources) {
        return JDBCSystemResourceMBeanCustomizer.getDataSourceOptions(ic, dataSources, false);
    }

    private static List<Option> getDataSourceOptions(InvocationContext ic, List<Map<String, Value>> dataSources, boolean wantXA) {
        ArrayList<Option> options = new ArrayList<Option>();
        for (Map<String, Value> dataSource : dataSources) {
            boolean isOption = false;
            Value dsList = dataSource.get(DATA_SOURCE_LIST);
            if (!dsList.isString() || !StringUtils.notEmpty((String)dsList.asString().getValue())) {
                Value protocol = dataSource.get(GLOBAL_TXN_PROTOCOL);
                if (protocol.isString()) {
                    boolean isXA = "TwoPhaseCommit".equals(protocol.asString().getValue());
                    if (isXA == wantXA) {
                        isOption = true;
                    }
                } else {
                    isOption = true;
                }
            }
            if (!isOption) continue;
            options.add(new Option(ic, dataSource.get(IDENTITY)));
        }
        return options;
    }

    public static SettableValue getIsXADriver(@Source(property="JDBCResource.JDBCDriverParams.DriverName") SettableValue driverNameValue) {
        String driverName = driverNameValue.getValue().asString().getValue();
        Boolean isXADriver = JDBCSystemResourceMBeanCustomizerUtils.isXADriver(driverName);
        String rtn = null;
        rtn = isXADriver == null ? "unknown" : (isXADriver != false ? "true" : "false");
        return new SettableValue(new StringValue(rtn));
    }
}

