/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.schema.BeanPropertyDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.FormSectionDefSource;
import weblogic.remoteconsole.common.repodef.schema.LegalValueDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.PageDefSource;
import weblogic.remoteconsole.customizers.BasePageDefSourceCustomizer;
import weblogic.remoteconsole.customizers.JDBCSystemResourceMBeanCustomizerUtils;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverAttribute;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;

class JDBCSystemResourceMBeanCreateFormSourceCustomizer
extends BasePageDefSourceCustomizer {
    private static final String PROPERTY_SERVICE_NAME = "ServiceName";
    private static final Set<String> WELL_KNOWN_DRIVER_ATTRIBUTES = new HashSet<String>();

    JDBCSystemResourceMBeanCreateFormSourceCustomizer(PagePath pagePath, PageDefSource pageDefSource) {
        super(pagePath, pageDefSource);
    }

    void customize() {
        this.addGenericSection();
        this.addGridLinkSection();
        this.addUCPSection();
    }

    private void addGenericSection() {
        FormSectionDefSource section = this.addSectionToForm();
        section.setUsedIf(this.createUsedIf("JDBCResource.DatasourceType", "GENERIC"));
        this.addGenericDatabaseTypeSection(section);
        for (String vendorName : JDBCSystemResourceMBeanCustomizerUtils.getDBMSVendorNames()) {
            this.addGenericVendorSection(section, vendorName);
        }
        this.addGenericOtherDatabaseDriverSection(section);
    }

    private void addGenericDatabaseTypeSection(FormSectionDefSource parent) {
        FormSectionDefSource section = this.addSectionToSection(parent);
        BeanPropertyDefCustomizerSource property = this.addNonMBeanStringPropertyToSection(section, JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_GENERIC_DATABASE_TYPE, "Database Type", "Select the database type");
        this.setDefaultValue(property, "Oracle");
        for (String vendorName : JDBCSystemResourceMBeanCustomizerUtils.getDBMSVendorNames()) {
            this.addLegalValue(property, vendorName);
        }
        this.addLegalValue(property, JDBCSystemResourceMBeanCustomizerUtils.GENERIC_OTHER_DATABASE, "Other");
    }

    private void addGenericVendorSection(FormSectionDefSource parent, String vendorName) {
        FormSectionDefSource vendorSection = this.addSectionToSection(parent);
        vendorSection.setUsedIf(this.createUsedIf(JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_GENERIC_DATABASE_TYPE, vendorName));
        JDBCDriverInfo[] driverInfos = this.getDriverInfos(vendorName);
        String driverPropertyName = JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.genericDatabaseDriverProperty(vendorName));
        FormSectionDefSource section = this.addSectionToSection(vendorSection);
        this.createSelectDriverProperty(section, driverPropertyName, driverInfos);
        for (JDBCDriverInfo driverInfo : driverInfos) {
            this.addDriverTransactionsSection(vendorSection, "GENERIC", driverPropertyName, driverInfo);
            this.addDriverConnectionPropertiesSection(vendorSection, "GENERIC", driverPropertyName, driverInfo);
        }
    }

    private void addGenericOtherDatabaseDriverSection(FormSectionDefSource parent) {
        FormSectionDefSource section = this.addSectionToSection(parent);
        section.setUsedIf(this.createUsedIf(JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_GENERIC_DATABASE_TYPE, JDBCSystemResourceMBeanCustomizerUtils.GENERIC_OTHER_DATABASE));
        BeanPropertyDefCustomizerSource property = this.addMBeanPropertyToSection(section, "JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol");
        property.setFormName(JDBCSystemResourceMBeanCustomizerUtils.otherDatabaseScopedName("JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol"));
        this.addOtherDatabaseConnectionProperty(section, "DbmsUsername");
        this.addOtherDatabaseConnectionProperty(section, "DbmsPassword");
    }

    private void addGridLinkSection() {
        FormSectionDefSource section = this.addSectionToForm();
        section.setUsedIf(this.createUsedIf("JDBCResource.DatasourceType", "AGL"));
        this.addGridLinkDatabaseDriverSection(section);
        String driverPropertyName = JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_GRIDLINK_DATABASE_DRIVER;
        for (JDBCDriverInfo driverInfo : this.getGridLinkDriverInfos()) {
            this.addDriverTransactionsSection(section, "AGL", driverPropertyName, driverInfo);
            this.addGridLinkConnectionPropertiesSection(section, "AGL", driverPropertyName, driverInfo);
            this.addGridLinkONSSection(section, driverPropertyName, driverInfo);
        }
    }

    private void addGridLinkDatabaseDriverSection(FormSectionDefSource parent) {
        FormSectionDefSource section = this.addSectionToSection(parent);
        BeanPropertyDefCustomizerSource property = this.createSelectDriverProperty(section, JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_GRIDLINK_DATABASE_DRIVER, this.getGridLinkDriverInfos());
        this.setDefaultValue(property, "*Oracle's Driver (Thin) for GridLink Connections; Versions:Any");
    }

    private void addGridLinkConnectionPropertiesSection(FormSectionDefSource parent, String datasourceType, String driverPropertyName, JDBCDriverInfo driverInfo) {
        FormSectionDefSource section = this.createEmptyDriverConnectionPropertiesSection(parent, driverPropertyName, driverInfo);
        BeanPropertyDefCustomizerSource property = this.addNonMBeanStringPropertyToSection(section, JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName("AGL", driverInfo, "Listeners")), "Listeners", "Specify the host and port of each listener (separated by colon). In the case of a RAC DB listener, specify the SCAN address.");
        this.setDefaultValue(property, null);
        property.getDefinition().setArray(true);
        this.setInlineFieldHelp(property, "host:portNumber\nhost2:portNumber2");
        this.createDriverConnectionProperties(section, datasourceType, driverInfo);
    }

    private void addGridLinkONSSection(FormSectionDefSource parent, String driverPropertyName, JDBCDriverInfo driverInfo) {
        FormSectionDefSource section = this.addSectionToSection(parent);
        section.setTitle("ONS Client Configuration");
        section.setIntroductionHTML("Specify the ONS client configuration.");
        section.setUsedIf(this.createUsedIf(driverPropertyName, JDBCSystemResourceMBeanCustomizerUtils.driverName(driverInfo)));
        this.addMBeanPropertyToSection(section, "JDBCResource.JDBCOracleParams.FanEnabled").setFormName(JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName("AGL", driverInfo, "FanEnabled")));
        this.addMBeanPropertyToSection(section, "JDBCResource.JDBCOracleParams.OnsNodeList").setFormName(JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName("AGL", driverInfo, "OnsNodeList")));
        this.addMBeanPropertyToSection(section, "JDBCResource.JDBCOracleParams.OnsWalletFile").setFormName(JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName("AGL", driverInfo, "OnsWalletFile")));
        this.addMBeanPropertyToSection(section, "JDBCResource.JDBCOracleParams.OnsWalletPassword").setFormName(JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName("AGL", driverInfo, "OnsWalletPassword")));
    }

    private void addUCPSection() {
        FormSectionDefSource section = this.addSectionToForm();
        section.setUsedIf(this.createUsedIf("JDBCResource.DatasourceType", "UCP"));
        this.addUCPDatabaseDriverSection(section);
        for (JDBCDriverInfo driverInfo : this.getUCPDriverInfos()) {
            this.addUCPUrlSection(section, driverInfo);
            this.addDriverConnectionPropertiesSection(section, "UCP", JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_UCP_DATABASE_DRIVER, driverInfo);
        }
    }

    private void addUCPDatabaseDriverSection(FormSectionDefSource parent) {
        FormSectionDefSource section = this.addSectionToSection(parent);
        this.createSelectDriverProperty(section, JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_UCP_DATABASE_DRIVER, this.getUCPDriverInfos());
    }

    private void addUCPUrlSection(FormSectionDefSource parent, JDBCDriverInfo driverInfo) {
        FormSectionDefSource section = this.addSectionToSection(parent);
        section.setUsedIf(this.createUsedIf(JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_UCP_DATABASE_DRIVER, JDBCSystemResourceMBeanCustomizerUtils.driverName(driverInfo)));
        this.addMBeanPropertyToSection(section, "JDBCResource.JDBCDriverParams.Url").setFormName(JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName("UCP", driverInfo, "Url")));
    }

    private void addOtherDatabaseConnectionProperty(FormSectionDefSource section, String propertyName) {
        BeanPropertyDefCustomizerSource property = this.addNonMBeanStringPropertyToSection(section, JDBCSystemResourceMBeanCustomizerUtils.otherDatabaseScopedName(propertyName), this.getDriverConnectionPropertyLabel(propertyName), this.getDefaultDriverConnectionPropertyDescriptionHTML(propertyName));
        property.setRequired(false);
    }

    private BeanPropertyDefCustomizerSource createSelectDriverProperty(FormSectionDefSource section, String driverPropertyName, JDBCDriverInfo[] driverInfos) {
        BeanPropertyDefCustomizerSource property = this.addNonMBeanStringPropertyToSection(section, driverPropertyName, "Database Driver", "Select the database driver");
        this.setDefaultValue(property, JDBCSystemResourceMBeanCustomizerUtils.driverName(driverInfos[0]));
        for (JDBCDriverInfo driverInfo : driverInfos) {
            this.addLegalValue(property, JDBCSystemResourceMBeanCustomizerUtils.driverName(driverInfo));
        }
        return property;
    }

    private void addDriverTransactionsSection(FormSectionDefSource parent, String datasourceType, String driverPropertyName, JDBCDriverInfo driverInfo) {
        FormSectionDefSource section = this.addSectionToSection(parent);
        section.setTitle("Transactions");
        section.setUsedIf(this.createUsedIf(driverPropertyName, JDBCSystemResourceMBeanCustomizerUtils.driverName(driverInfo)));
        if (driverInfo.isForXA()) {
            section.setName("JDBCSystemResourceMBean.Transactions.XA");
            section.setIntroductionHTML("You have selected an XA JDBC driver to use to create a database connection in your new data source. The data source will support global transactions and use the 'Two-Phase Commit' global transaction protocol. No other transaction configuration options are available.");
        } else {
            section.setName("JDBCSystemResourceMBean.Transactions.nonXA");
            section.setIntroductionHTML("You have selected a non-XA JDBC driver. Specify how transactions should be handled.");
            BeanPropertyDefCustomizerSource property = this.addMBeanPropertyToSection(section, "JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol");
            property.setFormName(JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName(datasourceType, driverInfo, "GlobalTransactionsProtocol")));
            LegalValueDefCustomizerSource twoPhase = new LegalValueDefCustomizerSource();
            twoPhase.setOmit(true);
            twoPhase.setValue("TwoPhaseCommit");
            property.setLegalValues(List.of(twoPhase));
        }
    }

    private void addDriverConnectionPropertiesSection(FormSectionDefSource parent, String datasourceType, String driverPropertyName, JDBCDriverInfo driverInfo) {
        FormSectionDefSource section = this.createEmptyDriverConnectionPropertiesSection(parent, driverPropertyName, driverInfo);
        this.createDriverConnectionProperties(section, datasourceType, driverInfo);
    }

    private FormSectionDefSource createEmptyDriverConnectionPropertiesSection(FormSectionDefSource parent, String driverPropertyName, JDBCDriverInfo driverInfo) {
        FormSectionDefSource section = this.addSectionToSection(parent);
        section.setTitle("Connection Properties");
        section.setIntroductionHTML("Specify the connection properties.");
        section.setUsedIf(this.createUsedIf(driverPropertyName, JDBCSystemResourceMBeanCustomizerUtils.driverName(driverInfo)));
        return section;
    }

    private void createDriverConnectionProperties(FormSectionDefSource section, String datasourceType, JDBCDriverInfo driverInfo) {
        this.createWellKnownDriverConnectionProperties(section, datasourceType, driverInfo);
        this.createCustomDriverConnectionProperties(section, datasourceType, driverInfo);
    }

    private void createWellKnownDriverConnectionProperties(FormSectionDefSource section, String datasourceType, JDBCDriverInfo driverInfo) {
        for (String name : WELL_KNOWN_DRIVER_ATTRIBUTES) {
            JDBCDriverAttribute driverAttribute = JDBCSystemResourceMBeanCustomizerUtils.getDriverAttributes(driverInfo).get(name);
            if (driverAttribute == null) continue;
            this.createDriverConnectionProperty(section, datasourceType, driverInfo, driverAttribute);
        }
    }

    private void createCustomDriverConnectionProperties(FormSectionDefSource section, String datasourceType, JDBCDriverInfo driverInfo) {
        for (JDBCDriverAttribute driverAttribute : JDBCSystemResourceMBeanCustomizerUtils.getDriverAttributes(driverInfo).values()) {
            if (!this.isCustomDriverAttribute(driverAttribute)) continue;
            this.createDriverConnectionProperty(section, datasourceType, driverInfo, driverAttribute);
        }
    }

    private void createDriverConnectionProperty(FormSectionDefSource section, String datasourceType, JDBCDriverInfo driverInfo, JDBCDriverAttribute driverAttribute) {
        String name = driverAttribute.getName();
        BeanPropertyDefCustomizerSource property = this.addNonMBeanStringPropertyToSection(section, JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName(datasourceType, driverInfo, name)), this.getDriverConnectionPropertyLabel(name), this.getDriverConnectionPropertyDescriptionHTML(driverAttribute));
        String defaultValue = driverAttribute.getDefaultValue();
        if ("UCP".equals(datasourceType) && "ConnectionFactoryClassName".equals(name)) {
            defaultValue = driverInfo.getDriverClassName();
        }
        this.setDefaultValue(property, defaultValue);
        if (name.contains(".")) {
            property.setUseUnlocalizedNameAsLabel(true);
        }
        if (driverAttribute.isEncrypted()) {
            property.getDefinition().setEncrypted(true);
        }
        property.setRequired(driverAttribute.isRequired());
        property.setSupportsModelTokens(true);
    }

    private String getDriverConnectionPropertyLabel(String attributeName) {
        if ("DbmsName".equals(attributeName)) {
            return "Database Name";
        }
        if ("DbmsHost".equals(attributeName)) {
            return "Host Name";
        }
        if ("DbmsPort".equals(attributeName)) {
            return "Port";
        }
        if ("DbmsUsername".equals(attributeName)) {
            return "Database User Name";
        }
        if ("DbmsPassword".equals(attributeName)) {
            return "Password";
        }
        if (PROPERTY_SERVICE_NAME.equals(attributeName)) {
            return "Service Name";
        }
        if (attributeName.contains(".")) {
            return attributeName;
        }
        return StringUtils.camelCaseToUpperCaseWords((String)attributeName);
    }

    private String getDriverConnectionPropertyDescriptionHTML(JDBCDriverAttribute driverAttribute) {
        String description = driverAttribute.getDescription();
        if (description != null && !"Unused".equals(description)) {
            return description;
        }
        return this.getDefaultDriverConnectionPropertyDescriptionHTML(driverAttribute.getName());
    }

    private String getDefaultDriverConnectionPropertyDescriptionHTML(String attributeName) {
        if ("DbmsName".equals(attributeName)) {
            return "The name of the database to connect to.";
        }
        if ("DbmsHost".equals(attributeName)) {
            return "The name or IP address of the database server.";
        }
        if ("DbmsPort".equals(attributeName)) {
            return "The port on the database server used to connect to the database.";
        }
        if ("DbmsUsername".equals(attributeName)) {
            return "The database account user name to use to create database connections.";
        }
        if ("DbmsPassword".equals(attributeName)) {
            return "The database account password to use to create database connections.";
        }
        if (PROPERTY_SERVICE_NAME.equals(attributeName)) {
            return "The service name of the database to connect to.";
        }
        return null;
    }

    private JDBCDriverInfo[] getDriverInfos(String vendorName) {
        try {
            return JDBCSystemResourceMBeanCustomizerUtils.getDriverInfoFactory().getDriverInfos(vendorName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JDBCDriverInfo[] getGridLinkDriverInfos() {
        try {
            return JDBCSystemResourceMBeanCustomizerUtils.getDriverInfoFactory().getGridLinkDriverInfos();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JDBCDriverInfo[] getUCPDriverInfos() {
        try {
            return JDBCSystemResourceMBeanCustomizerUtils.getDriverInfoFactory().getUCPDriverInfos();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isCustomDriverAttribute(JDBCDriverAttribute driverAttribute) {
        return !WELL_KNOWN_DRIVER_ATTRIBUTES.contains(driverAttribute.getName());
    }

    static {
        WELL_KNOWN_DRIVER_ATTRIBUTES.add("DbmsName");
        WELL_KNOWN_DRIVER_ATTRIBUTES.add("DbmsHost");
        WELL_KNOWN_DRIVER_ATTRIBUTES.add("DbmsPort");
        WELL_KNOWN_DRIVER_ATTRIBUTES.add("DbmsUsername");
        WELL_KNOWN_DRIVER_ATTRIBUTES.add("DbmsPassword");
        WELL_KNOWN_DRIVER_ATTRIBUTES.add(PROPERTY_SERVICE_NAME);
    }
}

