/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.json.JsonObject;
import javax.ws.rs.core.Response;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.customizers.JDBCSystemResourceMBeanCustomizerUtils;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverAttribute;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelperFactory;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BeanPropertyValue;
import weblogic.remoteconsole.server.repo.BeanPropertyValues;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeansPropertyValues;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.CreateFormCreator;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.SecretValue;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.CreatableBeanCollectionResource;
import weblogic.remoteconsole.server.webapp.CreateHelper;
import weblogic.remoteconsole.server.webapp.GetPageResponseMapper;

public class JDBCSystemResourceMBeanCreatableCollectionResource
extends CreatableBeanCollectionResource {
    @Override
    protected Response createCollectionChild(JsonObject requestBody) {
        return new JDBCSystemResourceMBeanCreator().createBean(this.getInvocationContext(), requestBody);
    }

    @Override
    protected Response getCreateForm() {
        weblogic.remoteconsole.server.repo.Response<Page> response = this.getInvocationContext().getPageRepo().asPageReaderRepo().getPage(this.getInvocationContext());
        if (response.isSuccess()) {
            List<FormProperty> properties = response.getResults().asForm().getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                FormProperty prop = properties.get(i);
                String name = prop.getFieldDef().asBeanPropertyDef().getPropertyPath().getDotSeparatedPath();
                if ("JDBCResource.DatasourceType".equals(name)) {
                    properties.set(i, this.customizeDataSourceType(prop));
                    continue;
                }
                if (!"JDBCResource.JDBCOracleParams.FanEnabled".equals(name)) continue;
                properties.set(i, this.customizeGridLinkFanEnabled(prop));
            }
        }
        return GetPageResponseMapper.toResponse(this.getInvocationContext(), response);
    }

    private FormProperty customizeDataSourceType(FormProperty property) {
        return new FormProperty(property.getFieldDef(), new SettableValue((Value)new StringValue("GENERIC"), false));
    }

    private FormProperty customizeGridLinkFanEnabled(FormProperty property) {
        return new FormProperty(property.getFieldDef(), new SettableValue((Value)new BooleanValue(true), false));
    }

    private JDBCURLHelper createJDBCURLHelper(JDBCDriverInfo driverInfo) {
        try {
            return JDBCURLHelperFactory.newInstance().getJDBCURLHelper(driverInfo);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private JDBCDriverInfo createDriverInfo(String driverName) {
        return JDBCSystemResourceMBeanCustomizerUtils.getDriverInfoFactory().getDriverInfo(driverName);
    }

    private class JDBCSystemResourceMBeanCreator
    extends CreateHelper {
        private JDBCSystemResourceMBeanCreator() {
        }

        @Override
        protected weblogic.remoteconsole.server.repo.Response<Void> createBean(InvocationContext ic, List<FormProperty> formProperties) {
            FormPropertiesToBeansPropertyValuesConverter converter = new FormPropertiesToBeansPropertyValuesConverter(ic, formProperties);
            weblogic.remoteconsole.server.repo.Response<Void> response = converter.convert();
            if (!response.isSuccess()) {
                return response;
            }
            response = new CreateFormCreator(ic, converter.getDataSourceValues()).create();
            if (!response.isSuccess()) {
                return response;
            }
            for (BeansPropertyValues dataSourcePropertyValues : converter.getDataSourcePropertiesValues()) {
                response = new CreateFormCreator(ic, dataSourcePropertyValues).create();
                if (response.isSuccess()) continue;
                return response;
            }
            return new weblogic.remoteconsole.server.repo.Response<Void>();
        }
    }

    private class FormPropertiesToBeansPropertyValuesConverter {
        private static final String PROPERTY_NAME = "Name";
        private InvocationContext ic;
        private List<FormProperty> formProperties;
        private BeansPropertyValues dataSourceValues;
        private List<BeansPropertyValues> dataSourcePropertiesValues = new ArrayList<BeansPropertyValues>();
        private weblogic.remoteconsole.server.repo.Response<Void> response = new weblogic.remoteconsole.server.repo.Response();

        private FormPropertiesToBeansPropertyValuesConverter(InvocationContext ic, List<FormProperty> formProperties) {
            this.ic = ic;
            this.formProperties = formProperties;
            this.dataSourceValues = new BeansPropertyValues(ic.getBeanTreePath());
        }

        private Value findRequiredDataSourceValue(String propertyName) {
            return this.findRequiredPropertyValue(this.dataSourceValues, propertyName);
        }

        private Value findOptionalDataSourceValue(String propertyName) {
            return this.findOptionalPropertyValue(this.dataSourceValues, propertyName);
        }

        private Value findRequiredPropertyValue(BeansPropertyValues beansValues, String propertyName) {
            Value value = this.findOptionalPropertyValue(beansValues, propertyName);
            if (value == null) {
                throw new AssertionError((Object)("Can't find " + propertyName));
            }
            return value;
        }

        private Value findOptionalPropertyValue(BeansPropertyValues beansValues, String propertyName) {
            for (BeanPropertyValues beanValues : beansValues.getSortedBeansPropertyValues()) {
                for (BeanPropertyValue value : beanValues.getPropertyValues()) {
                    if (!propertyName.equals(value.getPropertyDef().getPropertyName())) continue;
                    return value.getValue().asSettable().getValue();
                }
            }
            return null;
        }

        private Properties getDataSourceProperties() {
            Properties properties = new Properties();
            for (BeansPropertyValues beansValues : this.dataSourcePropertiesValues) {
                Value nameValue = this.findRequiredPropertyValue(beansValues, PROPERTY_NAME);
                Value valueValue = this.findRequiredPropertyValue(beansValues, "Value");
                String name = nameValue.asString().getValue();
                String value = valueValue.asString().getValue();
                properties.setProperty(name, value);
            }
            return properties;
        }

        private BeansPropertyValues getDataSourceValues() {
            return this.dataSourceValues;
        }

        private List<BeansPropertyValues> getDataSourcePropertiesValues() {
            return this.dataSourcePropertiesValues;
        }

        private weblogic.remoteconsole.server.repo.Response<Void> convert() {
            this.convertProperties();
            return this.response;
        }

        private void convertProperties() {
            this.addName();
            this.addOptionalMBeanProperty("Targets");
            this.addOptionalMBeanProperty("JDBCResource.JDBCDataSourceParams.JNDINames");
            String dataSourceType = this.addDataSourceType();
            if (this.isOK()) {
                this.addDataSourceTypeSpecificProperties(dataSourceType);
            }
        }

        private void addName() {
            FormProperty formProperty = this.findRequiredFormProperty(PROPERTY_NAME);
            if (this.isOK()) {
                SettableValue nameValue = this.getFormPropertyValue(formProperty);
                this.addPropertyValue(PROPERTY_NAME, nameValue);
                if (JDBCSystemResourceMBeanCreatableCollectionResource.this.getInvocationContext().getPageRepo().isChangeManagerPageRepo()) {
                    this.addPropertyValue("JDBCResource.Name", nameValue);
                }
            }
        }

        private String addDataSourceType() {
            FormProperty formProperty = this.findRequiredFormProperty("JDBCResource.DatasourceType");
            if (this.isOK()) {
                SettableValue value = this.getFormPropertyValue(formProperty);
                this.addPropertyValue("JDBCResource.DatasourceType", value);
                return value.getValue().asString().getValue();
            }
            return null;
        }

        private void addDataSourceTypeSpecificProperties(String dataSourceType) {
            if ("GENERIC".equals(dataSourceType)) {
                this.addGenericProperties();
                return;
            }
            if ("AGL".equals(dataSourceType)) {
                this.addGridLinkProperties();
                return;
            }
            if ("UCP".equals(dataSourceType)) {
                this.addUCPProperties();
                return;
            }
            if ("MDS".equals(dataSourceType)) {
                this.addMDSProperties();
                return;
            }
            this.badFrontEndRequest("Illegal JDBCResource.DatasourceType : " + dataSourceType);
        }

        private void addGenericProperties() {
            String vendorName = this.getVendorName();
            if (!this.isOK()) {
                return;
            }
            if (JDBCSystemResourceMBeanCustomizerUtils.GENERIC_OTHER_DATABASE.equals(vendorName)) {
                this.addOtherDatabaseProperties();
                return;
            }
            JDBCDriverInfo driverInfo = this.getDriverInfo(JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.genericDatabaseDriverProperty(vendorName)));
            if (!this.isOK()) {
                return;
            }
            this.addTransactionProperties("GENERIC", driverInfo);
            if (!this.isOK()) {
                return;
            }
            this.addConnectionProperties("GENERIC", driverInfo);
        }

        private void addGridLinkProperties() {
            JDBCDriverInfo driverInfo = this.getDriverInfo(JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_GRIDLINK_DATABASE_DRIVER);
            if (!this.isOK()) {
                return;
            }
            this.addGridLinkListenersToDriverInfo(driverInfo);
            if (!this.isOK()) {
                return;
            }
            this.addTransactionProperties("AGL", driverInfo);
            if (!this.isOK()) {
                return;
            }
            this.addConnectionProperties("AGL", driverInfo);
            if (!this.isOK()) {
                return;
            }
            this.addGridLinkONSProperties();
        }

        private void addUCPProperties() {
            JDBCDriverInfo driverInfo = this.getDriverInfo(JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_UCP_DATABASE_DRIVER);
            if (!this.isOK()) {
                return;
            }
            this.addConnectionProperties("UCP", driverInfo);
        }

        private void addMDSProperties() {
            this.addOptionalMBeanProperty("JDBCResource.JDBCDataSourceParams.AlgorithmType");
            this.addMDSDataSourceList();
        }

        private void addMDSDataSourceList() {
            String dataSourceList = this.getMDSDataSourceList();
            if (!this.isOK()) {
                return;
            }
            this.addPropertyValue("JDBCResource.JDBCDataSourceParams.DataSourceList", new SettableValue((Value)new StringValue(dataSourceList), true));
        }

        private String getMDSDataSourceList() {
            ArrayValue dataSources = this.getMDSDataSources();
            if (!this.isOK()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Value dataSource : dataSources.getValues()) {
                String dataSourceName = dataSource.asBeanTreePath().getLastSegment().getKey();
                if (!first) {
                    sb.append(",");
                }
                sb.append(dataSourceName);
                first = false;
            }
            return sb.toString();
        }

        private ArrayValue getMDSDataSources() {
            FormProperty xaProp = this.findRequiredFormProperty("MDS_XADriver");
            if (!this.isOK()) {
                return null;
            }
            boolean isXA = this.getFormPropertyValue(xaProp).getValue().asBoolean().getValue();
            String dataSourcesPropertyName = isXA ? "MDS_XADataSources" : "MDS_NonXADataSources";
            FormProperty dataSourcesProp = this.findRequiredFormProperty(dataSourcesPropertyName);
            if (!this.isOK()) {
                return null;
            }
            return this.getFormPropertyValue(dataSourcesProp).getValue().asArray();
        }

        private void addGridLinkListenersToDriverInfo(JDBCDriverInfo driverInfo) {
            FormProperty formProperty = this.findRequiredFormProperty(JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName("AGL", driverInfo, "Listeners")));
            if (!this.isOK()) {
                return;
            }
            StringBuilder hostPorts = new StringBuilder();
            ArrayValue listeners = this.getFormPropertyValue(formProperty).getValue().asArray();
            boolean first = true;
            for (Value listener : listeners.getValues()) {
                String hostPort = listener.asString().getValue();
                String[] hp = hostPort.split(":");
                if (hp != null && hp.length == 2 && StringUtils.isInteger((String)hp[1])) {
                    if (!first) {
                        hostPorts.append(",");
                    }
                } else {
                    this.badUserRequest(JDBCSystemResourceMBeanCreatableCollectionResource.this.getInvocationContext().getLocalizer().localizeString(LocalizedConstants.INVALID_GRID_LINK_LISTENER, hostPort));
                    return;
                }
                hostPorts.append(hostPort);
                first = false;
            }
            driverInfo.getHostPorts().setList(hostPorts.toString());
        }

        private void addGridLinkONSProperties() {
            this.addOptionalMBeanProperty("JDBCResource.JDBCOracleParams.FanEnabled");
            this.addOptionalMBeanProperty("JDBCResource.JDBCOracleParams.OnsNodeList");
            this.addOptionalMBeanProperty("JDBCResource.JDBCOracleParams.OnsWalletFile");
            this.addOptionalMBeanProperty("JDBCResource.JDBCOracleParams.OnsWalletPassword");
        }

        private void addOtherDatabaseProperties() {
            String protocol = this.getRequiredStringProperty("JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol");
            if (!this.isOK()) {
                return;
            }
            if (!"OnePhaseCommit".equals(protocol)) {
                this.addPropertyValue("JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol", new SettableValue((Value)new StringValue(protocol), true));
            }
            String password = this.getOptionalStringProperty(JDBCSystemResourceMBeanCustomizerUtils.otherDatabaseScopedName("DbmsUsername"));
            if (!this.isOK()) {
                return;
            }
            if (!StringUtils.isEmpty((String)password)) {
                this.addPropertyValue("JDBCResource.JDBCDriverParams.Password", new SettableValue((Value)new SecretValue(password), true));
            }
            String user = this.getOptionalStringProperty(JDBCSystemResourceMBeanCustomizerUtils.otherDatabaseScopedName("DbmsUsername"));
            if (!this.isOK()) {
                return;
            }
            if (!StringUtils.isEmpty((String)user)) {
                Properties properties = new Properties();
                properties.setProperty("user", user);
                this.recordDataSourcePropertiesValues(properties);
            }
        }

        private void addTransactionProperties(String dataSourceType, JDBCDriverInfo driverInfo) {
            String protocol = null;
            if (driverInfo.isForXA()) {
                protocol = "TwoPhaseCommit";
            } else {
                protocol = this.getRequiredStringProperty("JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol");
                if (!this.isOK()) {
                    return;
                }
            }
            if (!"OnePhaseCommit".equals(protocol)) {
                this.addPropertyValue("JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol", new SettableValue((Value)new StringValue(protocol), true));
            }
        }

        private void addConnectionProperties(String dataSourceType, JDBCDriverInfo driverInfo) {
            this.populateDriverInfo(dataSourceType, driverInfo);
            if (!this.isOK()) {
                return;
            }
            this.convertDriverInfoToMBeanProperties(dataSourceType, driverInfo);
        }

        private void convertDriverInfoToMBeanProperties(String datasourceType, JDBCDriverInfo driverInfo) {
            boolean isUCP = "UCP".equals(datasourceType);
            String driverClassName = driverInfo.getDriverClassName();
            if (isUCP) {
                driverClassName = driverClassName.indexOf("XA") == -1 ? "oracle.ucp.jdbc.PoolDataSourceImpl" : "oracle.ucp.jdbc.PoolXADataSourceImpl";
            }
            this.addPropertyValue("JDBCResource.JDBCDriverParams.DriverName", new SettableValue((Value)new StringValue(driverClassName), true));
            if (!isUCP) {
                this.addPropertyValue("JDBCResource.JDBCConnectionPoolParams.TestTableName", new SettableValue(new StringValue("SQL " + driverInfo.getTestSQL())));
            }
            JDBCURLHelper helper = JDBCSystemResourceMBeanCreatableCollectionResource.this.createJDBCURLHelper(driverInfo);
            if (datasourceType != "UCP") {
                String url = null;
                try {
                    url = helper.getURL();
                }
                catch (JDBCDriverInfoException e) {
                    this.badUserRequest(e.getLocalizedMessage());
                    return;
                }
                this.addPropertyValue("JDBCResource.JDBCDriverParams.Url", new SettableValue((Value)new StringValue(url), true));
            } else {
                this.addOptionalMBeanProperty("JDBCResource.JDBCDriverParams.Url");
            }
            String password = driverInfo.getPassword();
            if (!StringUtils.isEmpty((String)password)) {
                this.addPropertyValue("JDBCResource.JDBCDriverParams.Password", new SettableValue((Value)new SecretValue(password), true));
            }
            Properties properties = null;
            try {
                properties = helper.getProperties();
            }
            catch (JDBCDriverInfoException e) {
                this.badUserRequest(e.getLocalizedMessage());
                return;
            }
            this.recordDataSourcePropertiesValues(properties);
        }

        private void recordDataSourcePropertiesValues(Properties properties) {
            if (properties == null) {
                return;
            }
            BeanTreePath dataSourcesBeanTreePath = JDBCSystemResourceMBeanCreatableCollectionResource.this.getInvocationContext().getBeanTreePath();
            Path propertiesCollectionPath = dataSourcesBeanTreePath.getPath().childPath(this.getRequiredStringProperty(PROPERTY_NAME)).childPath(new Path("JDBCResource.JDBCDriverParams.Properties.Properties"));
            BeanTreePath propertiesCollectionBeanTreePath = BeanTreePath.create(dataSourcesBeanTreePath.getBeanRepo(), propertiesCollectionPath);
            for (String name : properties.stringPropertyNames()) {
                this.recordDataSourcePropertyValues(propertiesCollectionBeanTreePath, name, properties.getProperty(name));
            }
        }

        private void recordDataSourcePropertyValues(BeanTreePath propertiesCollectionBeanTreePath, String name, String value) {
            BeansPropertyValues propertyValues = new BeansPropertyValues(propertiesCollectionBeanTreePath);
            propertyValues.addPropertyValue(new BeanPropertyValue(propertiesCollectionBeanTreePath.getTypeDef().getPropertyDef(new Path(PROPERTY_NAME)), new SettableValue((Value)new StringValue(name), true)));
            propertyValues.addPropertyValue(new BeanPropertyValue(propertiesCollectionBeanTreePath.getTypeDef().getPropertyDef(new Path("Value")), new SettableValue((Value)new StringValue(value), true)));
            this.dataSourcePropertiesValues.add(propertyValues);
        }

        private void populateDriverInfo(String dataSourceType, JDBCDriverInfo driverInfo) {
            driverInfo.setFillRequired(false);
            this.addWellKnownConnectionProperties(dataSourceType, driverInfo);
            if (this.isOK()) {
                this.addCustomConnectionProperties(dataSourceType, driverInfo);
            }
        }

        private void addWellKnownConnectionProperties(String dataSourceType, JDBCDriverInfo driverInfo) {
            this.addDbmsName(dataSourceType, driverInfo);
            this.addDbmsHost(dataSourceType, driverInfo);
            this.addDbmsPort(dataSourceType, driverInfo);
            this.addDbmsUserName(dataSourceType, driverInfo);
            this.addDbmsPassword(dataSourceType, driverInfo);
        }

        private void addDbmsName(String dataSourceType, JDBCDriverInfo driverInfo) {
            if (this.supportsWellKnownConnectionProperty(driverInfo, "DbmsName")) {
                String value = this.getWellKnownConnectionProperty(dataSourceType, driverInfo, "DbmsName");
                if (this.isOK() && !StringUtils.isEmpty((String)value)) {
                    driverInfo.setDbmsName(value);
                }
            }
        }

        private void addDbmsHost(String dataSourceType, JDBCDriverInfo driverInfo) {
            if (this.supportsWellKnownConnectionProperty(driverInfo, "DbmsHost")) {
                String value = this.getWellKnownConnectionProperty(dataSourceType, driverInfo, "DbmsHost");
                if (this.isOK() && !StringUtils.isEmpty((String)value)) {
                    driverInfo.setDbmsHost(value);
                }
            }
        }

        private void addDbmsPort(String dataSourceType, JDBCDriverInfo driverInfo) {
            if (!this.supportsWellKnownConnectionProperty(driverInfo, "DbmsPort")) {
                return;
            }
            String value = this.getWellKnownConnectionProperty(dataSourceType, driverInfo, "DbmsPort");
            if (!this.isOK() || StringUtils.isEmpty((String)value)) {
                return;
            }
            FormProperty formProperty = this.findFormProperty(JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName(dataSourceType, driverInfo, "DbmsPort")));
            if (formProperty != null && !this.getFormPropertyValue(formProperty).getValue().isModelToken() && !StringUtils.isInteger((String)value)) {
                this.badUserRequest(JDBCSystemResourceMBeanCreatableCollectionResource.this.getInvocationContext().getLocalizer().localizeString(LocalizedConstants.INVALID_PORT, value));
                return;
            }
            driverInfo.setDbmsPort(value);
        }

        private void addDbmsUserName(String dataSourceType, JDBCDriverInfo driverInfo) {
            if (this.supportsWellKnownConnectionProperty(driverInfo, "DbmsUsername")) {
                String value = this.getWellKnownConnectionProperty(dataSourceType, driverInfo, "DbmsUsername");
                if (this.isOK() && !StringUtils.isEmpty((String)value)) {
                    driverInfo.setUserName(value);
                }
            }
        }

        private void addDbmsPassword(String dataSourceType, JDBCDriverInfo driverInfo) {
            if (this.supportsWellKnownConnectionProperty(driverInfo, "DbmsPassword")) {
                String value = this.getWellKnownConnectionProperty(dataSourceType, driverInfo, "DbmsPassword");
                if (this.isOK() && !StringUtils.isEmpty((String)value)) {
                    driverInfo.setPassword(value);
                }
            }
        }

        private String getWellKnownConnectionProperty(String dataSourceType, JDBCDriverInfo driverInfo, String propertyName) {
            String formPropertyName = JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName(dataSourceType, driverInfo, propertyName));
            JDBCDriverAttribute driverAttribute = driverInfo.getDriverAttributes().get(propertyName);
            boolean required = driverAttribute.isRequired();
            String defaultValue = driverAttribute.getDefaultValue();
            if (required && StringUtils.isEmpty((String)defaultValue)) {
                return this.getRequiredStringProperty(formPropertyName);
            }
            String value = this.getOptionalStringProperty(formPropertyName);
            if (!StringUtils.isEmpty((String)value)) {
                return value;
            }
            if (!required) {
                return null;
            }
            return defaultValue;
        }

        private boolean supportsWellKnownConnectionProperty(JDBCDriverInfo driverInfo, String propertyName) {
            return driverInfo.getDriverAttributes().containsKey(propertyName);
        }

        private void addCustomConnectionProperties(String dataSourceType, JDBCDriverInfo driverInfo) {
            for (JDBCDriverAttribute driverAttribute : driverInfo.getUnknownDriverAttributes().values()) {
                this.addCustomConnectionProperty(dataSourceType, driverInfo, driverAttribute);
                if (this.isOK()) continue;
                return;
            }
        }

        private void addCustomConnectionProperty(String dataSourceType, JDBCDriverInfo driverInfo, JDBCDriverAttribute driverAttribute) {
            String propertyName = driverAttribute.getName();
            String formPropertyName = JDBCSystemResourceMBeanCustomizerUtils.driverNameToFormPropertyName(JDBCSystemResourceMBeanCustomizerUtils.driverScopedName(dataSourceType, driverInfo, propertyName));
            boolean required = driverAttribute.isRequired();
            FormProperty formProperty = null;
            if (required) {
                formProperty = this.findRequiredFormProperty(formPropertyName);
                if (!this.isOK()) {
                    return;
                }
            } else {
                formProperty = this.findFormProperty(formPropertyName);
            }
            if (!required && formProperty == null) {
                return;
            }
            String value = null;
            value = formProperty != null ? this.getOptionalStringProperty(formPropertyName) : driverAttribute.getDefaultValue();
            driverInfo.setUknownAttribute(propertyName, value);
        }

        private String getVendorName() {
            String vn = this.getRequiredStringProperty(JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_GENERIC_DATABASE_TYPE);
            if (this.isOK()) {
                if (JDBCSystemResourceMBeanCustomizerUtils.GENERIC_OTHER_DATABASE.equals(vn)) {
                    return vn;
                }
                for (String vendorName : JDBCSystemResourceMBeanCustomizerUtils.getDBMSVendorNames()) {
                    if (!vendorName.equals(vn)) continue;
                    return vn;
                }
                this.badFrontEndRequest("Illegal " + JDBCSystemResourceMBeanCustomizerUtils.PROPERTY_GENERIC_DATABASE_TYPE + " : " + vn);
            }
            return null;
        }

        private JDBCDriverInfo getDriverInfo(String driverProperty) {
            String driverName = this.getRequiredStringProperty(driverProperty);
            if (this.isOK()) {
                JDBCDriverInfo driverInfo = JDBCSystemResourceMBeanCreatableCollectionResource.this.createDriverInfo(driverName);
                if (driverInfo != null) {
                    return driverInfo;
                }
                this.badFrontEndRequest("Illegal " + driverProperty + " : " + driverName);
            }
            return null;
        }

        private void addOptionalMBeanProperty(String propertyName) {
            FormProperty formProperty = this.findFormProperty(propertyName);
            if (formProperty != null) {
                this.addPropertyValue(propertyName, this.getFormPropertyValue(formProperty));
            }
        }

        private void addPropertyValue(String beanPropertyName, SettableValue value) {
            this.dataSourceValues.addPropertyValue(new BeanPropertyValue(this.ic.getBeanTreePath().getTypeDef().getPropertyDef(new Path(beanPropertyName)), value));
        }

        private String getRequiredStringProperty(String propertyName) {
            FormProperty formProperty = this.findRequiredFormProperty(propertyName);
            if (this.isOK()) {
                String value = this.getStringValue(formProperty);
                if (!StringUtils.isEmpty((String)value)) {
                    return value;
                }
                this.badFrontEndRequest("Null or empty required property: " + propertyName);
            }
            return null;
        }

        private String getOptionalStringProperty(String propertyName) {
            FormProperty formProperty = this.findFormProperty(propertyName);
            if (formProperty != null) {
                return this.getStringValue(formProperty);
            }
            return null;
        }

        private boolean getOptionalBooleanProperty(String propertyName, boolean dflt) {
            FormProperty formProperty = this.findFormProperty(propertyName);
            if (formProperty != null) {
                return this.getFormPropertyValue(formProperty).getValue().asBoolean().getValue();
            }
            return dflt;
        }

        private FormProperty findRequiredFormProperty(String propertyName) {
            FormProperty formProperty = this.findFormProperty(propertyName);
            if (formProperty == null) {
                this.badFrontEndRequest("Missing required property: " + propertyName);
            }
            return formProperty;
        }

        private FormProperty findFormProperty(String propertyName) {
            for (FormProperty formProperty : this.formProperties) {
                String formPropName = formProperty.getFieldDef().asBeanPropertyDef().getPropertyPath().getDotSeparatedPath();
                if (!formPropName.equals(propertyName)) continue;
                return formProperty;
            }
            return null;
        }

        private String getStringValue(FormProperty formProperty) {
            Value value = this.getFormPropertyValue(formProperty).getValue();
            String stringValue = null;
            stringValue = value.isModelToken() ? value.asModelToken().getToken() : (value.isSecret() ? value.asSecret().getValue() : value.asString().getValue());
            return StringUtils.isEmpty((String)stringValue) ? null : stringValue;
        }

        private SettableValue getFormPropertyValue(FormProperty formProperty) {
            return formProperty.getValue().asSettable();
        }

        private boolean isOK() {
            return this.response.isSuccess();
        }

        private void badFrontEndRequest(String message) {
            this.response.addFailureMessage(message);
            if (!this.response.isUserBadRequest()) {
                this.response.setFrontEndBadRequest();
            }
        }

        private void badUserRequest(String message) {
            this.response.addFailureMessage(message);
            this.response.setUserBadRequest();
        }
    }
}

