/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.customizers.Source;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;

public class JDBCDataSourceBeanCustomizer {
    private static final Set<String> SUPPORTED_TYPES = Set.of("GENERIC", "UCP", "AGL", "MDS", "PROXY");

    private JDBCDataSourceBeanCustomizer() {
    }

    public static SettableValue getDatasourceType(@Source(property="DatasourceType") SettableValue datasourceType, @Source(collection="JDBCDriverParams/Properties/Properties", properties={"Name", "Value"}) List<Map<String, SettableValue>> driverProperties, @Source(property="JDBCOracleParams.ActiveGridlink") SettableValue activeGridlink, @Source(property="JDBCOracleParams.FanEnabled") SettableValue fanEnabled, @Source(property="JDBCDataSourceParams.DataSourceList") SettableValue dataSourceList) {
        SettableValue.State state = datasourceType.getState();
        String type = null;
        if (datasourceType.getValue().isString() && (type = datasourceType.getValue().asString().getValue()) != null && !SUPPORTED_TYPES.contains(type)) {
            type = null;
        }
        if (type == null) {
            type = JDBCDataSourceBeanCustomizer.getTypeFromDriverProperties(driverProperties);
        }
        if (type == null) {
            type = JDBCDataSourceBeanCustomizer.inferTypeFromOracleParams(activeGridlink.getValue(), fanEnabled.getValue());
        }
        if (type == null) {
            type = JDBCDataSourceBeanCustomizer.inferTypeFromDataSourceList(dataSourceList.getValue());
        }
        if (type == null) {
            type = "GENERIC";
        }
        return new SettableValue((Value)new StringValue(type), state);
    }

    private static String getTypeFromDriverProperties(List<Map<String, SettableValue>> driverProperties) {
        for (Map<String, SettableValue> driverProperty : driverProperties) {
            String type;
            Value name = driverProperty.get("Name").getValue();
            Value value = driverProperty.get("Value").getValue();
            if (!name.isString() || !value.isString() || !"weblogic.jdbc.type".equals(name.asString().getValue()) || !StringUtils.notEmpty((String)(type = value.asString().getValue())) || !SUPPORTED_TYPES.contains(type)) continue;
            return type;
        }
        return null;
    }

    private static String inferTypeFromOracleParams(Value agl, Value fanEnabled) {
        if (agl.isBoolean() && agl.asBoolean().getValue()) {
            return "AGL";
        }
        if (fanEnabled.isModelToken() || fanEnabled.isBoolean() && fanEnabled.asBoolean().getValue()) {
            return "AGL";
        }
        return null;
    }

    private static String inferTypeFromDataSourceList(Value dsList) {
        if (dsList.isModelToken() || dsList.isString() && StringUtils.notEmpty((String)dsList.asString().getValue())) {
            return "MDS";
        }
        return null;
    }
}

