/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.CustomPagePropertyDef;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;

public class HostnameVerifierCustomizer {
    private static final String HNV_WILDCARD = "weblogic.security.utils.SSLWLSWildcardHostnameVerifier";
    private static final String HNV_BEA = "weblogic.security.utils.SSLWLSHostnameVerifier$DefaultHostnameVerifier";
    private static final String HNV_TYPE_WILDCARD = "Wildcard Verifier";
    private static final String HNV_TYPE_BEA = "BEA Verifier";
    private static final String HNV_TYPE_CUSTOM = "Custom Verifier";

    private HostnameVerifierCustomizer() {
    }

    public static SettableValue getHostnameVerifierType(SettableValue hostnameVerifier) {
        boolean isSet = hostnameVerifier.isSet();
        String type = HostnameVerifierCustomizer.computeHostnameVerifierType(hostnameVerifier);
        return new SettableValue((Value)new StringValue(type), isSet);
    }

    public static SettableValue getCustomHostnameVerifier(SettableValue hostnameVerifier) {
        boolean isSet = false;
        String hnv = null;
        if (HNV_TYPE_CUSTOM.equals(HostnameVerifierCustomizer.computeHostnameVerifierType(hostnameVerifier))) {
            isSet = true;
            hnv = hostnameVerifier.getValue().asString().getValue();
        }
        return new SettableValue((Value)new StringValue(hnv), isSet);
    }

    private static String computeHostnameVerifierType(SettableValue hostnameVerifier) {
        String type = null;
        if (hostnameVerifier.isSet()) {
            String hnv = hostnameVerifier.getValue().asString().getValue();
            if (HNV_WILDCARD.equals(hnv)) {
                type = HNV_TYPE_WILDCARD;
            } else if (HNV_BEA.equals(hnv)) {
                type = HNV_TYPE_BEA;
            } else if (!StringUtils.isEmpty((String)hnv)) {
                type = HNV_TYPE_CUSTOM;
            }
        }
        return type;
    }

    public static Response<List<FormProperty>> customizeFormProperties(InvocationContext ic, List<FormProperty> formProperties) {
        Response response = new Response();
        ArrayList<FormProperty> customizedProperties = new ArrayList<FormProperty>();
        FormProperty hnvTypeProperty = null;
        FormProperty customHnvProperty = null;
        for (FormProperty formProperty : formProperties) {
            String name = formProperty.getName();
            if ("HostnameVerifierType".equals(name)) {
                hnvTypeProperty = formProperty;
                continue;
            }
            if ("CustomHostnameVerifier".equals(name)) {
                customHnvProperty = formProperty;
                continue;
            }
            customizedProperties.add(formProperty);
        }
        if (hnvTypeProperty != null || customHnvProperty != null) {
            Response<FormProperty> hnvResponse = HostnameVerifierCustomizer.createHostnameVerifierFormProperty(ic, hnvTypeProperty, customHnvProperty);
            if (!hnvResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(hnvResponse);
            }
            customizedProperties.add(hnvResponse.getResults());
        }
        return response.setSuccess(customizedProperties);
    }

    private static Response<FormProperty> createHostnameVerifierFormProperty(InvocationContext ic, FormProperty hnvTypeProperty, FormProperty customHnvProperty) {
        String typeName;
        Response<FormProperty> response = new Response<FormProperty>();
        boolean isSet = false;
        String hnv = null;
        boolean isCustom = false;
        if (hnvTypeProperty != null) {
            SettableValue hnvType = hnvTypeProperty.getValue().asSettable();
            if (hnvType.isSet()) {
                String hnvTypeValue = hnvType.getValue().asString().getValue();
                if (hnvTypeValue == null) {
                    hnv = null;
                    isSet = true;
                } else if (HNV_TYPE_WILDCARD.equals(hnvTypeValue)) {
                    hnv = HNV_WILDCARD;
                    isSet = true;
                } else if (HNV_TYPE_BEA.equals(hnvTypeValue)) {
                    hnv = HNV_BEA;
                    isSet = true;
                } else if (HNV_TYPE_CUSTOM.equals(hnvTypeValue)) {
                    isCustom = true;
                }
            }
        } else if (customHnvProperty != null) {
            isCustom = true;
        }
        if (isCustom) {
            hnv = HostnameVerifierCustomizer.computeCustomHostnameVerifier(customHnvProperty);
            if (hnv == null) {
                response.addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.CUSTOM_HOSTNAME_VERIFIER_NOT_SPECIFIED, new Object[0]));
                return response.setUserBadRequest();
            }
            isSet = true;
        }
        String parentPath = "ServerMBean".equals(typeName = ic.getBeanTreePath().getTypeDef().getTypeName()) ? "SSL" : "";
        String propertyName = "HostnameVerifier";
        CustomPagePropertyDef hnvPropertyDef = new CustomPagePropertyDef().parentPath(new Path(parentPath)).propertyName(propertyName).onlinePropertyName(StringUtils.getRestName((String)propertyName)).offlinePropertyName(propertyName);
        SettableValue hnvValue = new SettableValue((Value)new StringValue(hnv), isSet);
        return response.setSuccess(new FormProperty(hnvPropertyDef, hnvValue));
    }

    private static String computeCustomHostnameVerifier(FormProperty customHvnProperty) {
        String hnv;
        SettableValue customHvn;
        if (customHvnProperty != null && (customHvn = customHvnProperty.getValue().asSettable()).isSet() && !StringUtils.isEmpty((String)(hnv = customHvn.getValue().asString().getValue()))) {
            return hnv;
        }
        return null;
    }
}

