/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PageFieldDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.DashboardManager;
import weblogic.remoteconsole.server.repo.FilteringDashboard;
import weblogic.remoteconsole.server.repo.FilteringDashboardDefManager;
import weblogic.remoteconsole.server.repo.FilteringDashboardPathSegment;
import weblogic.remoteconsole.server.repo.FilteringDashboardPathSegmentDef;
import weblogic.remoteconsole.server.repo.FilteringDashboardProperty;
import weblogic.remoteconsole.server.repo.FilteringDashboardPropertyDef;
import weblogic.remoteconsole.server.repo.Form;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.SearchBeanPropertyResults;
import weblogic.remoteconsole.server.repo.SearchBeanResults;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;

public class FilteringDashboardMBeanCustomizer {
    private FilteringDashboardMBeanCustomizer() {
    }

    public static PageDef customizeFiltersSliceDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return FilteringDashboardDefManager.customizeFiltersSliceDef(ic, uncustomizedPageDef).getResults();
    }

    public static PageDef customizeViewSliceDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return FilteringDashboardDefManager.customizeViewSliceDef(ic, uncustomizedPageDef).getResults();
    }

    public static void customizeFiltersSlice(InvocationContext ic, Page page) {
        FilteringDashboard dashboard = FilteringDashboardMBeanCustomizer.getDashboardManager(ic).getDashboard(ic).getResults().asFilteringDashboard();
        BeanTreePath btpTemplate = dashboard.getConfig().getDashboardDef().getBeanTreePathTemplate();
        page.setLocalizedIntroductionHTML(ic.getLocalizer().localizeString(page.getPageDef().getIntroductionHTML(), FilteringDashboardMBeanCustomizer.getDashboardTypeLabel(ic, btpTemplate)));
        String pathQueryParam = FilteringDashboardDefManager.computePathQueryParam(btpTemplate);
        page.setBackendRelativePDJURI(page.getBackendRelativePDJURI() + "&" + pathQueryParam);
        Form form = page.asForm();
        form.setExists(true);
        HashMap<String, PagePropertyDef> nameToPagePropertyDef = new HashMap<String, PagePropertyDef>();
        for (PagePropertyDef pagePropertyDef : page.getPageDef().getAllPropertyDefs()) {
            nameToPagePropertyDef.put(pagePropertyDef.getFormFieldName(), pagePropertyDef);
        }
        form.getProperties().add(new FormProperty((PageFieldDef)nameToPagePropertyDef.get("Name"), new StringValue(dashboard.getName())));
        form.getProperties().add(new FormProperty((PageFieldDef)nameToPagePropertyDef.get("Description"), new StringValue(dashboard.getDescription())));
        for (FilteringDashboardPathSegment segment : dashboard.getConfig().getPath()) {
            FilteringDashboardPathSegmentDef segmentDef = segment.getSegmentDef();
            if (!segmentDef.isFilterable()) continue;
            form.getProperties().add(new FormProperty((PageFieldDef)nameToPagePropertyDef.get(segmentDef.getCriteriaPropertyDef().getFormFieldName()), new StringValue(segment.getCriteria())));
            form.getProperties().add(new FormProperty((PageFieldDef)nameToPagePropertyDef.get(segmentDef.getValuePropertyDef().getFormFieldName()), new StringValue(segment.getValue())));
        }
        for (FilteringDashboardProperty property : dashboard.getConfig().getProperties()) {
            FilteringDashboardPropertyDef propertyDef = property.getPropertyDef();
            form.getProperties().add(new FormProperty((PageFieldDef)nameToPagePropertyDef.get(propertyDef.getCriteriaPropertyDef().getFormFieldName()), new StringValue(property.getCriteria())));
            form.getProperties().add(new FormProperty((PageFieldDef)nameToPagePropertyDef.get(propertyDef.getValuePropertyDef().getFormFieldName()), property.getValue()));
        }
    }

    public static void customizeViewSlice(InvocationContext ic, Page page) {
        String dashboardName = ic.getBeanTreePath().getLastSegment().getKey();
        FilteringDashboard dashboard = FilteringDashboardMBeanCustomizer.getDashboardManager(ic).getFilteringDashboardSearchResults(ic, page.getPageDef(), dashboardName).getResults();
        BeanTreePath btpTemplate = dashboard.getConfig().getDashboardDef().getBeanTreePathTemplate();
        page.setLocalizedIntroductionHTML(ic.getLocalizer().localizeString(page.getPageDef().getIntroductionHTML(), FilteringDashboardMBeanCustomizer.getDashboardDescription(dashboard.getDescriptionLabel(ic), ic, btpTemplate)));
        page.setBackendRelativePDJURI(page.getBackendRelativePDJURI() + "&" + UrlUtils.computeQueryParam("dashboard", dashboard.getName()));
        TreeMap<Path, TableRow> sorter = new TreeMap<Path, TableRow>();
        for (SearchBeanResults beanResults : dashboard.getResults()) {
            TableRow row = new TableRow();
            BeanTreePath btp = beanResults.getBeanTreePath();
            row.getCells().add(new TableCell("identity", btp));
            List<FilteringDashboardPathSegmentDef> segmentDefs = dashboard.getConfig().getDashboardDef().getPathDef();
            Path sortingKey = new Path();
            for (int i = 0; i < segmentDefs.size(); ++i) {
                FilteringDashboardPathSegmentDef segmentDef = segmentDefs.get(i);
                if (!segmentDef.isFilterable()) continue;
                String key = btp.getSegments().get(i).getKey();
                sortingKey.getComponents().add(0, key);
                row.getCells().add(new TableCell(segmentDef.getResultPropertyDef().getFormFieldName(), new StringValue(key)));
            }
            for (SearchBeanPropertyResults propertyResults : beanResults.getPropertiesResults()) {
                row.getCells().add(new TableCell(propertyResults.getPropertyDef().getFormFieldName(), propertyResults.getValue()));
            }
            sorter.put(sortingKey, row);
        }
        page.asTable().getRows().addAll(sorter.values());
    }

    private static String getDashboardDescription(String customDescription, InvocationContext ic, BeanTreePath btpTemplate) {
        if (StringUtils.isEmpty((String)customDescription)) {
            return ic.getLocalizer().localizeString(LocalizedConstants.FILTERING_DASHBOARD_DEFAULT_DESCRIPTION, FilteringDashboardMBeanCustomizer.getDashboardTypeLabel(ic, btpTemplate));
        }
        return customDescription;
    }

    private static String getDashboardTypeLabel(InvocationContext ic, BeanTreePath btpTemplate) {
        return ic.getLocalizer().localizeString(btpTemplate.getLastSegment().getChildDef().getChildTypeDef().getInstanceNameLabel(), new Object[0]);
    }

    private static DashboardManager getDashboardManager(InvocationContext ic) {
        return ic.getPageRepo().asPageReaderRepo().getDashboardManager(ic);
    }
}

