/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.customizers.DomainSecurityRuntimeMBeanResource;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestInvoker;
import weblogic.remoteconsole.server.webapp.BaseResource;

public class DomainSecurityRuntimeMBeanCustomizer {
    private DomainSecurityRuntimeMBeanCustomizer() {
    }

    public static BaseResource createResource(InvocationContext ic) {
        return new DomainSecurityRuntimeMBeanResource();
    }

    public static List<TableRow> getSecurityWarningsSliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults searchResults) {
        return DomainSecurityRuntimeMBeanCustomizer.processWarnings(DomainSecurityRuntimeMBeanCustomizer.getSecurityWarnings(ic), DomainSecurityRuntimeMBeanCustomizer.getServerClusterMap(ic));
    }

    private static JsonArray getSecurityWarnings(InvocationContext ic) {
        JsonObject searchResults = WebLogicRestInvoker.post(ic, new Path("domainRuntime.search"), DomainSecurityRuntimeMBeanCustomizer.getSecurityWarningsQuery(), false, false, false).getResults();
        JsonObject domainSecurityRuntime = searchResults.getJsonObject("domainSecurityRuntime");
        if (domainSecurityRuntime != null) {
            return domainSecurityRuntime.getJsonArray("securityValidationWarnings");
        }
        return Json.createArrayBuilder().build();
    }

    private static JsonObject getSecurityWarningsQuery() {
        JsonObjectBuilder domainSecurityRuntime = Json.createObjectBuilder();
        domainSecurityRuntime.add("fields", Json.createArrayBuilder().add("securityValidationWarnings"));
        domainSecurityRuntime.add("links", Json.createArrayBuilder());
        JsonObjectBuilder domainRuntimeChildren = Json.createObjectBuilder();
        domainRuntimeChildren.add("domainSecurityRuntime", domainSecurityRuntime);
        JsonObjectBuilder domainRuntime = Json.createObjectBuilder();
        domainRuntime.add("fields", Json.createArrayBuilder());
        domainRuntime.add("links", Json.createArrayBuilder());
        domainRuntime.add("children", domainRuntimeChildren);
        return domainRuntime.build();
    }

    private static Map<String, String> getServerClusterMap(InvocationContext ic) {
        BeanTreePath serversBeanPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain.Servers"));
        BeanTypeDef serversTypeDef = serversBeanPath.getTypeDef();
        BeanPropertyDef identityPropertyDef = serversTypeDef.getIdentityPropertyDef();
        BeanPropertyDef clusterPropertyDef = serversTypeDef.getPropertyDef(new Path("Cluster"));
        boolean includeIsSet = false;
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, includeIsSet);
        builder.addProperty(serversBeanPath, identityPropertyDef);
        builder.addProperty(serversBeanPath, clusterPropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        HashMap<String, String> serverClusterMap = new HashMap<String, String>();
        for (BeanSearchResults serverResults : searchResults.getCollection(serversBeanPath)) {
            BeanTreePath identity = serverResults.getValue(identityPropertyDef).asBeanTreePath();
            Value cluster = serverResults.getValue(clusterPropertyDef);
            String serverName = identity.asBeanTreePath().getLastSegment().getKey();
            if (!cluster.isBeanTreePath()) continue;
            String clusterName = cluster.asBeanTreePath().getLastSegment().getKey();
            serverClusterMap.put(serverName, clusterName);
        }
        return serverClusterMap;
    }

    private static List<TableRow> processWarnings(JsonArray warnings, Map<String, String> serverClusterMap) {
        TreeMap<String, TableRow> sortedRows = new TreeMap<String, TableRow>();
        for (int i = 0; i < warnings.size(); ++i) {
            JsonObject warning = warnings.getJsonObject(i);
            String id = warning.getString("id");
            String description = warning.getString("description");
            String serverName = warning.getString("serverName");
            String clusterName = serverClusterMap.get(serverName);
            TableRow row = new TableRow();
            row.getCells().add(new TableCell("Id", new StringValue(id)));
            row.getCells().add(new TableCell("Description", new StringValue(description)));
            row.getCells().add(new TableCell("Server", new StringValue(serverName)));
            if (!StringUtils.isEmpty((String)clusterName)) {
                row.getCells().add(new TableCell("Cluster", new StringValue(clusterName)));
            }
            sortedRows.put(DomainSecurityRuntimeMBeanCustomizer.getSortingKey(id, description, serverName, clusterName), row);
        }
        return new ArrayList<TableRow>(sortedRows.values());
    }

    private static String getSortingKey(String id, String description, String serverName, String clusterName) {
        StringBuilder sb = new StringBuilder();
        sb.append("id=").append(id);
        sb.append(", desciption=").append(description);
        if (!StringUtils.isEmpty((String)clusterName)) {
            sb.append(", cluster=").append(clusterName);
        }
        sb.append(", server=").append(serverName);
        return sb.toString();
    }
}

