/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.HashSet;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.utils.WebLogicRoles;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestInvoker;

public class DomainRuntimeMBeanCustomizer {
    private DomainRuntimeMBeanCustomizer() {
    }

    public static void customizeEditSessionPage(InvocationContext ic, Page page) {
        HashSet<String> roles = new HashSet<String>(WebLogicRoles.ADMIN_ROLES);
        roles.add("Deployer");
        if (!ic.getPageRepo().getBeanRepo().getBeanRepoDef().isAccessAllowed(roles)) {
            return;
        }
        JsonObject status = WebLogicRestInvoker.get(ic, new Path("edit.changeManager"), false).getResults();
        DomainRuntimeMBeanCustomizer.addProperty(page, "editSession", new StringValue(status.getString("editSession")));
        boolean locked = status.getBoolean("locked");
        DomainRuntimeMBeanCustomizer.addProperty(page, "locked", new BooleanValue(locked));
        if (locked) {
            DomainRuntimeMBeanCustomizer.addProperty(page, "lockOwner", new StringValue(status.getString("lockOwner")));
            DomainRuntimeMBeanCustomizer.addProperty(page, "hasChanges", new BooleanValue(status.getBoolean("hasChanges")));
        }
    }

    private static void addProperty(Page page, String propertyName, Value propertyValue) {
        page.asForm().getProperties().add(new FormProperty(DomainRuntimeMBeanCustomizer.findPropertyDef(page, propertyName), propertyValue));
    }

    private static PagePropertyDef findPropertyDef(Page page, String propertyName) {
        Path propertyPath = new Path(propertyName);
        for (PagePropertyDef propertyDef : page.getPageDef().getAllPropertyDefs()) {
            if (!propertyDef.getPropertyPath().equals((Object)propertyPath)) continue;
            return propertyDef;
        }
        return null;
    }

    public static Value grabEditLock(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        WebLogicRestInvoker.post(ic, new Path("edit.consoleChangeManager.grabEditLock"), Json.createObjectBuilder().build(), false, false, false).getResults();
        return null;
    }
}

