/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.json.JsonObject;
import javax.ws.rs.core.Response;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BeanActionArg;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.ConfigurationTransactionHelper;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PropertiesValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.CreatableBeanCollectionResource;
import weblogic.remoteconsole.server.webapp.CreateHelper;

public abstract class DeploymentUploadableCreatableBeanCollectionResource
extends CreatableBeanCollectionResource {
    @Override
    protected Response createCollectionChild(JsonObject requestBody) {
        return this.createCreateHelper().createBean(this.getInvocationContext(), requestBody);
    }

    protected abstract DeploymentCreateHelper createCreateHelper();

    protected static abstract class DeploymentCreateHelper
    extends CreateHelper {
        InvocationContext ic;
        private List<FormProperty> formProperties;

        protected DeploymentCreateHelper() {
        }

        @Override
        protected weblogic.remoteconsole.server.repo.Response<Void> createBean(InvocationContext ic, List<FormProperty> formProperties) {
            this.ic = ic;
            this.formProperties = formProperties;
            return ConfigurationTransactionHelper.editConfiguration(ic, new ConfigurationTransactionHelper.ConfigurationEditor(){

                @Override
                public weblogic.remoteconsole.server.repo.Response<Void> editConfiguration() {
                    weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
                    weblogic.remoteconsole.server.repo.Response<Value> createResponse = this.createDeployment();
                    if (!createResponse.isSuccess()) {
                        return response.copyUnsuccessfulResponse(createResponse);
                    }
                    return response.setSuccess(null);
                }
            });
        }

        private weblogic.remoteconsole.server.repo.Response<Value> createDeployment() {
            String name = this.getStringProperty("Name", true);
            String applicationPath = this.getStringProperty("SourcePath", true);
            String plan = this.getStringProperty("PlanPath", false);
            Properties deploymentOptions = this.getDeploymentOptions();
            String startOption = this.getStringProperty("OnDeployment", false);
            boolean startFlag = true;
            if ("startInAdminMode".equals(startOption)) {
                deploymentOptions.setProperty("adminMode", "true");
            } else if ("doNotStart".equals(startOption)) {
                startFlag = false;
            }
            return this.customizeAction(name, applicationPath, this.getTargets(), this.getPlan(), deploymentOptions, startFlag);
        }

        private weblogic.remoteconsole.server.repo.Response<Value> customizeAction(String name, String applicationPath, List<Value> targets, String plan, Properties deploymentOptions, boolean startApp) {
            BeanTreePath dmBTP = BeanTreePath.create(this.ic.getBeanTreePath().getBeanRepo(), new Path("DomainRuntime.DeploymentManager"));
            InvocationContext dmIC = new InvocationContext(this.ic, dmBTP);
            Path path = new Path(startApp ? "deploy_name_applicationPath_targets_plan_deploymentOptions" : "distribute_name_applicationPath_targets_plan_deploymentOptions");
            BeanActionDef actionDef = dmBTP.getTypeDef().getActionDef(path);
            PropertiesValue deploymentOptionsValue = new PropertiesValue(deploymentOptions);
            ArrayList<BeanActionArg> args = new ArrayList<BeanActionArg>();
            args.add(new BeanActionArg(actionDef.getParamDef("name"), new StringValue(name)));
            args.add(new BeanActionArg(actionDef.getParamDef("applicationPath"), new StringValue(applicationPath)));
            args.add(new BeanActionArg(actionDef.getParamDef("targets"), new ArrayValue(targets)));
            args.add(new BeanActionArg(actionDef.getParamDef("plan"), new StringValue(plan)));
            args.add(new BeanActionArg(actionDef.getParamDef("deploymentOptions"), deploymentOptionsValue));
            return dmIC.getPageRepo().getBeanRepo().asBeanReaderRepo().invokeAction(dmIC, actionDef, args);
        }

        protected String getPlan() {
            return null;
        }

        protected List<Value> getTargets() {
            ArrayList<Value> targets = new ArrayList<Value>();
            FormProperty fp = this.getFormProperty("Targets", false);
            if (fp != null) {
                ArrayValue targetsArrayValue = fp.getValue().asSettable().getValue().asArray();
                List<Value> targetsListFromForm = targetsArrayValue.getValues();
                for (Value one : targetsListFromForm) {
                    targets.add(new StringValue(((BeanTreePath)one).getLastSegment().getKey()));
                }
            }
            return targets;
        }

        abstract Properties getDeploymentOptions();

        protected String getStringProperty(String propertyName, boolean required) {
            FormProperty formProperty = this.getFormProperty(propertyName, required);
            return formProperty != null ? formProperty.getValue().asSettable().getValue().asString().getValue() : null;
        }

        protected int getIntProperty(String propertyName, boolean required) {
            FormProperty formProperty = this.getFormProperty(propertyName, required);
            if (formProperty == null) {
                return -1;
            }
            return formProperty.getValue().asSettable().getValue().asInt().getValue();
        }

        protected boolean getBooleanProperty(String propertyName, boolean required, boolean dflt) {
            FormProperty formProperty = this.getFormProperty(propertyName, required);
            return formProperty != null ? formProperty.getValue().asSettable().getValue().asBoolean().getValue() : dflt;
        }

        private FormProperty getFormProperty(String propertyName, boolean required) {
            for (FormProperty formProperty : this.formProperties) {
                if (!propertyName.equals(formProperty.getName())) continue;
                return formProperty;
            }
            if (required) {
                throw new AssertionError((Object)("Missing required form property: " + propertyName + " " + String.valueOf(this.formProperties)));
            }
            return null;
        }
    }
}

