/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.ws.rs.NotFoundException;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.customizers.BuiltinFilteringDashboardMBeanCollectionChildResource;
import weblogic.remoteconsole.customizers.CustomFilteringDashboardMBeanCollectionChildResource;
import weblogic.remoteconsole.customizers.DashboardMBeanCollectionResource;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.CustomBeanSearchResults;
import weblogic.remoteconsole.server.repo.Dashboard;
import weblogic.remoteconsole.server.repo.DashboardManager;
import weblogic.remoteconsole.server.repo.DateValue;
import weblogic.remoteconsole.server.repo.FilteringDashboard;
import weblogic.remoteconsole.server.repo.FilteringDashboardDefManager;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.BaseResource;

public class DashboardMBeanCustomizer {
    private DashboardMBeanCustomizer() {
    }

    public static SettableValue getType(InvocationContext ic) {
        String type = ic.getPageRepo().asPageReaderRepo().getDashboardManager(ic).getDashboard(ic).getResults().getType();
        return new SettableValue((Value)new StringValue(type), false);
    }

    public static BaseResource createResource(InvocationContext ic) {
        if (ic.getBeanTreePath().isCollection()) {
            return new DashboardMBeanCollectionResource();
        }
        Dashboard dashboard = DashboardMBeanCustomizer.getDashboardManager(ic).getDashboardOrNull(ic);
        if (dashboard == null) {
            throw new NotFoundException();
        }
        if (dashboard.isCustomFilteringDashboard()) {
            return new CustomFilteringDashboardMBeanCollectionChildResource();
        }
        if (dashboard.isBuiltinFilteringDashboard()) {
            return new BuiltinFilteringDashboardMBeanCollectionChildResource();
        }
        throw new AssertionError((Object)("Unknown dashboard: " + String.valueOf(dashboard)));
    }

    public static PageDef customizeCreateFormDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return FilteringDashboardDefManager.customizeCreateFormDef(ic, uncustomizedPageDef).getResults();
    }

    public static void customizeCreateForm(InvocationContext ic, Page page) {
        BeanTreePath btpTemplate = FilteringDashboardDefManager.getBeanTreePathTemplateFromPathQueryParam(ic);
        String pathQueryParam = FilteringDashboardDefManager.computePathQueryParam(btpTemplate);
        page.setBackendRelativePDJURI(page.getBackendRelativePDJURI() + "&" + pathQueryParam);
        page.setLocalizedIntroductionHTML(ic.getLocalizer().localizeString(page.getPageDef().getIntroductionHTML(), DashboardMBeanCustomizer.getCustomFilteringDashboardTypeLabel(ic, btpTemplate)));
        FilteringDashboardDefManager.customizeCreateForm(ic, page);
    }

    public static List<BeanSearchResults> getCollection(InvocationContext ic, BeanTreePath collectionPath, BeanReaderRepoSearchResults searchResults, List<BeanPropertyDef> propertyDefs) {
        BeanTypeDef typeDef = collectionPath.getTypeDef();
        TreeMap<String, CustomBeanSearchResults> collectionResults = new TreeMap<String, CustomBeanSearchResults>();
        for (Dashboard dashboard : DashboardMBeanCustomizer.getDashboardManager(ic).getDashboards(ic)) {
            String dashboardName = dashboard.getName();
            BeanTreePath childPath = BeanTreePath.create(collectionPath.getBeanRepo(), collectionPath.getPath().childPath(dashboardName));
            CustomBeanSearchResults beanResults = new CustomBeanSearchResults(searchResults, childPath);
            beanResults.addPropertyResults(typeDef.getIdentityPropertyDef(), childPath);
            beanResults.addPropertyResults(typeDef.getPropertyDef(new Path("Name")), new StringValue(dashboard.getName()));
            beanResults.addPropertyResults(typeDef.getPropertyDef(new Path("Type")), new StringValue(dashboard.getTypeLabel(ic)));
            if (dashboard.isFilteringDashboard()) {
                FilteringDashboard filteringDashboard = dashboard.asFilteringDashboard();
                if (filteringDashboard.getResults() != null) {
                    boolean includeSubTypes = true;
                    beanResults.addPropertyResults(typeDef.getPropertyDef(new Path("Date"), includeSubTypes), new DateValue(filteringDashboard.getResultsDate()));
                    beanResults.addPropertyResults(typeDef.getPropertyDef(new Path("NumberOfMatches"), includeSubTypes), new LongValue(filteringDashboard.getResults().size()));
                }
            } else {
                throw new AssertionError((Object)("Unsupported dashboard : " + dashboard.getName() + " " + String.valueOf(dashboard.getClass())));
            }
            collectionResults.put(dashboardName, beanResults);
        }
        return new ArrayList<BeanSearchResults>(collectionResults.values());
    }

    public static Value copy(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        Dashboard dashboard = ic.getPageRepo().asPageReaderRepo().getDashboardManager(ic).getDashboard(ic).getResults();
        String name = FormProperty.getStringPropertyValue("Name", formProperties, null);
        if (StringUtils.isEmpty((String)name)) {
            throw Response.userBadRequestException().addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.REQUIRED_PROPERTY_NOT_SPECIFIED, "Name"));
        }
        dashboard.copy(ic, name).getResults();
        return null;
    }

    private static String getCustomFilteringDashboardTypeLabel(InvocationContext ic, BeanTreePath btpTemplate) {
        return ic.getLocalizer().localizeString(btpTemplate.getLastSegment().getChildDef().getChildTypeDef().getInstanceNameLabel(), new Object[0]);
    }

    private static DashboardManager getDashboardManager(InvocationContext ic) {
        return ic.getPageRepo().asPageReaderRepo().getDashboardManager(ic);
    }
}

