/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.server.repo.BeanPropertyValue;
import weblogic.remoteconsole.server.repo.BeanPropertyValues;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.BaseResource;
import weblogic.remoteconsole.server.webapp.CreatableBeanCollectionResource;
import weblogic.remoteconsole.server.webapp.CreatableOptionalSingletonBeanResource;
import weblogic.remoteconsole.server.webapp.DeletableCollectionChildBeanResource;
import weblogic.remoteconsole.server.webapp.EditableMandatorySingletonBeanResource;

public class CreatableDescriptorBeanCustomizer {
    private CreatableDescriptorBeanCustomizer() {
    }

    public static BaseResource createResource(InvocationContext ic) {
        BeanTreePath btp = ic.getBeanTreePath();
        if (btp.isCollection()) {
            return new CreatableBeanCollectionResource();
        }
        if (btp.isCollectionChild()) {
            return new DeletableCollectionChildBeanResource();
        }
        if (btp.isMandatorySingleton()) {
            return new EditableMandatorySingletonBeanResource();
        }
        if (btp.isOptionalSingleton()) {
            return new CreatableOptionalSingletonBeanResource();
        }
        return null;
    }

    public static Value createCollectionChild(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        BeanPropertyValues propertyValues = new BeanPropertyValues(ic.getBeanTreePath());
        for (FormProperty formProperty : formProperties) {
            String propertyName = formProperty.getName();
            BeanPropertyDef propertyDef = ic.getBeanTreePath().getTypeDef().getPropertyDef(new Path(propertyName));
            propertyValues.addPropertyValue(new BeanPropertyValue(propertyDef, formProperty.getValue().asSettable()));
        }
        ic.getPageRepo().getBeanRepo().asBeanEditorRepo().createBean(ic, propertyValues).getResults();
        return null;
    }
}

