/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.customizers.Source;
import weblogic.remoteconsole.server.repo.BeanActionArg;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;

public class ComponentRuntimeMBeanCustomizer {
    private static final String SERVERNAME_TO_SERVERHTTPURL = "ServerNameToServerHttpURL";

    private ComponentRuntimeMBeanCustomizer() {
    }

    public static SettableValue getContextRootURL(InvocationContext ic, @Source(property="ContextRoot") SettableValue contextRootAsSettable) {
        if (contextRootAsSettable == null) {
            return null;
        }
        String server = ic.getBeanTreePath().getSegments().get(1).getKey();
        String contextRoot = contextRootAsSettable.getValue().asString().getValue();
        String serverHttpURL = ComponentRuntimeMBeanCustomizer.getServerHttpURL(ic, server);
        String contextRootURL = ComponentRuntimeMBeanCustomizer.getServerChildHttpURL(serverHttpURL, contextRoot);
        return new SettableValue(new StringValue(contextRootURL));
    }

    private static String getServerChildHttpURL(String serverHttpURL, String childURI) {
        String uriPrefix = ComponentRuntimeMBeanCustomizer.getURIPrefix(serverHttpURL);
        if (uriPrefix != null && childURI.startsWith(uriPrefix)) {
            childURI = childURI.substring(uriPrefix.length());
        }
        return serverHttpURL + childURI;
    }

    private static String getURIPrefix(String url) {
        String uriPrefix = null;
        int startIdx = url.indexOf("://");
        if (startIdx > 0) {
            int uriStartIdx = 0;
            if (url.length() > startIdx + 3) {
                uriStartIdx = url.indexOf("/", startIdx + 3);
            }
            if (uriStartIdx > startIdx + 3) {
                uriPrefix = url.substring(uriStartIdx);
            }
        }
        return uriPrefix;
    }

    private static String getServerHttpURL(InvocationContext ic, String serverName) {
        Map serverNameToServerHttpURL;
        if (!ic.getCache().containsKey(SERVERNAME_TO_SERVERHTTPURL)) {
            ic.getCache().put(SERVERNAME_TO_SERVERHTTPURL, new ConcurrentHashMap());
        }
        if (!(serverNameToServerHttpURL = (Map)ic.getCache().get(SERVERNAME_TO_SERVERHTTPURL)).containsKey(serverName)) {
            String serverHttpURL = ComponentRuntimeMBeanCustomizer.computeServerHttpURL(ic, serverName);
            serverNameToServerHttpURL.put(serverName, serverHttpURL);
        }
        return (String)serverNameToServerHttpURL.get(serverName);
    }

    private static String computeServerHttpURL(InvocationContext ic, String serverName) {
        BeanTreePath domainRtBTP = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("DomainRuntime"));
        InvocationContext domainRtIC = new InvocationContext(ic, domainRtBTP);
        BeanActionDef actionDef = domainRtIC.getBeanTreePath().getTypeDef().getActionDef(new Path("getServerHttpURL"));
        List<BeanActionArg> args = List.of(new BeanActionArg(actionDef.getParamDef("serverName"), new StringValue(serverName)), new BeanActionArg(actionDef.getParamDef("admin"), new BooleanValue(false)));
        return domainRtIC.getPageRepo().getBeanRepo().asBeanReaderRepo().invokeAction(domainRtIC, actionDef, args).getResults().asString().getValue();
    }
}

