/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.customizers.CombinedServerRuntimeMBeanCollectionResource;
import weblogic.remoteconsole.server.repo.BeanActionArg;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.BaseResource;

public class CombinedServerRuntimeMBeanCustomizer {
    private static final Logger LOGGER = Logger.getLogger(CombinedServerRuntimeMBeanCustomizer.class.getName());

    private CombinedServerRuntimeMBeanCustomizer() {
    }

    public static BaseResource createResource(InvocationContext ic) {
        if (ic.getBeanTreePath().isCollection()) {
            return new CombinedServerRuntimeMBeanCollectionResource();
        }
        return null;
    }

    public static Value start(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        return CombinedServerRuntimeMBeanCustomizer.delegateToServerLifeCycleRuntimeAction(ic, "start").getResults();
    }

    public static Value resume(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        return CombinedServerRuntimeMBeanCustomizer.delegateToServerLifeCycleRuntimeAction(ic, "resume").getResults();
    }

    public static Value suspend(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        return CombinedServerRuntimeMBeanCustomizer.delegateToServerLifeCycleRuntimeAction(ic, "suspend").getResults();
    }

    public static Value forceSuspend(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        return CombinedServerRuntimeMBeanCustomizer.delegateToServerLifeCycleRuntimeAction(ic, "forceSuspend").getResults();
    }

    public static Value restartSSL(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        return CombinedServerRuntimeMBeanCustomizer.delegateToServerRuntimeAction(ic, "restartSSLChannels").getResults();
    }

    public static Value publishSingleSignOnServices(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        return CombinedServerRuntimeMBeanCustomizer.delegateAction(ic, "DomainRuntime.ServerRuntimes", "SingleSignOnServicesRuntime", "publish", formProperties).getResults();
    }

    public static Value forceShutdown(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        boolean adminServer = CombinedServerRuntimeMBeanCustomizer.isAdminServer(ic, CombinedServerRuntimeMBeanCustomizer.getShutdownProperties(ic, true));
        return CombinedServerRuntimeMBeanCustomizer.getShutdownResponse(CombinedServerRuntimeMBeanCustomizer.delegateToServerLifeCycleRuntimeAction(ic, "forceShutdown"), adminServer);
    }

    public static Value shutdown(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        BeanReaderRepoSearchResults searchResults = CombinedServerRuntimeMBeanCustomizer.getShutdownProperties(ic, false);
        BeanSearchResults serverResults = searchResults.getBean(CombinedServerRuntimeMBeanCustomizer.getServerBeanPath(ic));
        if (serverResults == null) {
            throw Response.notFoundException();
        }
        boolean adminServer = CombinedServerRuntimeMBeanCustomizer.isAdminServer(ic, searchResults);
        BeanTreePath realPath = CombinedServerRuntimeMBeanCustomizer.getRealBeanTreePath(ic, "DomainRuntime.ServerLifeCycleRuntimes", "");
        BeanActionDef actionDef = realPath.getTypeDef().getActionDef(new Path("shutdown_timeout_ignoreSessions"));
        List<BeanActionArg> args = List.of(new BeanActionArg(actionDef.getParamDef("timeout"), CombinedServerRuntimeMBeanCustomizer.getRequiredPropertyValue(serverResults, CombinedServerRuntimeMBeanCustomizer.getGracefulShutdownTimeoutPropertyDef(ic))), new BeanActionArg(actionDef.getParamDef("ignoreSessions"), CombinedServerRuntimeMBeanCustomizer.getRequiredPropertyValue(serverResults, CombinedServerRuntimeMBeanCustomizer.getIgnoreSessionsDuringShutdownPropertyDef(ic))));
        return CombinedServerRuntimeMBeanCustomizer.getShutdownResponse(ic.getPageRepo().getBeanRepo().asBeanReaderRepo().invokeAction(ic, realPath, actionDef, args), adminServer);
    }

    private static Value getShutdownResponse(Response<Value> invokeResponse, boolean adminServer) {
        if (adminServer) {
            if (!invokeResponse.isSuccess() || !invokeResponse.getMessages().isEmpty()) {
                LOGGER.finest("Ignoring timing-related issues shutting down the admin server. status: " + String.valueOf((Object)invokeResponse.getStatus()) + " messages: " + String.valueOf(invokeResponse.getMessages()));
            }
            return null;
        }
        return invokeResponse.getResults();
    }

    private static BeanReaderRepoSearchResults getShutdownProperties(InvocationContext ic, boolean isForceShutdown) {
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        builder.addProperty(CombinedServerRuntimeMBeanCustomizer.getDomainBeanPath(ic), CombinedServerRuntimeMBeanCustomizer.getAdminServerNamePropertyDef(ic));
        if (!isForceShutdown) {
            builder.addProperty(CombinedServerRuntimeMBeanCustomizer.getServerBeanPath(ic), CombinedServerRuntimeMBeanCustomizer.getGracefulShutdownTimeoutPropertyDef(ic));
            builder.addProperty(CombinedServerRuntimeMBeanCustomizer.getServerBeanPath(ic), CombinedServerRuntimeMBeanCustomizer.getIgnoreSessionsDuringShutdownPropertyDef(ic));
        }
        return builder.search().getResults();
    }

    private static boolean isAdminServer(InvocationContext ic, BeanReaderRepoSearchResults searchResults) {
        BeanSearchResults domainResults = searchResults.getBean(CombinedServerRuntimeMBeanCustomizer.getDomainBeanPath(ic));
        if (domainResults == null) {
            throw new AssertionError((Object)"Couldn't find domain bean results");
        }
        String adminServerName = CombinedServerRuntimeMBeanCustomizer.getRequiredPropertyValue(domainResults, CombinedServerRuntimeMBeanCustomizer.getAdminServerNamePropertyDef(ic)).asString().getValue();
        return CombinedServerRuntimeMBeanCustomizer.getServerName(ic).equals(adminServerName);
    }

    private static BeanPropertyDef getAdminServerNamePropertyDef(InvocationContext ic) {
        return CombinedServerRuntimeMBeanCustomizer.getDomainBeanPath(ic).getTypeDef().getPropertyDef(new Path("AdminServerName"));
    }

    private static BeanPropertyDef getGracefulShutdownTimeoutPropertyDef(InvocationContext ic) {
        return CombinedServerRuntimeMBeanCustomizer.getServerBeanPath(ic).getTypeDef().getPropertyDef(new Path("GracefulShutdownTimeout"));
    }

    private static BeanPropertyDef getIgnoreSessionsDuringShutdownPropertyDef(InvocationContext ic) {
        return CombinedServerRuntimeMBeanCustomizer.getServerBeanPath(ic).getTypeDef().getPropertyDef(new Path("IgnoreSessionsDuringShutdown"));
    }

    private static BeanTreePath getDomainBeanPath(InvocationContext ic) {
        return BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain"));
    }

    private static BeanTreePath getServerBeanPath(InvocationContext ic) {
        return BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain.Servers." + CombinedServerRuntimeMBeanCustomizer.getServerName(ic)));
    }

    private static Value getRequiredPropertyValue(BeanSearchResults searchResults, BeanPropertyDef propertyDef) {
        Value value = searchResults.getValue(propertyDef);
        if (value == null) {
            throw new AssertionError((Object)("Couldn't find value for " + String.valueOf(propertyDef.getPropertyPath())));
        }
        return value;
    }

    private static Response<Value> delegateToServerLifeCycleRuntimeAction(InvocationContext ic, String action) {
        return CombinedServerRuntimeMBeanCustomizer.delegateAction(ic, "DomainRuntime.ServerLifeCycleRuntimes", "", action, List.of());
    }

    private static Response<Value> delegateToServerRuntimeAction(InvocationContext ic, String action) {
        return CombinedServerRuntimeMBeanCustomizer.delegateAction(ic, "DomainRuntime.ServerRuntimes", "", action, List.of());
    }

    private static Response<Value> delegateAction(InvocationContext ic, String realCollection, String singletonChild, String action, List<FormProperty> pageArgs) {
        BeanTreePath realPath = CombinedServerRuntimeMBeanCustomizer.getRealBeanTreePath(ic, realCollection, singletonChild);
        ArrayList<BeanActionArg> beanArgs = new ArrayList<BeanActionArg>();
        for (FormProperty pageArg : pageArgs) {
            beanArgs.add(new BeanActionArg(pageArg.getFieldDef().asBeanActionParamDef(), pageArg.getValue().asSettable().getValue()));
        }
        return ic.getPageRepo().getBeanRepo().asBeanReaderRepo().invokeAction(ic, realPath, realPath.getTypeDef().getActionDef(new Path(action)), beanArgs);
    }

    private static BeanTreePath getRealBeanTreePath(InvocationContext ic, String realCollection, String singletonChild) {
        StringBuilder sb = new StringBuilder();
        sb.append(realCollection).append(".").append(CombinedServerRuntimeMBeanCustomizer.getServerName(ic));
        if (!StringUtils.isEmpty((String)singletonChild)) {
            sb.append(".").append(singletonChild);
        }
        return BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path(sb.toString()));
    }

    private static String getServerName(InvocationContext ic) {
        return ic.getBeanTreePath().getSegments().get(1).getKey();
    }
}

