/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.customizers.Source;
import weblogic.remoteconsole.server.repo.BeanEditorRepo;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.repo.Value;

public class ClusterMBeanCustomizer {
    private static final String IDENTITY = "identity";
    private static final String CLUSTER = "Cluster";

    private ClusterMBeanCustomizer() {
    }

    public static List<TableRow> getServersSliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults overallSearchResults) {
        if (overallSearchResults.getBean(ic.getBeanTreePath()) == null) {
            throw Response.notFoundException();
        }
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        BeanTreePath serversBeanPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain.Servers"));
        BeanTypeDef serversTypeDef = serversBeanPath.getTypeDef();
        BeanPropertyDef identityPropertyDef = serversTypeDef.getIdentityPropertyDef();
        BeanPropertyDef clusterPropertyDef = serversTypeDef.getPropertyDef(new Path(CLUSTER));
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        builder.addProperty(serversBeanPath, identityPropertyDef);
        builder.addProperty(serversBeanPath, clusterPropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        for (BeanSearchResults serverResults : searchResults.getCollection(serversBeanPath)) {
            BeanTreePath clusterIdentity;
            BeanTreePath serverIdentity = serverResults.getValue(identityPropertyDef).asBeanTreePath();
            Value clusterValue = serverResults.getValue(clusterPropertyDef);
            if (!clusterValue.isBeanTreePath() || !(clusterIdentity = clusterValue.asBeanTreePath()).equals(ic.getBeanTreePath())) continue;
            TableRow row = new TableRow();
            row.getCells().add(new TableCell("Server", serverIdentity));
            row.getCells().add(new TableCell(IDENTITY, serverIdentity));
            rows.add(row);
        }
        return rows;
    }

    public static void deleteCluster(InvocationContext ic, @Source(collection="/Domain/SingletonServices", properties={"identity", "Cluster"}) List<Map<String, Value>> singletonServices, @Source(collection="/Domain/MigratableTargets", properties={"identity", "Cluster"}) List<Map<String, Value>> migratableTargets) {
        BeanEditorRepo beanEditorRepo = ic.getPageRepo().getBeanRepo().asBeanEditorRepo();
        ClusterMBeanCustomizer.removeItemsReferencedByThisCluster(ic, beanEditorRepo, singletonServices);
        ClusterMBeanCustomizer.removeItemsReferencedByThisCluster(ic, beanEditorRepo, migratableTargets);
        beanEditorRepo.deleteBean(ic, ic.getBeanTreePath()).getResults();
    }

    private static void removeItemsReferencedByThisCluster(InvocationContext ic, BeanEditorRepo beanEditorRepo, List<Map<String, Value>> collection) {
        String clusterKeyWant = ic.getBeanTreePath().getLastSegment().getKey();
        for (Map<String, Value> item : collection) {
            Value cluster = item.get(CLUSTER);
            String clusterKeyHave = ClusterMBeanCustomizer.getClusterKeyFromClusterReference(cluster);
            if (!clusterKeyWant.equals(clusterKeyHave)) continue;
            beanEditorRepo.deleteBean(ic, item.get(IDENTITY).asBeanTreePath()).getResults();
        }
    }

    private static String getClusterKeyFromClusterReference(Value cluster) {
        if (cluster.isBeanTreePath()) {
            return cluster.asBeanTreePath().getLastSegment().getKey();
        }
        if (cluster.isModelToken()) {
            return cluster.asModelToken().getToken();
        }
        return null;
    }
}

