/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import weblogic.console.schema.beaninfo.BeanPropertyDefSource;
import weblogic.console.schema.beaninfo.DefaultValueDefSource;
import weblogic.console.schema.beaninfo.ValueDefSource;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.schema.BeanFieldPresentationDefSource;
import weblogic.remoteconsole.common.repodef.schema.BeanPropertyDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.FormSectionDefSource;
import weblogic.remoteconsole.common.repodef.schema.LegalValueDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.PageDefSource;
import weblogic.remoteconsole.common.repodef.schema.UsedIfDefSource;

class BasePageDefSourceCustomizer {
    private PagePath pagePath;
    private PageDefSource pageDefSource;

    protected BasePageDefSourceCustomizer(PagePath pagePath, PageDefSource pageDefSource) {
        this.pagePath = pagePath;
        this.pageDefSource = pageDefSource;
    }

    protected PagePath getPagePath() {
        return this.pagePath;
    }

    protected PageDefSource getPageDefSource() {
        return this.pageDefSource;
    }

    protected FormSectionDefSource addSectionToForm() {
        FormSectionDefSource section = new FormSectionDefSource();
        this.getPageDefSource().asFormDefSource().addSection(section);
        return section;
    }

    protected FormSectionDefSource addSectionToSection(FormSectionDefSource parent) {
        FormSectionDefSource section = new FormSectionDefSource();
        parent.addSection(section);
        return section;
    }

    protected UsedIfDefSource createUsedIf(String property, Object ... values) {
        UsedIfDefSource usedIf = new UsedIfDefSource();
        usedIf.setProperty(property);
        ArrayList<Object> vals = new ArrayList<Object>();
        for (Object value : values) {
            vals.add(value);
        }
        usedIf.setValues(vals);
        usedIf.setHide(true);
        return usedIf;
    }

    protected LegalValueDefCustomizerSource addLegalValue(BeanPropertyDefCustomizerSource property, Object value, String label) {
        this.addLegalValueToDefinition(property, value);
        return this.addLegalValueToCustomizer(property, value, label);
    }

    protected LegalValueDefCustomizerSource addLegalValue(BeanPropertyDefCustomizerSource property, Object value) {
        this.addLegalValueToDefinition(property, value);
        return this.addLegalValueToCustomizer(property, value, null);
    }

    private LegalValueDefCustomizerSource addLegalValueToCustomizer(BeanPropertyDefCustomizerSource property, Object value, String label) {
        LegalValueDefCustomizerSource legalValue = new LegalValueDefCustomizerSource();
        property.addLegalValue(legalValue);
        legalValue.setValue(value);
        if (!StringUtils.isEmpty((String)label)) {
            legalValue.setLabel(label);
        }
        return legalValue;
    }

    private void addLegalValueToDefinition(BeanPropertyDefCustomizerSource property, Object value) {
        BeanPropertyDefSource definition = property.getDefinition();
        if (definition != null) {
            definition.addLegalValue(value);
        }
    }

    protected BeanPropertyDefCustomizerSource addMBeanPropertyToForm(String name) {
        BeanPropertyDefCustomizerSource property = this.createMBeanProperty(name);
        this.getPageDefSource().asFormDefSource().addProperty(property);
        return property;
    }

    protected BeanPropertyDefCustomizerSource addMBeanPropertyToSection(FormSectionDefSource section, String name) {
        BeanPropertyDefCustomizerSource property = this.createMBeanProperty(name);
        section.addProperty(property);
        return property;
    }

    protected BeanPropertyDefCustomizerSource createMBeanProperty(String name) {
        return this.createPropertyCustomizer(name);
    }

    protected BeanPropertyDefCustomizerSource addNonMBeanStringPropertyToSection(FormSectionDefSource section, String name, String label, String descriptionHTML) {
        BeanPropertyDefCustomizerSource property = this.createNonMBeanStringProperty(name, label, descriptionHTML);
        section.addProperty(property);
        return property;
    }

    protected BeanPropertyDefCustomizerSource createNonMBeanStringProperty(String name, String label, String descriptionHTML) {
        return this.createNonMBeanProperty(name, label, descriptionHTML, "java.lang.String");
    }

    protected BeanPropertyDefCustomizerSource addNonMBeanBooleanPropertyToSection(FormSectionDefSource section, String name, String label, String descriptionHTML) {
        BeanPropertyDefCustomizerSource property = this.createNonMBeanBooleanProperty(name, label, descriptionHTML);
        section.addProperty(property);
        return property;
    }

    protected BeanPropertyDefCustomizerSource createNonMBeanBooleanProperty(String name, String label, String descriptionHTML) {
        return this.createNonMBeanProperty(name, label, descriptionHTML, "boolean");
    }

    private BeanPropertyDefCustomizerSource createNonMBeanProperty(String name, String label, String descriptionHTML, String javaType) {
        BeanPropertyDefCustomizerSource customizer = this.createPropertyCustomizer(name);
        customizer.setRequired(true);
        customizer.setLabel(label);
        customizer.setDefinition(this.createPropertyDefinition(name, javaType, descriptionHTML));
        return customizer;
    }

    private BeanPropertyDefCustomizerSource createPropertyCustomizer(String name) {
        BeanPropertyDefCustomizerSource customizer = new BeanPropertyDefCustomizerSource();
        customizer.setName(name);
        return customizer;
    }

    private BeanPropertyDefSource createPropertyDefinition(String name, String javaType, String descriptionHTML) {
        BeanPropertyDefSource definition = new BeanPropertyDefSource();
        definition.setName(name);
        definition.setWritable(true);
        definition.setType(javaType);
        if (!StringUtils.isEmpty((String)descriptionHTML)) {
            definition.setDescriptionHTML(descriptionHTML);
        }
        return definition;
    }

    protected void setInlineFieldHelp(BeanPropertyDefCustomizerSource property, String inlineFieldHelp) {
        BeanFieldPresentationDefSource presentation = property.getPresentation();
        if (presentation == null) {
            presentation = new BeanFieldPresentationDefSource();
            property.setPresentation(presentation);
        }
        presentation.setInlineFieldHelp(inlineFieldHelp);
    }

    protected void setDefaultValue(BeanPropertyDefCustomizerSource property, Object value) {
        ValueDefSource valueSource;
        BeanPropertyDefSource definition = property.getDefinition();
        if (definition == null) {
            throw new AssertionError((Object)"Trying to set an mbean-backed property's default value");
        }
        DefaultValueDefSource defaultValueSource = definition.getDefaultValue();
        if (defaultValueSource == null) {
            defaultValueSource = new DefaultValueDefSource();
            definition.setDefaultValue(defaultValueSource);
        }
        if ((valueSource = defaultValueSource.getValue()) == null) {
            valueSource = new ValueDefSource();
            defaultValueSource.setValue(valueSource);
        }
        valueSource.setValue(value);
    }
}

