/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.customizers.CustomizerUtils;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BeanActionArg;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.PropertiesValue;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.Value;

public class AppDeploymentRuntimeMBeanCustomizer {
    private AppDeploymentRuntimeMBeanCustomizer() {
    }

    public static Value startInAdminMode(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        Properties deploymentOptions = new Properties();
        deploymentOptions.setProperty("adminMode", "true");
        return AppDeploymentRuntimeMBeanCustomizer.customizeAction(ic, "start_targets_deploymentOptions", deploymentOptions);
    }

    public static Value forceStop(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        Properties deploymentOptions = new Properties();
        deploymentOptions.setProperty("gracefulIgnoreSessions", "true");
        return AppDeploymentRuntimeMBeanCustomizer.customizeAction(ic, "stop_targets_deploymentOptions", deploymentOptions);
    }

    public static Value stopToAdminMode(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        Properties deploymentOptions = new Properties();
        deploymentOptions.setProperty("adminMode", "true");
        deploymentOptions.setProperty("gracefulProductionToAdmin", "true");
        return AppDeploymentRuntimeMBeanCustomizer.customizeAction(ic, "stop_targets_deploymentOptions", deploymentOptions);
    }

    public static Value redeploySourceOnServer(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        String appName = ic.getBeanTreePath().getLastSegment().getKey();
        BeanTreePath appBeanPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain.AppDeployments").childPath(appName));
        BeanPropertyDef planPropertyDef = appBeanPath.getTypeDef().getPropertyDef(new Path("AbsolutePlanPath"));
        builder.addProperty(appBeanPath, planPropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults appResults = searchResults.getBean(appBeanPath);
        if (appResults == null) {
            throw Response.notFoundException();
        }
        FormProperty sourcePathProperty = CustomizerUtils.findRequiredFormProperty("SourcePath", formProperties);
        Value sourcePathValue = sourcePathProperty.getValue().asSettable().getValue();
        FormProperty planPathProperty = CustomizerUtils.findRequiredFormProperty("PlanPath", formProperties);
        Value planPathValue = planPathProperty.getValue().asSettable().getValue();
        return AppDeploymentRuntimeMBeanCustomizer.customizeAction(ic, "redeploy_targets_applicationPath_plan_deploymentOptions", new Properties(), Map.of("applicationPath", sourcePathValue, "plan", planPathValue));
    }

    public static Value updatePlanOnServer(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        String appName = ic.getBeanTreePath().getLastSegment().getKey();
        BeanTreePath appBeanPath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("Domain.AppDeployments").childPath(appName));
        BeanPropertyDef planPropertyDef = appBeanPath.getTypeDef().getPropertyDef(new Path("AbsolutePlanPath"));
        builder.addProperty(appBeanPath, planPropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults appResults = searchResults.getBean(appBeanPath);
        if (appResults == null) {
            throw Response.notFoundException();
        }
        Value planPath = formProperties.get(0).getValue().asSettable().getValue();
        return AppDeploymentRuntimeMBeanCustomizer.customizeAction(ic, "update_targets_plan_deploymentOptions", new Properties(), Map.of("plan", planPath));
    }

    public static void customizeCreatePlanActionInputForm(InvocationContext ic, Page page) {
        BeanTreePath appRtBTP = ic.getIdentities() == null ? ic.getBeanTreePath() : ic.getIdentities().get(0);
        String appName = appRtBTP.getLastSegment().getKey();
        Path appCfgPath = new Path("Domain.AppDeployments").childPath(appName);
        BeanTreePath appCfgBTP = BeanTreePath.create(appRtBTP.getBeanRepo(), appCfgPath);
        InvocationContext appCfgIc = new InvocationContext(ic, appCfgBTP);
        BeanTypeDef appCfgTypeDef = appCfgBTP.getTypeDef();
        BeanPropertyDef planPathPropertyDef = appCfgTypeDef.getPropertyDef(new Path("AbsolutePlanPath"));
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(appCfgIc, false);
        builder.addProperty(appCfgBTP, planPathPropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults beanResults = searchResults.getBean(appCfgBTP);
        if (beanResults == null) {
            throw Response.notFoundException();
        }
        Value planPath = beanResults.getValue(planPathPropertyDef);
        if (planPath.asString().getValue() != null) {
            throw Response.userBadRequestException().addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.APPLICATION_HAS_PLAN, appName, planPath.asString().getValue()));
        }
        BeanReaderRepoSearchBuilder builder2 = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        BeanPropertyDef defaultPlanPathPropertyDef = appRtBTP.getTypeDef().getPropertyDef(new Path("Configuration.DefaultPlanPath"));
        builder2.addProperty(appRtBTP, defaultPlanPathPropertyDef);
        BeanReaderRepoSearchResults searchResultsRT = builder2.search().getResults();
        BeanSearchResults beanResultsRT = searchResultsRT.getBean(appRtBTP);
        if (beanResultsRT == null) {
            return;
        }
        Value defaultPlanPathValue = beanResultsRT.getValue(defaultPlanPathPropertyDef);
        if (defaultPlanPathValue != null) {
            List<FormProperty> oldProperties = page.asForm().getProperties();
            List<FormProperty> newProperties = List.of(CustomizerUtils.createFormProperty("PlanPath", oldProperties, defaultPlanPathValue));
            oldProperties.clear();
            oldProperties.addAll(newProperties);
        }
    }

    public static void customizeRedeployActionInputForm(InvocationContext ic, Page page) {
        BeanTreePath appRtBTP = ic.getIdentities() == null ? ic.getBeanTreePath() : ic.getIdentities().get(0);
        String appName = appRtBTP.getLastSegment().getKey();
        Path appCfgPath = new Path("Domain.AppDeployments").childPath(appName);
        BeanTreePath appCfgBTP = BeanTreePath.create(appRtBTP.getBeanRepo(), appCfgPath);
        InvocationContext appCfgIc = new InvocationContext(ic, appCfgBTP);
        BeanTypeDef appCfgTypeDef = appCfgBTP.getTypeDef();
        BeanPropertyDef planPathPropertyDef = appCfgTypeDef.getPropertyDef(new Path("AbsolutePlanPath"));
        BeanPropertyDef sourcePathPropertyDef = appCfgTypeDef.getPropertyDef(new Path("AbsoluteSourcePath"));
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(appCfgIc, false);
        builder.addProperty(appCfgBTP, planPathPropertyDef);
        builder.addProperty(appCfgBTP, sourcePathPropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults beanResults = searchResults.getBean(appCfgBTP);
        Value planPathValue = beanResults.getValue(planPathPropertyDef);
        Value sourcePathValue = beanResults.getValue(sourcePathPropertyDef);
        List<FormProperty> oldProperties = page.asForm().getProperties();
        List<FormProperty> newProperties = List.of(CustomizerUtils.createFormProperty("PlanPath", oldProperties, planPathValue), CustomizerUtils.createFormProperty("SourcePath", oldProperties, sourcePathValue));
        oldProperties.clear();
        oldProperties.addAll(newProperties);
    }

    public static void customizeUpdatePlanActionInputForm(InvocationContext ic, Page page) {
        AppDeploymentRuntimeMBeanCustomizer.commonPlanActionInputForm(ic, page, false);
    }

    private static void commonPlanActionInputForm(InvocationContext ic, Page page, boolean needToExist) {
        BeanTreePath appRtBTP = ic.getIdentities() == null ? ic.getBeanTreePath() : ic.getIdentities().get(0);
        String appName = appRtBTP.getLastSegment().getKey();
        Path appCfgPath = new Path("Domain.AppDeployments").childPath(appName);
        BeanTreePath appCfgBTP = BeanTreePath.create(appRtBTP.getBeanRepo(), appCfgPath);
        InvocationContext appCfgIc = new InvocationContext(ic, appCfgBTP);
        BeanTypeDef appCfgTypeDef = appCfgBTP.getTypeDef();
        BeanPropertyDef planPathPropertyDef = appCfgTypeDef.getPropertyDef(new Path("AbsolutePlanPath"));
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(appCfgIc, false);
        builder.addProperty(appCfgBTP, planPathPropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults beanResults = searchResults.getBean(appCfgBTP);
        if (beanResults == null) {
            throw Response.notFoundException();
        }
        Value planPath = beanResults.getValue(planPathPropertyDef);
        if (needToExist && planPath.asString().getValue() == null) {
            throw Response.userBadRequestException().addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.APPLICATION_HAS_NO_PLAN, appName));
        }
        List<FormProperty> oldProperties = page.asForm().getProperties();
        List<FormProperty> newProperties = List.of(CustomizerUtils.createFormProperty("PlanPath", oldProperties, planPath));
        oldProperties.clear();
        oldProperties.addAll(newProperties);
    }

    private static Value customizeAction(InvocationContext ic, String action, Properties deploymentOptions) {
        return AppDeploymentRuntimeMBeanCustomizer.customizeAction(ic, action, deploymentOptions, Map.of());
    }

    private static Value customizeAction(InvocationContext ic, String action, Properties deploymentOptions, Map<String, Value> extraArgs) {
        ArrayValue targetsValue = new ArrayValue(List.of());
        PropertiesValue deploymentOptionsValue = new PropertiesValue(deploymentOptions);
        BeanActionDef actionDef = ic.getBeanTreePath().getTypeDef().getActionDef(new Path(action));
        ArrayList<BeanActionArg> args = new ArrayList<BeanActionArg>();
        args.add(new BeanActionArg(actionDef.getParamDef("targets"), targetsValue));
        args.add(new BeanActionArg(actionDef.getParamDef("deploymentOptions"), deploymentOptionsValue));
        for (Map.Entry<String, Value> extraArg : extraArgs.entrySet()) {
            args.add(new BeanActionArg(actionDef.getParamDef(extraArg.getKey()), extraArg.getValue()));
        }
        Response<Value> response = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().invokeAction(ic, actionDef, args);
        if (response.isUserBadRequest() && response.getMessages().isEmpty()) {
            response.addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.REFER_TO_DEPLOYMENT_TASKS_DASHBOARD, new Object[0]));
        }
        return response.getResults();
    }
}

