/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.utils.Message;
import weblogic.remoteconsole.customizers.DeploymentUploadableCreatableBeanCollectionResource;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.ConfigurationTransactionHelper;
import weblogic.remoteconsole.server.repo.FileContentsValue;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestInvoker;
import weblogic.remoteconsole.server.webapp.CreateHelper;

public class AppDeploymentMBeanUploadableCreatableBeanCollectionResource
extends DeploymentUploadableCreatableBeanCollectionResource {
    private static final Logger LOGGER = Logger.getLogger(AppDeploymentMBeanUploadableCreatableBeanCollectionResource.class.getName());

    @Override
    protected DeploymentUploadableCreatableBeanCollectionResource.DeploymentCreateHelper createCreateHelper() {
        return new AppDeploymentMBeanCreateHelper();
    }

    @Override
    protected Response createCollectionChild(JsonObject requestBody, FormDataMultiPart parts) {
        if (parts == null) {
            return super.createCollectionChild(requestBody, parts);
        }
        if (!this.supportsDistributeApplication(this.getInvocationContext())) {
            LOGGER.info("'AppDeploymentUploadAndDeployResource' is not found. Deployment and upload will continue with 'stageMode' set to default and application will be started after deployment.");
            return CreateHelper.create(this.getInvocationContext(), requestBody, parts);
        }
        AppDeploymentMBeanCreateHelper helper = new AppDeploymentMBeanCreateHelper();
        return helper.createBean(this.getInvocationContext(), requestBody, parts);
    }

    private boolean supportsDistributeApplication(InvocationContext ic) {
        boolean support = ic.getPageRepo().getBeanRepo().getBeanRepoDef().supportsCapabilities(List.of("AppDeploymentRuntimeUploadAndDeploy"));
        return support;
    }

    private static class AppDeploymentMBeanCreateHelper
    extends DeploymentUploadableCreatableBeanCollectionResource.DeploymentCreateHelper {
        private InvocationContext invocationContext;
        private List<FormProperty> formProperties;

        private AppDeploymentMBeanCreateHelper() {
        }

        @Override
        protected String getPlan() {
            return this.getStringProperty("PlanPath", false);
        }

        @Override
        protected Properties getDeploymentOptions() {
            String securityModel;
            Properties deploymentOptions = new Properties();
            String stageMode = this.getStringProperty("StagingMode", false);
            if (stageMode != null && !stageMode.equals("default")) {
                deploymentOptions.setProperty("stageMode", stageMode);
            }
            if ((securityModel = this.getStringProperty("SecurityModel", false)) != null && !securityModel.equals("DDOnly")) {
                deploymentOptions.setProperty("securityModel", securityModel);
            }
            return deploymentOptions;
        }

        @Override
        protected weblogic.remoteconsole.server.repo.Response<BeanTreePath> createBeanInternal(InvocationContext ic, List<FormProperty> properties, boolean multiPart) {
            weblogic.remoteconsole.server.repo.Response<BeanTreePath> response = super.createBeanInternal(ic, properties, multiPart);
            if (response.isSuccess()) {
                BeanTreePath defaultNewBeanPath = response.getResults();
                String baseAppName = defaultNewBeanPath.getLastSegment().getKey();
                weblogic.remoteconsole.server.repo.Response<List<String>> matchResponse = this.getMatchingAppNames(ic, baseAppName);
                if (!matchResponse.isSuccess()) {
                    return response.copyUnsuccessfulResponse(matchResponse);
                }
                BeanTreePath collectionBeanPath = ic.getBeanTreePath();
                List<String> matchingNames = matchResponse.getResults();
                if (matchingNames.size() == 1) {
                    String actualName = matchingNames.get(0);
                    BeanTreePath actualNewBeanPath = BeanTreePath.create(collectionBeanPath.getBeanRepo(), collectionBeanPath.getPath().childPath(actualName));
                    response.setSuccess(actualNewBeanPath);
                } else {
                    response.setSuccess(collectionBeanPath);
                }
            }
            return response;
        }

        @Override
        protected weblogic.remoteconsole.server.repo.Response<Void> createBean(InvocationContext ic, List<FormProperty> properties, boolean multiPart) {
            if (!multiPart) {
                return super.createBean(ic, properties, multiPart);
            }
            this.ic = ic;
            this.formProperties = properties;
            return ConfigurationTransactionHelper.editConfiguration(ic, new ConfigurationTransactionHelper.ConfigurationEditor(){

                @Override
                public weblogic.remoteconsole.server.repo.Response<Void> editConfiguration() {
                    return this.doCreate();
                }
            });
        }

        private weblogic.remoteconsole.server.repo.Response<List<String>> getMatchingAppNames(InvocationContext ic, String appName) {
            weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
            weblogic.remoteconsole.server.repo.Response<List<String>> getResponse = this.getAppNames(ic);
            if (!getResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(getResponse);
            }
            ArrayList<String> matchingNames = new ArrayList<String>();
            for (String candidateAppName : getResponse.getResults()) {
                if (!this.appNameMatches(candidateAppName, appName)) continue;
                matchingNames.add(candidateAppName);
            }
            return new weblogic.remoteconsole.server.repo.Response<ArrayList<String>>().setSuccess(matchingNames);
        }

        private boolean appNameMatches(String candidateAppName, String unversionedAppName) {
            String candidateUnversionedAppName;
            if (unversionedAppName.equals(candidateAppName)) {
                return true;
            }
            int versionIndex = candidateAppName.indexOf("#");
            return versionIndex > -1 && unversionedAppName.equals(candidateUnversionedAppName = candidateAppName.substring(0, versionIndex));
        }

        private weblogic.remoteconsole.server.repo.Response<List<String>> getAppNames(InvocationContext ic) {
            weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
            BeanTreePath collectionBTP = ic.getBeanTreePath();
            BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
            BeanPropertyDef namePropertyDef = collectionBTP.getTypeDef().getPropertyDef("Name");
            builder.addProperty(collectionBTP, namePropertyDef);
            weblogic.remoteconsole.server.repo.Response<BeanReaderRepoSearchResults> searchResponse = builder.search();
            if (!searchResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(searchResponse);
            }
            ArrayList<String> names = new ArrayList<String>();
            for (BeanSearchResults beanResults : searchResponse.getResults().getCollection(collectionBTP)) {
                names.add(beanResults.getValue(namePropertyDef).asString().getValue());
            }
            return response.setSuccess(names);
        }

        private weblogic.remoteconsole.server.repo.Response<Void> doCreate() {
            Path restPath = new Path("domainRuntime");
            restPath.addComponent("deploymentManager");
            restPath.addComponents(new String[]{"uploadAndDeploy"});
            JsonObject requestBodyProp = this.formPropertyToJasonObject(this.formProperties);
            boolean useExpandedValues = false;
            boolean saveChanges = false;
            boolean async = true;
            weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
            FormDataMultiPart multiParts = this.getParts(requestBodyProp, this.formProperties);
            weblogic.remoteconsole.server.repo.Response<JsonObject> postResponse = WebLogicRestInvoker.post(this.ic, restPath, multiParts, useExpandedValues, saveChanges, async);
            this.convertRestMessagesToRepoMessages(postResponse, response);
            return response.copyStatus(postResponse);
        }

        private JsonObject formPropertyToJasonObject(List<FormProperty> formProperties) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            this.setStringValue(formProperties, "Name", "name", builder);
            this.setStringValue(formProperties, "StagingModeUpload", "stageMode", builder);
            this.setStringValue(formProperties, "SecurityModelUpload", "securityModel", builder);
            this.setStringValue(formProperties, "OnDeploymentUpload", "onDeployment", builder);
            this.setArrayValue(formProperties, "Targets", "targets", builder);
            return builder.build();
        }

        private void setStringValue(List<FormProperty> formProperties, String propName, String useName, JsonObjectBuilder builder) {
            for (FormProperty oneProp : formProperties) {
                if (!oneProp.getName().equals(propName)) continue;
                builder.add(useName, (JsonValue)Json.createValue((String)oneProp.getValue().asSettable().getValue().asString().getValue()));
            }
        }

        private void setArrayValue(List<FormProperty> formProperties, String propName, String useName, JsonObjectBuilder builder) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (FormProperty oneProp : formProperties) {
                if (!oneProp.getName().equals(propName)) continue;
                ArrayValue targetsArrayValue = oneProp.getValue().asSettable().getValue().asArray();
                List<Value> targetsListFromForm = targetsArrayValue.getValues();
                for (Value one : targetsListFromForm) {
                    JsonString jsonValue = Json.createValue((String)((BeanTreePath)one).getLastSegment().getKey());
                    arrayBuilder.add((JsonValue)jsonValue);
                }
                builder.add(useName, (JsonValue)arrayBuilder.build());
            }
        }

        private FormDataMultiPart getParts(JsonObject requestBody, List<FormProperty> formProperties) {
            FormDataMultiPart parts = new FormDataMultiPart();
            parts.field("model", (Object)requestBody.toString(), MediaType.APPLICATION_JSON_TYPE);
            for (FormProperty formProperty : formProperties) {
                Value value = formProperty.getValue().asSettable().getValue();
                if (!value.isFileContents()) continue;
                FileContentsValue fcValue = value.asFileContents();
                parts.bodyPart((BodyPart)new StreamDataBodyPart(formProperty.getName(), fcValue.getInputStream(), fcValue.getFileName()));
            }
            return parts;
        }

        private void convertRestMessagesToRepoMessages(weblogic.remoteconsole.server.repo.Response<?> restResponse, weblogic.remoteconsole.server.repo.Response<?> repoResponse) {
            for (Message restMessage : restResponse.getMessages()) {
                repoResponse.addMessage(new Message(restMessage.getSeverity(), StringUtils.getBeanName((String)restMessage.getProperty()), restMessage.getText()));
            }
        }
    }
}

