/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.SliceTableDef;
import weblogic.remoteconsole.common.repodef.weblogic.AggregatedRuntimeMBeanNameHandler;
import weblogic.remoteconsole.customizers.AggregatedMBeanCollectionChildBeanResource;
import weblogic.remoteconsole.customizers.AggregatedMBeanMandatorySingletonBeanResource;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PageReaderHelper;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.BaseResource;

public class AggregatedMBeanCustomizer {
    private static final AggregatedRuntimeMBeanNameHandler NAME_HANDLER = AggregatedRuntimeMBeanNameHandler.INSTANCE;

    private AggregatedMBeanCustomizer() {
    }

    public static BaseResource createResource(InvocationContext ic) {
        if (ic.getBeanTreePath().isCollectionChild()) {
            return new AggregatedMBeanCollectionChildBeanResource();
        }
        if (ic.getBeanTreePath().isMandatorySingleton()) {
            return new AggregatedMBeanMandatorySingletonBeanResource();
        }
        return null;
    }

    public static List<TableRow> getSliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults overallSearchResults) {
        if (overallSearchResults.getBean(ic.getBeanTreePath()) == null) {
            throw Response.notFoundException();
        }
        Path unfabPath = NAME_HANDLER.getUnfabricatedBeanTreePath(ic.getBeanTreePath()).getPath();
        Path serverRelativePath = unfabPath.subPath(3, unfabPath.length());
        PageDef pageDef = ic.getPageRepo().asPageReaderRepo().getPageDef(ic).getResults();
        SliceTableDef sliceTableDef = pageDef.asSliceTableDef();
        BeanReaderRepoSearchResults searchResults = AggregatedMBeanCustomizer.findPerServerInstances(ic, sliceTableDef, serverRelativePath);
        return AggregatedMBeanCustomizer.createRows(ic, sliceTableDef, serverRelativePath, searchResults);
    }

    private static BeanReaderRepoSearchResults findPerServerInstances(InvocationContext ic, SliceTableDef sliceTableDef, Path serverRelativePath) {
        BeanTreePath combinedServerRuntimesBTP = AggregatedMBeanCustomizer.getCombinedServerRuntimesBTP(ic);
        BeanTreePath allInstances = combinedServerRuntimesBTP.childPath(new Path("ServerRuntime")).childPath(serverRelativePath);
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        builder.addProperty(combinedServerRuntimesBTP, combinedServerRuntimesBTP.getTypeDef().getIdentityPropertyDef());
        for (PagePropertyDef propertyDef : sliceTableDef.getAllPropertyDefs()) {
            builder.addProperty(allInstances, propertyDef);
            AggregatedMBeanCustomizer.getPageReaderHelper(ic).addParamsToSearch(builder, allInstances, propertyDef.getGetValueCustomizerDef());
        }
        return builder.search().getResults();
    }

    private static List<TableRow> createRows(InvocationContext ic, SliceTableDef sliceTableDef, Path serverRelativePath, BeanReaderRepoSearchResults searchResults) {
        TreeMap<String, TableRow> sortedRows = new TreeMap<String, TableRow>();
        for (BeanSearchResults combinedServerResults : searchResults.getCollection(AggregatedMBeanCustomizer.getCombinedServerRuntimesBTP(ic))) {
            BeanTreePath combinedServerRuntimeBTP = combinedServerResults.getBeanTreePath();
            BeanTreePath rowBTP = combinedServerRuntimeBTP.childPath(new Path("ServerRuntime")).childPath(serverRelativePath);
            BeanSearchResults rowResults = searchResults.getBean(rowBTP);
            if (rowResults == null) continue;
            TableRow row = AggregatedMBeanCustomizer.createRow(ic, sliceTableDef, combinedServerRuntimeBTP, rowResults);
            String serverName = combinedServerRuntimeBTP.getLastSegment().getKey();
            sortedRows.put(serverName, row);
        }
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        for (TableRow row : sortedRows.values()) {
            rows.add(row);
        }
        return rows;
    }

    private static TableRow createRow(InvocationContext ic, SliceTableDef sliceTableDef, BeanTreePath combinedServerRuntimeBTP, BeanSearchResults rowResults) {
        TableRow row = new TableRow();
        String serverName = combinedServerRuntimeBTP.getLastSegment().getKey();
        for (PagePropertyDef propertyDef : sliceTableDef.getAllPropertyDefs()) {
            boolean isServer = "Server".equals(propertyDef.getPropertyName());
            Value value = null;
            value = isServer ? combinedServerRuntimeBTP : AggregatedMBeanCustomizer.getPageReaderHelper(ic).getPropertyValue(propertyDef, rowResults.getBeanTreePath(), rowResults, rowResults.getSearchResults(), false).getResults();
            if (value == null) continue;
            row.getCells().add(new TableCell(propertyDef.getFormFieldName(), value));
            if (!isServer || sliceTableDef.getActionDefs().isEmpty()) continue;
            row.setIdentifier(serverName);
        }
        row.getCells().add(new TableCell("identity", rowResults.getBeanTreePath()));
        return row;
    }

    private static BeanTreePath getCombinedServerRuntimesBTP(InvocationContext ic) {
        return BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("DomainRuntime.CombinedServerRuntimes"));
    }

    private static PageReaderHelper getPageReaderHelper(InvocationContext ic) {
        return new PageReaderHelper(ic);
    }
}

