/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import weblogic.remoteconsole.common.utils.WebLogicVersion;

public class WebLogicVersions {
    private static final Logger LOGGER = Logger.getLogger(WebLogicVersions.class.getName());
    private static Map<String, WebLogicVersion> versionStringToVersion = new HashMap<String, WebLogicVersion>();
    private static Map<Long, WebLogicVersion> versionNumberToVersion = new TreeMap<Long, WebLogicVersion>();
    private static WebLogicVersion latestVersion = null;

    private static void addVersion(String domainVersion, String fmwVersion, String webLogicDocsUrl, String coherenceDocsUrl, String mbeanJavadocDirectory) {
        String resourceName = "harvestedWeblogicBeanTypes/" + domainVersion + "/DomainMBean.yaml";
        if (Thread.currentThread().getContextClassLoader().getResource(resourceName) == null) {
            return;
        }
        boolean isLatestVersion = versionStringToVersion.isEmpty();
        WebLogicVersion version = new WebLogicVersion(isLatestVersion, domainVersion, fmwVersion, webLogicDocsUrl, coherenceDocsUrl, mbeanJavadocDirectory);
        versionStringToVersion.put(domainVersion, version);
        versionNumberToVersion.put(WebLogicVersions.getVersionNumber(domainVersion), version);
        if (isLatestVersion) {
            latestVersion = version;
        }
    }

    public static WebLogicVersion getLatestVersion() {
        return latestVersion;
    }

    public static Collection<WebLogicVersion> getSupportedVersions() {
        return versionStringToVersion.values();
    }

    public static Set<String> getVersionCapabilities(WebLogicVersion version) {
        HashSet<String> capabilities = new HashSet<String>();
        long versionNumber = WebLogicVersions.getVersionNumber(version.getDomainVersion());
        for (WebLogicVersion supportedVersion : WebLogicVersions.getSupportedVersions()) {
            String supportedDomainVersion = supportedVersion.getDomainVersion();
            long supportedVersionNumber = WebLogicVersions.getVersionNumber(supportedDomainVersion);
            if (versionNumber < supportedVersionNumber) {
                capabilities.add("Before" + supportedDomainVersion);
                continue;
            }
            capabilities.add(supportedDomainVersion + "OrAfter");
        }
        return capabilities;
    }

    public static WebLogicVersion getVersion(String domainVersion) {
        WebLogicVersion weblogicVersion = versionStringToVersion.get(domainVersion);
        if (weblogicVersion != null) {
            return weblogicVersion;
        }
        long versionNumber = WebLogicVersions.getVersionNumber(domainVersion);
        long nearestPreviousVersionNumber = 0L;
        for (Long supportedVersionNumber : versionNumberToVersion.keySet()) {
            if (versionNumber <= supportedVersionNumber) continue;
            nearestPreviousVersionNumber = supportedVersionNumber;
        }
        LOGGER.finest("Using nearest previous weblogic version. want: " + versionNumber + " using: " + nearestPreviousVersionNumber);
        return versionNumberToVersion.get(nearestPreviousVersionNumber);
    }

    public static boolean isSupportedVersion(String version) {
        return WebLogicVersions.getVersion(version) != null;
    }

    private static long getVersionNumber(String domainVersion) {
        String[] numbers = domainVersion.split("\\.");
        if (numbers.length != 5) {
            throw WebLogicVersions.unsupportedDomainVersionSyntax(domainVersion);
        }
        long versionNumber = 0L;
        for (String number : numbers) {
            try {
                int num = Integer.parseUnsignedInt(number);
                versionNumber = versionNumber * 100L + (long)num;
            }
            catch (NumberFormatException e) {
                throw WebLogicVersions.unsupportedDomainVersionSyntax(domainVersion);
            }
        }
        return versionNumber;
    }

    private static AssertionError unsupportedDomainVersionSyntax(String domainVersion) {
        return new AssertionError((Object)("Unsupported domain version syntax: " + domainVersion + " expect xx.xx.xx.xx.xx, e.g. 14.1.1.0.0"));
    }

    static {
        WebLogicVersions.addVersion("15.1.1.0.0", "wls14120", "https://docs.oracle.com/en/middleware/fusion-middleware/weblogic-server/14.1.2", "https://docs.oracle.com/en/middleware/fusion-middleware/coherence/14.1.2", "wlmbr/mbeans");
        WebLogicVersions.addVersion("14.1.2.0.0", "wls14120", "https://docs.oracle.com/en/middleware/fusion-middleware/weblogic-server/14.1.2", "https://docs.oracle.com/en/middleware/fusion-middleware/coherence/14.1.2", "wlmbr/mbeans");
        WebLogicVersions.addVersion("14.1.1.0.0", "wls14110", "https://docs.oracle.com/en/middleware/standalone/weblogic-server/14.1.1.0", "https://docs.oracle.com/en/middleware/standalone/coherence/14.1.1.0", "wlmbr/mbeans");
        WebLogicVersions.addVersion("12.2.1.6.0", "fmw122140", "https://docs.oracle.com/en/middleware/fusion-middleware/weblogic-server/12.2.1.4", "https://docs.oracle.com/en/middleware/fusion-middleware/coherence/12.2.1.4", "wlmbr/mbeans");
        WebLogicVersions.addVersion("12.2.1.5.0", "fmw122140", "https://docs.oracle.com/en/middleware/fusion-middleware/weblogic-server/12.2.1.4", "https://docs.oracle.com/en/middleware/fusion-middleware/coherence/12.2.1.4", "wlmbr/mbeans");
        WebLogicVersions.addVersion("12.2.1.4.0", "fmw122140", "https://docs.oracle.com/en/middleware/fusion-middleware/weblogic-server/12.2.1.4", "https://docs.oracle.com/en/middleware/fusion-middleware/coherence/12.2.1.4", "wlmbr/mbeans");
        WebLogicVersions.addVersion("12.2.1.3.0", "fmw122130", "https://docs.oracle.com/middleware/12213/wls", "https://docs.oracle.com/middleware/12213/coherence", "WLMBR/mbeans");
    }
}

