/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

public class WebLogicVersion {
    private boolean latestVersion;
    private String domainVersion;
    private String fmwVersion;
    private String webLogicDocsUrl;
    private String coherenceDocsUrl;
    private String mbeanJavadocDirectory;

    WebLogicVersion(boolean latestVersion, String domainVersion, String fmwVersion, String webLogicDocsUrl, String coherenceDocsUrl, String mbeanJavadocDirectory) {
        this.latestVersion = latestVersion;
        this.domainVersion = domainVersion;
        this.fmwVersion = fmwVersion;
        this.webLogicDocsUrl = webLogicDocsUrl;
        this.coherenceDocsUrl = coherenceDocsUrl;
        this.mbeanJavadocDirectory = mbeanJavadocDirectory;
    }

    public boolean isLatestVersion() {
        return this.latestVersion;
    }

    public String getDomainVersion() {
        return this.domainVersion;
    }

    private String getFmwVersion() {
        return this.fmwVersion;
    }

    private String getWebLogicDocsUrl() {
        return this.webLogicDocsUrl;
    }

    private String getCoherenceDocsUrl() {
        return this.coherenceDocsUrl;
    }

    private String getMBeanJavadocDirectory() {
        return this.mbeanJavadocDirectory;
    }

    public String getMBeanTypeJavadocUrl(String mbeanType) {
        return this.getWebLogicDocsUrl() + "/" + this.getMBeanJavadocDirectory() + "/" + mbeanType + ".html";
    }

    public String getMBeanAttributeJavadocUrl(String mbeanType, String attribute) {
        return this.getMBeanTypeJavadocUrl(mbeanType) + "#" + attribute;
    }

    public String getMBeanOperationJavadocUrl(String mbeanType, String operation) {
        return this.getMBeanTypeJavadocUrl(mbeanType) + "#" + operation;
    }

    public String getEdocsHelpTopicUrl(String relativeHelpTopicUrl) {
        return this.getWebLogicDocsUrl() + "/" + relativeHelpTopicUrl;
    }

    public String getCoherenceEdocsHelpTopicUrl(String relativeHelpTopicUrl) {
        return this.getCoherenceDocsUrl() + "/" + relativeHelpTopicUrl;
    }

    public String getGenericHelpTopicUrl(String genericTopicUrl) {
        return genericTopicUrl.replaceAll("@FMW_VERSION@&amp;", this.getFmwVersion() + "&");
    }

    public String toString() {
        return this.getDomainVersion();
    }
}

