/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.remoteconsole.common.utils.OfflineWebLogicMBeansVersion;
import weblogic.remoteconsole.common.utils.OnlineWebLogicMBeansVersion;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersion;
import weblogic.remoteconsole.common.utils.WebLogicVersion;
import weblogic.remoteconsole.server.connection.Connection;

public class WebLogicMBeansVersions {
    private static Map<String, WeakReference<OfflineWebLogicMBeansVersion>> offlineVersionsMap = new ConcurrentHashMap<String, WeakReference<OfflineWebLogicMBeansVersion>>();

    private WebLogicMBeansVersions() {
    }

    public static WebLogicMBeansVersion getVersion(Connection connection) {
        return new OnlineWebLogicMBeansVersion(connection);
    }

    public static WebLogicMBeansVersion getVersion(WebLogicVersion weblogicVersion, Set<String> capabilities) {
        String key = WebLogicMBeansVersions.computeOfflineKey(weblogicVersion, capabilities);
        WeakReference<OfflineWebLogicMBeansVersion> ret = offlineVersionsMap.computeIfAbsent(key, k -> new WeakReference<OfflineWebLogicMBeansVersion>(new OfflineWebLogicMBeansVersion(weblogicVersion, capabilities)));
        if (ret.get() == null) {
            ret = new WeakReference<OfflineWebLogicMBeansVersion>(new OfflineWebLogicMBeansVersion(weblogicVersion, capabilities));
            offlineVersionsMap.put(key, ret);
        }
        return (WebLogicMBeansVersion)ret.get();
    }

    private static String computeOfflineKey(WebLogicVersion weblogicVersion, Set<String> capabilities) {
        StringBuilder sb = new StringBuilder();
        sb.append(weblogicVersion.getDomainVersion());
        for (String capability : new TreeSet<String>(capabilities)) {
            sb.append("_capability_").append(capability);
        }
        return sb.toString();
    }
}

