/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.remoteconsole.common.utils.OfflineWebLogicMBeansVersion;
import weblogic.remoteconsole.common.utils.OnlineWebLogicMBeansVersion;
import weblogic.remoteconsole.common.utils.RemoteConsoleExtension;
import weblogic.remoteconsole.common.utils.WebLogicVersion;
import weblogic.remoteconsole.server.ConsoleBackendRuntimeConfig;

public abstract class WebLogicMBeansVersion {
    public static final Set<String> ALL_CAPABILITIES = Set.of("All");
    private Map<String, Object> cache = new ConcurrentHashMap<String, Object>();

    public abstract WebLogicVersion getWebLogicVersion();

    public abstract Set<String> getRoles();

    public boolean isAccessAllowed(Set<String> rolesAllowed) {
        return WebLogicMBeansVersion.isAccessAllowed(this.getRoles(), rolesAllowed);
    }

    public static boolean isAccessAllowed(Set<String> rolesHave, Set<String> rolesAllowed) {
        if (!ConsoleBackendRuntimeConfig.isRestrictContentBasedOnRoles()) {
            return true;
        }
        for (String roleAllowed : rolesAllowed) {
            if (!rolesHave.contains(roleAllowed)) continue;
            return true;
        }
        return false;
    }

    public abstract Set<String> getCapabilities();

    public abstract List<RemoteConsoleExtension> getExtensions();

    private <T> T putCache(Class<T> clazz, T value) {
        this.cache.put(clazz.getName(), value);
        return value;
    }

    private <T> T getCache(Class<T> clazz) {
        T result = null;
        Object object = this.cache.get(clazz.getName());
        if (object != null && object.getClass().isAssignableFrom(clazz)) {
            result = clazz.cast(object);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T findOrCreate(Class<T> clazz) {
        T instance = this.getCache(clazz);
        if (instance == null) {
            WebLogicMBeansVersion webLogicMBeansVersion = this;
            synchronized (webLogicMBeansVersion) {
                instance = this.getCache(clazz);
                if (instance == null) {
                    try {
                        instance = this.putCache(clazz, clazz.getDeclaredConstructor(WebLogicMBeansVersion.class).newInstance(this));
                    }
                    catch (Exception e) {
                        throw new AssertionError("Error instantiating " + clazz.getName(), e);
                    }
                }
            }
        }
        return instance;
    }

    public boolean isOffline() {
        return this instanceof OfflineWebLogicMBeansVersion;
    }

    public OfflineWebLogicMBeansVersion asOffline() {
        return (OfflineWebLogicMBeansVersion)this;
    }

    public boolean isOnline() {
        return this instanceof OnlineWebLogicMBeansVersion;
    }

    public OnlineWebLogicMBeansVersion asOnline() {
        return (OnlineWebLogicMBeansVersion)this;
    }
}

