/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;

public class UrlUtils {
    private static final String DUMMY_URL_PREFIX = "http://dummyHost:9999/";

    private UrlUtils() {
    }

    public static Path relativeUriToPath(String relativeUri) {
        Path path = new Path();
        for (String encodedComponent : StringUtils.nonEmpty((String)relativeUri).split("/")) {
            path.addComponent(UrlUtils.urlDecode(encodedComponent));
        }
        return path;
    }

    public static String pathToRelativeUri(Path unencodedPath) {
        Path encodedPath = new Path();
        for (String component : unencodedPath.getComponents()) {
            encodedPath.addComponent(UrlUtils.urlEncode(component));
        }
        return encodedPath.getSlashSeparatedPath();
    }

    public static String urlEncode(String str) {
        String encodedUri = UriBuilder.fromPath((String)DUMMY_URL_PREFIX).segment(new String[]{str}).build(new Object[0]).toString();
        return encodedUri.substring(DUMMY_URL_PREFIX.length());
    }

    public static String urlDecode(String str) {
        try {
            String encodedUri = DUMMY_URL_PREFIX + str;
            return new URI(encodedUri).getPath().substring(1);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String computeQueryParam(String queryParamName, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        return UrlUtils.computeQueryParam(queryParamName, values);
    }

    public static String computeQueryParam(String queryParamName, List<String> values) {
        UriBuilder bldr = UriBuilder.fromPath((String)"");
        for (String value : values) {
            bldr.queryParam(queryParamName, new Object[]{value});
        }
        String uriStr = bldr.build(new Object[0]).toString();
        return uriStr.substring(uriStr.indexOf("?") + 1);
    }
}

