/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class SupportedLocales {
    public static List<String> OUR_LANGUAGES = Arrays.asList("en", "en-US", "de", "es", "fr", "it", "ja", "ko", "pt-BR", "zh-CN", "zh-TW");

    public static String getFirstSupportedAcceptLanguage(List<Locale> locales) {
        Locale selectedLocale = SupportedLocales.getFirstSupportedAcceptLocale(locales);
        return SupportedLocales.langAndCountry(selectedLocale);
    }

    public static String langAndCountry(Locale selectedLocale) {
        String country = selectedLocale.getCountry();
        return selectedLocale.getLanguage() + (String)(country.equals("") ? "" : "-" + country);
    }

    public static Locale getFirstSupportedAcceptLocale(List<Locale> locales) {
        if (locales == null) {
            locales = new ArrayList<Locale>(Arrays.asList(Locale.getDefault()));
        }
        Locale selectedLocale = null;
        for (int i = 0; i < locales.size() && selectedLocale == null; ++i) {
            Locale locale = locales.get(i);
            if (!SupportedLocales.listContainsIgnoreCase(OUR_LANGUAGES, SupportedLocales.langAndCountry(locale))) continue;
            selectedLocale = locale;
        }
        if (selectedLocale == null) {
            selectedLocale = Locale.ENGLISH;
        }
        return selectedLocale;
    }

    private static boolean listContainsIgnoreCase(List<String> theList, String theString) {
        for (String element : theList) {
            if (!element.equalsIgnoreCase(theString)) continue;
            return true;
        }
        return false;
    }
}

