/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.utils.Message;

public class MessageUtils {
    private MessageUtils() {
    }

    public static JsonObject throwableAsMessagesJsonObject(Throwable throwable, String text) {
        return Json.createObjectBuilder().add("messages", (JsonValue)MessageUtils.throwableAsMessagesJsonArray(throwable, text)).build();
    }

    public static JsonArray createMessagesJsonArray(List<Message> messages) {
        JsonArrayBuilder messagesBldr = Json.createArrayBuilder();
        for (Message message : messages) {
            messagesBldr.add((JsonValue)MessageUtils.getMessageJson(message));
        }
        return messagesBldr.build();
    }

    public static JsonObject getMessageJson(Message message) {
        JsonObjectBuilder messageBldr = Json.createObjectBuilder().add("message", message.getText()).add("severity", message.getSeverity().name());
        String property = message.getProperty();
        if (StringUtils.notEmpty((String)property)) {
            messageBldr.add("property", property);
        }
        return messageBldr.build();
    }

    public static JsonArray throwableAsMessagesJsonArray(Throwable throwable) {
        return MessageUtils.throwableAsMessagesJsonArray(throwable, null);
    }

    private static JsonArray throwableAsMessagesJsonArray(Throwable throwable, String text) {
        String text1;
        ArrayList<Message> list = new ArrayList<Message>();
        if (text != null) {
            list.add(Message.newFailureMessage(text));
        }
        if (throwable != null && (text1 = MessageUtils.getExceptionMessage(throwable)) != null && !text1.equals(text)) {
            list.add(Message.newFailureMessage(text1));
        }
        return MessageUtils.createMessagesJsonArray(list);
    }

    private static String getExceptionMessage(Throwable t) {
        if (t == null) {
            return "";
        }
        String message = t.getLocalizedMessage();
        if (StringUtils.isEmpty((String)message)) {
            message = t.toString();
        }
        if (StringUtils.isEmpty((String)message)) {
            message = t.getClass().getName();
        }
        return message;
    }
}

