/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

import weblogic.console.utils.StringUtils;

public class Message {
    private Severity severity = Severity.SUCCESS;
    private String property;
    private String text;

    public static Message newSuccessMessage(String text) {
        return Message.newSuccessMessage(null, text);
    }

    public static Message newSuccessMessage(String property, String text) {
        return new Message(Severity.SUCCESS, property, text);
    }

    public static Message newWarningMessage(String text) {
        return Message.newWarningMessage(null, text);
    }

    public static Message newWarningMessage(String property, String text) {
        return new Message(Severity.WARNING, property, text);
    }

    public static Message newFailureMessage(String text) {
        return Message.newFailureMessage(null, text);
    }

    public static Message newFailureMessage(String property, String text) {
        return new Message(Severity.FAILURE, property, text);
    }

    public Message(String severityAsString, String text) {
        this(severityAsString, null, text);
    }

    public Message(String severityAsString, String property, String text) {
        this(Message.severityStringToSeverity(severityAsString), property, text);
    }

    public Message(Severity severity, String text) {
        this(severity, null, text);
    }

    public Message(Severity severity, String property, String text) {
        if ("java.lang.NullPointerException".equals(text)) {
            text = "An unexpected exception has occurred processing your request";
        }
        this.severity = severity;
        this.property = property;
        this.text = text;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public boolean isSuccess() {
        return Severity.SUCCESS == this.getSeverity();
    }

    public boolean isWarning() {
        return Severity.WARNING == this.getSeverity();
    }

    public boolean isFailure() {
        return Severity.FAILURE == this.getSeverity();
    }

    public String getProperty() {
        return this.property;
    }

    public String getText() {
        return this.text;
    }

    private static Severity severityStringToSeverity(String severityAsString) {
        if (Severity.SUCCESS.toString().equals(severityAsString)) {
            return Severity.SUCCESS;
        }
        if (Severity.WARNING.toString().equals(severityAsString)) {
            return Severity.WARNING;
        }
        if (Severity.FAILURE.toString().equals(severityAsString)) {
            return Severity.FAILURE;
        }
        throw new AssertionError((Object)("Unexpected severity: " + severityAsString));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Message<").append((Object)this.getSeverity());
        if (StringUtils.notEmpty((String)this.getProperty())) {
            sb.append("," + this.getProperty());
        }
        sb.append(",").append(this.getText()).append(">");
        return sb.toString();
    }

    public static enum Severity {
        SUCCESS,
        WARNING,
        FAILURE;

    }
}

