/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverAttribute;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoFactory;
import weblogic.remoteconsole.jdbc.utils.MetaJDBCDriverInfo;

public class JDBCDriversUtils {
    private static final String JDBC_DRIVERS_RESOURCE = "jdbcdrivers.yaml";
    private static List<MetaJDBCDriverInfo> driverInfos = new ArrayList<MetaJDBCDriverInfo>();
    private static JDBCDriverInfoFactory infoFactory = null;

    public static JDBCDriverInfoFactory getJDBCDriverInfoFactory() {
        if (infoFactory == null) {
            if (driverInfos.isEmpty()) {
                driverInfos = JDBCDriversUtils.getJdbcDrivers();
            }
            infoFactory = new JDBCDriverInfoFactory(driverInfos);
        }
        return infoFactory;
    }

    public static List<MetaJDBCDriverInfo> getJdbcDrivers() {
        InputStream is = JDBCDriversUtils.class.getClassLoader().getResourceAsStream(JDBC_DRIVERS_RESOURCE);
        Yaml yaml = new Yaml();
        Map obj = (Map)yaml.load(is);
        try {
            is.close();
        }
        catch (IOException ignore) {
            is = null;
        }
        ArrayList rawDriversList = (ArrayList)((Map)obj.get("JDBC-Drivers")).get("Driver");
        for (Map driverObj : rawDriversList) {
            MetaJDBCDriverInfo driver = new MetaJDBCDriverInfo();
            block29: for (Map.Entry entry : driverObj.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                switch (key) {
                    case "@_Database": {
                        driver.setDbmsVendor((String)value);
                        continue block29;
                    }
                    case "@_Vendor": {
                        driver.setDriverVendor((String)value);
                        continue block29;
                    }
                    case "@_Type": {
                        driver.setType((String)value);
                        continue block29;
                    }
                    case "@_DatabaseVersion": {
                        driver.setDbmsVersion((String)value);
                        continue block29;
                    }
                    case "@_ForXA": {
                        driver.setForXA(((String)value).equalsIgnoreCase("true"));
                        continue block29;
                    }
                    case "@_ClassName": {
                        driver.setDriverClassName((String)value);
                        continue block29;
                    }
                    case "@_URLHelperClassname": {
                        driver.setURLHelperClassName(((String)value).replace("weblogic.jdbc.utils", "weblogic.remoteconsole.jdbc.utils"));
                        continue block29;
                    }
                    case "@_TestSql": {
                        driver.setTestSQL((String)value);
                        continue block29;
                    }
                    case "@_Description": {
                        driver.setDescription((String)value);
                        continue block29;
                    }
                    case "@_Cert": {
                        driver.setCert(((String)value).equalsIgnoreCase("true"));
                        continue block29;
                    }
                    case "Attribute": {
                        JDBCDriversUtils.setDriverAttributes(driver, (List)value);
                        continue block29;
                    }
                }
                System.out.println("No action defined for Driver key: " + key);
            }
            driverInfos.add(driver);
        }
        return driverInfos;
    }

    private static void setDriverAttributes(MetaJDBCDriverInfo driver, List<Map<String, String>> rawAttributes) {
        for (Map<String, String> attr : rawAttributes) {
            JDBCDriverAttribute attribute = new JDBCDriverAttribute(driver);
            block17: for (Map.Entry<String, String> entry : attr.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                switch (key) {
                    case "@_Name": {
                        attribute.setName(value);
                        driver.setDriverAttribute(value, attribute);
                        continue block17;
                    }
                    case "@_Required": {
                        attribute.setIsRequired(value);
                        continue block17;
                    }
                    case "@_Encrypted": {
                        attribute.setEncrypted(value);
                        continue block17;
                    }
                    case "@_InURL": {
                        attribute.setInURL(value.equalsIgnoreCase("true"));
                        continue block17;
                    }
                    case "@_Description": {
                        attribute.setDescription(value);
                        continue block17;
                    }
                    case "@_DefaultValue": {
                        attribute.setDefaultValue(value);
                        continue block17;
                    }
                }
                System.out.println("No action defined for JDBCDriverAttribute key: " + key);
            }
        }
    }

    public static void main(String ... args) {
        List<MetaJDBCDriverInfo> drivers = JDBCDriversUtils.getJdbcDrivers();
        System.out.println(drivers);
    }
}

