/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import weblogic.console.utils.StringUtils;

public class DateUtils {
    private DateUtils() {
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.getFormat().format(date);
    }

    public static Date parseDate(String dateAsString) throws ParseException {
        if (StringUtils.isEmpty((String)dateAsString)) {
            return null;
        }
        return DateUtils.getFormat().parse(dateAsString);
    }

    public static long getRoundedDateAsLong(Date date) {
        if (date == null) {
            return 0L;
        }
        try {
            Date roundedDate = DateUtils.parseDate(DateUtils.formatDate(date));
            return roundedDate.getTime();
        }
        catch (ParseException e) {
            throw new AssertionError(date.toString(), e);
        }
    }

    private static SimpleDateFormat getFormat() {
        return new SimpleDateFormat("EEE MMM dd kk:mm:ss z yyyy");
    }
}

