/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import weblogic.remoteconsole.customizers.Source;

public class CustomizerSourceUtils {
    private CustomizerSourceUtils() {
    }

    public static List<Parameter> getParameters(Method method) {
        ArrayList<Parameter> rtn = new ArrayList<Parameter>();
        Type[] types = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < types.length; ++i) {
            rtn.add(new Parameter(types[i], CustomizerSourceUtils.getSourceAnnotation(method, annotations[i])));
        }
        return rtn;
    }

    private static Source getSourceAnnotation(Method method, Annotation[] annotations) {
        Source rtn = null;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Source)) continue;
            if (rtn != null) {
                throw new AssertionError((Object)(String.valueOf(method) + " multiple Source annotations"));
            }
            rtn = (Source)annotation;
        }
        return rtn;
    }

    public static class Parameter {
        private Type type;
        private Source source;

        public Type getType() {
            return this.type;
        }

        public Source getSource() {
            return this.source;
        }

        public String toString() {
            return "Parameter(type=" + String.valueOf(this.getType()) + ", source=" + String.valueOf(this.getSource()) + ")";
        }

        private Parameter(Type type, Source source) {
            this.type = type;
            this.source = source;
        }
    }
}

