/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import weblogic.console.utils.StringUtils;

public class CustomizerInvocationUtils {
    private CustomizerInvocationUtils() {
    }

    public static Object invokeMethod(Method method, List<Object> args) {
        try {
            return method.invoke(null, args.toArray());
        }
        catch (InvocationTargetException e) {
            CustomizerInvocationUtils.rethrow(e.getCause());
        }
        catch (IllegalAccessException e) {
            CustomizerInvocationUtils.rethrow(e);
        }
        return null;
    }

    public static boolean methodExists(String customizerName) {
        return CustomizerInvocationUtils.getMethod(customizerName, false) != null;
    }

    public static Method getMethod(String customizerName) {
        return CustomizerInvocationUtils.getMethod(customizerName, true);
    }

    public static Method getMethod(String customizerName, boolean mustExist) {
        int idx = customizerName.lastIndexOf(".");
        if (idx < 1 || idx >= customizerName.length() - 1) {
            throw new AssertionError((Object)("Not <java class name>.<method name> : " + customizerName));
        }
        String javaClassName = customizerName.substring(0, idx);
        Class clazz = CustomizerInvocationUtils.findJavaClass(javaClassName, mustExist);
        if (clazz != null) {
            String methodName = customizerName.substring(idx + 1);
            Method method = CustomizerInvocationUtils.findMethod(clazz, methodName, mustExist);
            if (method != null) {
                CustomizerInvocationUtils.checkThrows(method);
            }
            return method;
        }
        return null;
    }

    public static void checkSignature(Method method, Type returnTypeWant, List<Type> argTypesWant) {
        CustomizerInvocationUtils.checkSignature(method, returnTypeWant, argTypesWant.toArray(new Type[0]));
    }

    public static void checkSignature(Method method, Type returnTypeWant, Type ... argTypesWant) {
        CustomizerInvocationUtils.checkReturnType(method, returnTypeWant);
        CustomizerInvocationUtils.checkArgTypes(method, argTypesWant);
    }

    public static boolean isReturnType(Method method, Type want) {
        return want.equals(method.getGenericReturnType());
    }

    public static void checkReturnType(Method method, Type want) {
        if (!CustomizerInvocationUtils.isReturnType(method, want)) {
            throw new AssertionError((Object)(String.valueOf(method) + " must return a " + String.valueOf(want)));
        }
    }

    public static void checkArgTypes(Method method, List<Type> want) {
        CustomizerInvocationUtils.checkArgTypes(method, want.toArray(new Type[0]));
    }

    public static void checkArgTypes(Method method, Type ... want) {
        if (!Arrays.equals(want, method.getGenericParameterTypes())) {
            throw new AssertionError((Object)(String.valueOf(method) + " must have the following args " + Arrays.toString(want)));
        }
    }

    private static void checkThrows(Method method) {
        Class<?>[] exTypes = method.getExceptionTypes();
        if (exTypes.length == 0) {
            return;
        }
        throw new AssertionError((Object)(String.valueOf(method) + " must throw not throw typed exceptions"));
    }

    private static Method findMethod(Class clazz, String methodName, boolean mustExist) {
        if (StringUtils.isEmpty((String)methodName)) {
            throw new AssertionError((Object)"method name not specified");
        }
        Method rtn = null;
        for (Method method : clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            if (rtn == null) {
                rtn = method;
                continue;
            }
            throw new AssertionError((Object)(String.valueOf(clazz) + " has more than one public method named " + methodName));
        }
        if (rtn == null && mustExist) {
            throw new AssertionError((Object)(String.valueOf(clazz) + " does not have a public method named " + methodName));
        }
        return rtn;
    }

    private static Class findJavaClass(String javaClassName, boolean mustExist) {
        if (StringUtils.isEmpty((String)javaClassName)) {
            throw new AssertionError((Object)"javaClassName not specified");
        }
        try {
            return Class.forName(javaClassName);
        }
        catch (ClassNotFoundException e) {
            if (mustExist) {
                throw new AssertionError((Object)("Can't find class " + javaClassName));
            }
            return null;
        }
    }

    private static void rethrow(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }
}

