/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import weblogic.console.schema.YamlSource;
import weblogic.console.schema.beaninfo.BeanActionDefSource;
import weblogic.console.schema.beaninfo.BeanPropertyDefSource;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanRepoDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CreateFormPagePath;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagesPath;
import weblogic.remoteconsole.common.repodef.SlicePagePath;
import weblogic.remoteconsole.common.repodef.TablePagePath;
import weblogic.remoteconsole.common.repodef.schema.BeanChildDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanPropertyDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanTypeDefCustomizerExtensionSource;
import weblogic.remoteconsole.common.repodef.schema.BeanTypeDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanTypeDefExtensionSource;
import weblogic.remoteconsole.common.repodef.schema.CreateFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.LinksDefSource;
import weblogic.remoteconsole.common.repodef.schema.NavTreeDefExtensionSource;
import weblogic.remoteconsole.common.repodef.schema.NavTreeDefSource;
import weblogic.remoteconsole.common.repodef.schema.NavTreeNodeDefSource;
import weblogic.remoteconsole.common.repodef.schema.PseudoBeanTypeDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceTableDefSource;
import weblogic.remoteconsole.common.repodef.schema.SlicesDefSource;
import weblogic.remoteconsole.common.repodef.schema.SubTypeDefSource;
import weblogic.remoteconsole.common.repodef.schema.TableDefSource;
import weblogic.remoteconsole.common.repodef.yaml.SlicesDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.YamlDirectoryReader;

public abstract class YamlReader {
    protected abstract List<YamlDirectoryReader> getTypeYamlDirectoryReaders();

    protected abstract List<YamlDirectoryReader> getTypeCustomizationYamlDirectoryReaders();

    public BeanTypeDefSource getBeanTypeDefSource(BeanRepoDef repoDef, String type) {
        BeanTypeDefSource source = this.getFirstSource(this.getTypeYamlDirectoryReaders(), type + ".yaml", BeanTypeDefSource.class);
        if (source != null) {
            this.applyBeanTypeDefExtensions(type, source);
        }
        return source;
    }

    private void applyBeanTypeDefExtensions(String type, BeanTypeDefSource source) {
        for (BeanTypeDefExtensionSource extensionSource : this.getTypeCustomizationSources(this.getTypeRelativeYamlPath(type, "extension.yaml"), BeanTypeDefExtensionSource.class)) {
            this.applyBeanTypeDefExtension(type, source, extensionSource);
        }
    }

    private void applyBeanTypeDefExtension(String type, BeanTypeDefSource source, BeanTypeDefExtensionSource extensionSource) {
        HashMap<String, BeanPropertyDefSource> properties = new HashMap<String, BeanPropertyDefSource>();
        for (BeanPropertyDefSource property : source.getProperties()) {
            properties.put(property.getName(), property);
        }
        for (BeanPropertyDefSource property : extensionSource.getProperties()) {
            properties.put(property.getName(), property);
        }
        source.setProperties(new ArrayList(properties.values()));
        HashMap<String, BeanActionDefSource> actions = new HashMap<String, BeanActionDefSource>();
        for (BeanActionDefSource action : source.getActions()) {
            actions.put(action.getName(), action);
        }
        for (BeanActionDefSource action : extensionSource.getActions()) {
            actions.put(action.getName(), action);
        }
        source.setActions(new ArrayList(actions.values()));
    }

    public PseudoBeanTypeDefSource getPseudoBeanTypeDefSource(BeanRepoDef repoDef, String type) {
        return this.getFirstTypeCustomizationSource(this.getTypeRelativeYamlPath(type, "pseudo-type.yaml"), PseudoBeanTypeDefSource.class);
    }

    public BeanTypeDefCustomizerSource getBeanTypeDefCustomizerSource(BeanTypeDef typeDef) {
        BeanTypeDefCustomizerSource source = this.getFirstTypeCustomizationSource(this.getTypeRelativeYamlPath(typeDef, "type.yaml"), BeanTypeDefCustomizerSource.class);
        if (source != null) {
            this.applyBeanTypeDefCustomizerExtensions(typeDef, source);
        }
        return source;
    }

    private void applyBeanTypeDefCustomizerExtensions(BeanTypeDef typeDef, BeanTypeDefCustomizerSource source) {
        for (BeanTypeDefCustomizerExtensionSource extensionSource : this.getTypeCustomizationSources(this.getTypeRelativeYamlPath(typeDef, "type-extension.yaml"), BeanTypeDefCustomizerExtensionSource.class)) {
            this.applyBeanTypeDefCustomizerExtension(typeDef, source, extensionSource);
        }
    }

    private void applyBeanTypeDefCustomizerExtension(BeanTypeDef typeDef, BeanTypeDefCustomizerSource source, BeanTypeDefCustomizerExtensionSource extensionSource) {
        for (BeanPropertyDefCustomizerSource property : extensionSource.getProperties()) {
            source.addProperty(property);
        }
        for (BeanChildDefCustomizerSource child : extensionSource.getChildren()) {
            source.addChild(child);
        }
        for (SubTypeDefSource subType : extensionSource.getSubTypes()) {
            source.addSubType(subType);
        }
    }

    public SlicesDefSource getSlicesDefSource(BeanTypeDef typeDef) {
        return this.getFirstTypeCustomizationSource(this.getTypeRelativeYamlPath(typeDef, "slices.yaml"), SlicesDefSource.class);
    }

    public SliceFormDefSource getSliceFormDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        SliceFormDefSource source = this.getSliceFormDefSource(this.getTypeRelativeYamlPath(pagePath, "slices"), pagePath);
        if (source != null) {
            return source;
        }
        for (String alternateSliceSource : slicesDefImpl.getAlternateSliceSources()) {
            source = this.getSliceFormDefSource(alternateSliceSource, pagePath);
            if (source == null) continue;
            return source;
        }
        return null;
    }

    private SliceFormDefSource getSliceFormDefSource(String slicesYamlDir, SlicePagePath pagePath) {
        return this.getFirstTypeCustomizationSource(slicesYamlDir + "/" + pagePath.getSlicePath().getSlashSeparatedPath() + "/form.yaml", SliceFormDefSource.class);
    }

    public SliceTableDefSource getSliceTableDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        SliceTableDefSource source = this.getSliceTableDefSource(this.getTypeRelativeYamlPath(pagePath, "slices"), pagePath);
        if (source != null) {
            return source;
        }
        for (String alternateSliceSource : slicesDefImpl.getAlternateSliceSources()) {
            source = this.getSliceTableDefSource(alternateSliceSource, pagePath);
            if (source == null) continue;
            return source;
        }
        return null;
    }

    private SliceTableDefSource getSliceTableDefSource(String slicesYamlDir, SlicePagePath pagePath) {
        return this.getFirstTypeCustomizationSource(slicesYamlDir + "/" + pagePath.getSlicePath().getSlashSeparatedPath() + "/table.yaml", SliceTableDefSource.class);
    }

    public CreateFormDefSource getCreateFormDefSource(CreateFormPagePath pagePath) {
        return this.getFirstTypeCustomizationSource(this.getTypeRelativeYamlPath(pagePath, "create-form.yaml"), CreateFormDefSource.class);
    }

    public TableDefSource getTableDefSource(TablePagePath pagePath) {
        return this.getFirstTypeCustomizationSource(this.getTypeRelativeYamlPath(pagePath, "table.yaml"), TableDefSource.class);
    }

    public NavTreeDefSource getNavTreeDefSource(String type) {
        NavTreeDefSource source = this.getFirstTypeCustomizationSource(this.getTypeRelativeYamlPath(type, "nav-tree.yaml"), NavTreeDefSource.class);
        if (source != null) {
            this.applyNavTreeDefExtensions(type, source);
        }
        return source;
    }

    private void applyNavTreeDefExtensions(String type, NavTreeDefSource source) {
        for (NavTreeDefExtensionSource extensionSource : this.getTypeCustomizationSources(this.getTypeRelativeYamlPath(type, "nav-tree-extension.yaml"), NavTreeDefExtensionSource.class)) {
            this.applyNavTreeDefExtension(type, source, extensionSource);
        }
    }

    public NavTreeDefSource getRootNavTreeDefSource(String navTreeName) {
        NavTreeDefSource source = this.getFirstTypeCustomizationSource("roots/" + navTreeName + "/nav-tree.yaml", NavTreeDefSource.class);
        if (source != null) {
            this.applyRootNavTreeDefExtensions(navTreeName, source);
        }
        return source;
    }

    private void applyRootNavTreeDefExtensions(String navTreeName, NavTreeDefSource source) {
        for (NavTreeDefExtensionSource extensionSource : this.getTypeCustomizationSources("roots/" + navTreeName + "/nav-tree-extension.yaml", NavTreeDefExtensionSource.class)) {
            this.applyNavTreeDefExtension(navTreeName, source, extensionSource);
        }
    }

    private void applyNavTreeDefExtension(String scope, NavTreeDefSource source, NavTreeDefExtensionSource extensionSource) {
        ArrayList<NavTreeNodeDefSource> newContents = new ArrayList<NavTreeNodeDefSource>(source.getContents());
        for (NavTreeNodeDefSource content : extensionSource.getContents()) {
            newContents.add(content);
        }
        source.setContents(newContents);
    }

    public LinksDefSource getLinksDefSource(BeanTypeDef typeDef) {
        return this.getFirstTypeCustomizationSource(this.getTypeRelativeYamlPath(typeDef, "links.yaml"), LinksDefSource.class);
    }

    private <T extends YamlSource> T getFirstTypeCustomizationSource(String yamlPath, Class<T> type) {
        return this.getFirstSource(this.getTypeCustomizationYamlDirectoryReaders(), yamlPath, type);
    }

    private <T extends YamlSource> List<T> getTypeCustomizationSources(String yamlPath, Class<T> type) {
        return this.getSources(this.getTypeCustomizationYamlDirectoryReaders(), yamlPath, type);
    }

    private <T extends YamlSource> T getFirstSource(List<YamlDirectoryReader> readers, String yamlPath, Class<T> type) {
        for (YamlDirectoryReader reader : readers) {
            T source = reader.readYaml(yamlPath, type);
            if (source == null) continue;
            return source;
        }
        return null;
    }

    private <T extends YamlSource> List<T> getSources(List<YamlDirectoryReader> readers, String yamlPath, Class<T> type) {
        ArrayList<T> sources = new ArrayList<T>();
        for (YamlDirectoryReader reader : readers) {
            T source = reader.readYaml(yamlPath, type);
            if (source == null) continue;
            sources.add(source);
        }
        return sources;
    }

    private String getTypeRelativeYamlPath(PagePath pagePath, String relativePath) {
        return this.getTypeRelativeYamlPath(pagePath.getPagesPath(), relativePath);
    }

    private String getTypeRelativeYamlPath(PagesPath pagesPath, String relativePath) {
        return this.getTypeRelativeYamlPath(pagesPath.getTypeDef(), relativePath);
    }

    private String getTypeRelativeYamlPath(BeanTypeDef typeDef, String relativePath) {
        return this.getTypeRelativeYamlPath(typeDef.getTypeName(), relativePath);
    }

    private String getTypeRelativeYamlPath(String type, String relativePath) {
        return YamlReader.getYamlPath(type, relativePath);
    }

    public static String getYamlPath(String directory, String relativeYamlPath) {
        return StringUtils.notEmpty((String)directory) ? directory + "/" + relativeYamlPath : relativeYamlPath;
    }
}

