/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import weblogic.console.schema.beaninfo.BeanActionDefSource;
import weblogic.console.schema.beaninfo.BeanPropertyDefSource;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.schema.BeanActionDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanChildDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanPropertyDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanChildDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanActionDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanChildDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanPropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanRepoDefImpl;

abstract class YamlBasedBeanTypeDefImpl
extends BaseBeanTypeDefImpl {
    private static final Logger LOGGER = Logger.getLogger(YamlBasedBeanTypeDefImpl.class.getName());
    private String instanceName;
    private LocalizableString instanceNameLabel;
    private Map<String, BeanPropertyDefImpl> propertyNameToPropertyDefImplMap = new HashMap<String, BeanPropertyDefImpl>();
    private Map<String, BeanChildDefImpl> childNameToChildDefImplMap = new HashMap<String, BeanChildDefImpl>();
    private Map<String, BeanActionDefImpl> actionNameToActionDefImplMap = new HashMap<String, BeanActionDefImpl>();

    YamlBasedBeanTypeDefImpl(BeanRepoDefImpl beanRepoDefImpl, String typeName) {
        super(beanRepoDefImpl, StringUtils.getLeafClassName((String)typeName));
    }

    protected void initializeInstanceName(String instanceName) {
        this.instanceName = instanceName;
        if (StringUtils.isEmpty((String)this.getInstanceName())) {
            this.instanceName = StringUtils.getSimpleTypeName((String)this.getTypeName());
        }
        this.instanceNameLabel = new LocalizableString(this.getInstanceNameLabelKey(), StringUtils.camelCaseToUpperCaseWords((String)this.instanceName));
    }

    protected void initializeContainedDefsAndImpls() {
        this.removeUnsupportedPropertyDefImpls();
        this.initializeContainedDefsAndImpls(this.getPropertyNameToPropertyDefImplMap().values(), new ArrayList<BaseBeanChildDefImpl>(this.getChildNameToChildDefImplMap().values()), this.getActionNameToActionDefImplMap().values());
    }

    private void removeUnsupportedPropertyDefImpls() {
        ArrayList<String> unsupportedPropertyNames = new ArrayList<String>();
        for (Map.Entry<String, BeanPropertyDefImpl> e : this.propertyNameToPropertyDefImplMap.entrySet()) {
            Path parentPath = e.getValue().getParentPath();
            if (parentPath.isEmpty() || this.hasChildDef(parentPath)) continue;
            unsupportedPropertyNames.add(e.getKey());
        }
        for (String propertyName : unsupportedPropertyNames) {
            this.propertyNameToPropertyDefImplMap.remove(propertyName);
        }
    }

    protected BeanPropertyDefImpl createBeanPropertyDefImpl(Path parentPath, BeanPropertyDefSource source, BeanPropertyDefCustomizerSource customizerSource) {
        return new BeanPropertyDefImpl(this, parentPath, source, customizerSource);
    }

    protected BeanChildDefImpl createBeanChildDefImpl(Path parentPath, BeanPropertyDefSource source, BeanChildDefCustomizerSource customizerSource) {
        return new BeanChildDefImpl(this, parentPath, source, customizerSource);
    }

    protected BeanActionDefImpl createBeanActionDefImpl(Path parentPath, BeanActionDefSource source, BeanActionDefCustomizerSource customizerSource) {
        return new BeanActionDefImpl(this, parentPath, source, customizerSource);
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public LocalizableString getInstanceNameLabel() {
        return this.instanceNameLabel;
    }

    protected String pathKey(Path path) {
        return path.getDotSeparatedPath();
    }

    abstract boolean isType(String var1);

    abstract BeanTypeDefSource getTypeDefSource();

    @Override
    public boolean isTypeDef(BeanTypeDef otherTypeDef) {
        return this.isType(otherTypeDef.getTypeName());
    }

    @Override
    BeanPropertyDefImpl findPropertyDefImpl(Path propertyPath) {
        if (this.getPropertyNameToPropertyDefImplMap().containsKey(this.pathKey(propertyPath))) {
            return this.getPropertyNameToPropertyDefImplMap().get(this.pathKey(propertyPath));
        }
        return null;
    }

    protected void addPropertyDefImpl(BeanPropertyDefImpl propertyDefImpl) {
        Path propertyPath = propertyDefImpl.getPropertyPath();
        if (!this.hasPropertyDef(propertyPath)) {
            this.getPropertyNameToPropertyDefImplMap().put(this.pathKey(propertyPath), propertyDefImpl);
        }
    }

    protected Map<String, BeanPropertyDefImpl> getPropertyNameToPropertyDefImplMap() {
        return this.propertyNameToPropertyDefImplMap;
    }

    @Override
    BaseBeanChildDefImpl findChildDefImpl(Path childPath) {
        if (this.getChildNameToChildDefImplMap().containsKey(this.pathKey(childPath))) {
            return this.getChildNameToChildDefImplMap().get(this.pathKey(childPath));
        }
        return null;
    }

    protected void addChildDefImpl(BeanChildDefImpl childDef) {
        if (childDef == null) {
            return;
        }
        Path childPath = childDef.getChildPath();
        if (!this.hasChildDef(childPath)) {
            this.getChildNameToChildDefImplMap().put(this.pathKey(childPath), childDef);
        }
    }

    protected Map<String, BeanChildDefImpl> getChildNameToChildDefImplMap() {
        return this.childNameToChildDefImplMap;
    }

    @Override
    BeanActionDefImpl findActionDefImpl(Path actionPath) {
        if (this.getActionNameToActionDefImplMap().containsKey(this.pathKey(actionPath))) {
            return this.getActionNameToActionDefImplMap().get(this.pathKey(actionPath));
        }
        return null;
    }

    protected void addActionDefImpl(BeanActionDefImpl actionDefImpl) {
        if (actionDefImpl == null) {
            return;
        }
        Path actionPath = actionDefImpl.getActionPath();
        if (!this.hasActionDef(actionPath)) {
            this.getActionNameToActionDefImplMap().put(this.pathKey(actionPath), actionDefImpl);
        }
    }

    protected Map<String, BeanActionDefImpl> getActionNameToActionDefImplMap() {
        return this.actionNameToActionDefImplMap;
    }

    protected Error configurationError(String problem) {
        String msg = "Configuration Error: type " + this.getTypeName() + " : " + problem;
        LOGGER.severe(msg);
        return new AssertionError((Object)msg);
    }
}

