/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.DoubleValue;
import weblogic.remoteconsole.server.repo.IntValue;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;

public class ValueUtils {
    private ValueUtils() {
    }

    public static List<Value> createValues(List<Object> objects) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (Object object : objects) {
            values.add(ValueUtils.createValue(object));
        }
        return values;
    }

    public static Value createValue(Object object) {
        if (object == null) {
            return new StringValue(null);
        }
        if (object instanceof String) {
            return new StringValue((String)String.class.cast(object));
        }
        if (object instanceof Boolean) {
            return new BooleanValue((Boolean)Boolean.class.cast(object));
        }
        if (object instanceof Integer) {
            return new IntValue((Integer)Integer.class.cast(object));
        }
        if (object instanceof Long) {
            return new LongValue((Long)Long.class.cast(object));
        }
        if (object instanceof Double) {
            return new DoubleValue((Double)Double.class.cast(object));
        }
        if (object instanceof ArrayList) {
            ArrayList<Value> values = new ArrayList<Value>();
            for (Object obj : (ArrayList)ArrayList.class.cast(object)) {
                values.add(ValueUtils.createValue(obj));
            }
            return new ArrayValue(values);
        }
        if (object instanceof Map && ((Map)object).isEmpty()) {
            return null;
        }
        throw new AssertionError((Object)("Unsupported type: " + String.valueOf(object.getClass()) + " " + String.valueOf(object)));
    }

    public static String getValueAsString(Value value) {
        if (value.isString()) {
            return value.asString().getValue();
        }
        if (value.isInt()) {
            return "" + value.asInt().getValue();
        }
        if (value.isLong()) {
            return "" + value.asLong().getValue();
        }
        throw new AssertionError((Object)("Unsupport legal value: " + String.valueOf(value)));
    }
}

