/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.UsedIfDef;
import weblogic.remoteconsole.common.repodef.schema.UsedIfDefSource;
import weblogic.remoteconsole.common.repodef.yaml.PageDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.ValueUtils;
import weblogic.remoteconsole.server.repo.Value;

class UsedIfDefImpl
implements UsedIfDef {
    private UsedIfDefSource source;
    private PagePropertyDefImpl propertyDefImpl;
    private List<Value> values;

    UsedIfDefImpl(PageDefImpl pageDefImpl, UsedIfDefSource source) {
        this.source = source;
        this.initializePropertyDefImpl(pageDefImpl);
        this.values = ValueUtils.createValues(source.getValues());
    }

    private void initializePropertyDefImpl(PageDefImpl pageDefImpl) {
        Path containedBeanRelativePropertyPath = new Path(this.source.getProperty());
        Path propertyPath = this.source.getPropertyContainedBeanPath().childPath(containedBeanRelativePropertyPath);
        String want = propertyPath.getDotSeparatedPath();
        for (PagePropertyDefImpl candidatePropertyDefImpl : pageDefImpl.getAllPropertyDefImpls()) {
            if (!want.equals(candidatePropertyDefImpl.getPropertyPath().getDotSeparatedPath())) continue;
            this.propertyDefImpl = candidatePropertyDefImpl;
            return;
        }
        throw new AssertionError((Object)("Can't find property " + want + " for usedIf on " + String.valueOf(pageDefImpl)));
    }

    PagePropertyDefImpl getPropertyDefImpl() {
        return this.propertyDefImpl;
    }

    @Override
    public PagePropertyDef getPropertyDef() {
        return this.getPropertyDefImpl();
    }

    @Override
    public List<Value> getValues() {
        return this.values;
    }
}

