/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.Set;
import java.util.TreeSet;

public class UsageTracker {
    private static boolean trackUsage = false;
    private static Set<String> used = new TreeSet<String>();
    private static Set<String> notFound = new TreeSet<String>();

    public static void trackUsage() {
        trackUsage = true;
    }

    public static void reportMissing() {
        if (!trackUsage) {
            return;
        }
        boolean foundMissing = false;
        for (String id : notFound) {
            if (used.contains(id)) continue;
            System.err.println("Missing " + id);
            foundMissing = true;
        }
        if (foundMissing) {
            throw new RuntimeException("Yamls refer to missing items. See the list above. Either fix the problems or add them to UsageTracker.java if they're expected.");
        }
    }

    public static void used(String usageId) {
        if (trackUsage) {
            used.add(usageId);
        }
    }

    public static void notFound(String usageId) {
        if (trackUsage) {
            notFound.add(usageId);
        }
    }

    static {
        used.add("slice AggregatedJMSServerRuntimeMBean Transactions");
        used.add("slice AggregatedJTARuntimeMBean Transactions");
        used.add("slice AggregatedDomainKeystoresServerRuntimeMBean MachineIdentityKeystore");
        used.add("slice AggregatedDomainKeystoresServerRuntimeMBean MachineTrustKeystore");
        used.add("slice AggregatedDomainKeystoresServerRuntimeMBean ServerIdentityKeystore");
        used.add("slice AggregatedDomainKeystoresServerRuntimeMBean ServerTrustKeystore");
        used.add("property AggregatedComponentRuntimeMBean ContextRootURL");
        used.add("property MessageDrivenDescriptorDBean EjbClass");
        used.add("action DelegatedServerRuntimeServerRuntimeMBean publishSingleSignOnServices");
        used.add("property IPlanetAuthenticatorMBean UserDescriptionAttribute");
        used.add("property NovellAuthenticatorMBean UserDescriptionAttribute");
        used.add("property OracleVirtualDirectoryAuthenticatorMBean UserDescriptionAttribute");
    }
}

