/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanTypeCustomizerDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanChildDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanPropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.CollectionParamDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.CustomizerDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.InvocationContextParamDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.ParamDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PropertyParamDefImpl;
import weblogic.remoteconsole.common.utils.CustomizerSourceUtils;
import weblogic.remoteconsole.customizers.Source;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.Value;

abstract class SourceAnnotatedCustomizerDefImpl
extends CustomizerDefImpl
implements BeanTypeCustomizerDef {
    private BaseBeanTypeDefImpl typeDefImpl;
    private Path containedBeanPath;
    private static final Type INVOCATION_CONTEXT_TYPE = InvocationContext.class;
    private static final Type SETTABLE_PROPERTY_ARGUMENT_TYPE = SettableValue.class;
    private static final Type NONSETTABLE_PROPERTY_ARGUMENT_TYPE = Value.class;
    private static final Type SETTABLE_COLLECTION_ARGUMENT_TYPE = new TypeReference<List<Map<String, SettableValue>>>(){}.getType();
    private static final Type NONSETTABLE_COLLECTION_ARGUMENT_TYPE = new TypeReference<List<Map<String, Value>>>(){}.getType();

    SourceAnnotatedCustomizerDefImpl(BaseBeanTypeDefImpl typeDefImpl, Path containedBeanPath, String methodName) {
        super(methodName);
        this.typeDefImpl = typeDefImpl;
        this.containedBeanPath = containedBeanPath;
    }

    BaseBeanTypeDefImpl getTypeDefImpl() {
        return this.typeDefImpl;
    }

    @Override
    public BeanTypeDef getTypeDef() {
        return this.getTypeDefImpl();
    }

    protected abstract boolean isSettableParams();

    @Override
    protected List<ParamDefImpl> createParamDefImpls() {
        ArrayList<ParamDefImpl> argumentDefImpls = new ArrayList<ParamDefImpl>();
        for (CustomizerSourceUtils.Parameter parameter : CustomizerSourceUtils.getParameters(this.getMethod())) {
            ParamDefImpl argumentDefImpl = this.createParamDefImpl(parameter);
            if (argumentDefImpl == null) {
                throw new AssertionError((Object)(this.getMethodName() + " " + String.valueOf(parameter) + ": unsupported argument"));
            }
            argumentDefImpls.add(argumentDefImpl);
        }
        return argumentDefImpls;
    }

    protected ParamDefImpl createParamDefImpl(CustomizerSourceUtils.Parameter parameter) {
        Source source = parameter.getSource();
        if (source == null) {
            return this.createBuiltinParamDefImpl(parameter);
        }
        return this.createSourceParamDefImpl(parameter);
    }

    protected ParamDefImpl createBuiltinParamDefImpl(CustomizerSourceUtils.Parameter parameter) {
        if (INVOCATION_CONTEXT_TYPE.equals(parameter.getType())) {
            return new InvocationContextParamDefImpl(this);
        }
        return null;
    }

    protected ParamDefImpl createSourceParamDefImpl(CustomizerSourceUtils.Parameter parameter) {
        if (StringUtils.notEmpty((String)parameter.getSource().collection())) {
            return this.createCollectionParamDefImpl(parameter);
        }
        return this.createPropertyParamDefImpl(parameter);
    }

    private CollectionParamDefImpl createCollectionParamDefImpl(CustomizerSourceUtils.Parameter parameter) {
        Type expectedType = this.isSettableParams() ? SETTABLE_COLLECTION_ARGUMENT_TYPE : NONSETTABLE_COLLECTION_ARGUMENT_TYPE;
        this.verifyParamType(expectedType, parameter);
        BaseBeanChildDefImpl collectionDefImpl = this.getCollectionDefImpl(parameter);
        return new CollectionParamDefImpl(this, this.findCollectionPath(parameter), collectionDefImpl, this.findCollectionPropertyDefImpls(parameter, collectionDefImpl.getChildTypeDefImpl()));
    }

    private List<BeanPropertyDefImpl> findCollectionPropertyDefImpls(CustomizerSourceUtils.Parameter parameter, BaseBeanTypeDefImpl typeDefImpl) {
        ArrayList<BeanPropertyDefImpl> propertyDefImpls = new ArrayList<BeanPropertyDefImpl>();
        for (String property : parameter.getSource().properties()) {
            propertyDefImpls.add(this.findPropertyDefImpl(parameter, typeDefImpl, new Path(), property));
        }
        return propertyDefImpls;
    }

    private boolean isRelativeCollectionPath(CustomizerSourceUtils.Parameter parameter) {
        return !parameter.getSource().collection().startsWith("/");
    }

    private Path findCollectionPath(CustomizerSourceUtils.Parameter parameter) {
        if (this.isRelativeCollectionPath(parameter)) {
            return new Path();
        }
        return this.getCollectionPath(parameter);
    }

    private Path getCollectionPath(CustomizerSourceUtils.Parameter parameter) {
        return new Path(parameter.getSource().collection().replaceAll("/", "."));
    }

    private BaseBeanChildDefImpl getCollectionDefImpl(CustomizerSourceUtils.Parameter parameter) {
        boolean searchSubTypes = true;
        BaseBeanChildDefImpl childDefImpl = null;
        if (this.isRelativeCollectionPath(parameter)) {
            Path collectionPath = this.containedBeanPath.childPath(this.getCollectionPath(parameter));
            childDefImpl = this.findChildDefImpl(parameter, this.getTypeDefImpl(), collectionPath);
        } else {
            BaseBeanTypeDefImpl typeDefImpl = this.getTypeDefImpl().getBeanRepoDefImpl().getRootTypeDefImpl();
            for (String childName : this.getCollectionPath(parameter).getComponents()) {
                childDefImpl = this.findChildDefImpl(parameter, typeDefImpl, new Path(childName));
                typeDefImpl = childDefImpl.getChildTypeDefImpl();
            }
        }
        if (!childDefImpl.isCollection()) {
            throw new AssertionError((Object)(this.getMethodName() + " " + String.valueOf(parameter) + " " + String.valueOf(childDefImpl) + " is not a collection"));
        }
        return childDefImpl;
    }

    private BaseBeanChildDefImpl findChildDefImpl(CustomizerSourceUtils.Parameter parameter, BaseBeanTypeDefImpl typeDefImpl, Path childPath) {
        boolean searchSubTypes = true;
        if (!typeDefImpl.hasChildDef(childPath, searchSubTypes)) {
            throw new AssertionError((Object)(this.getMethodName() + " " + String.valueOf(parameter) + " " + String.valueOf(typeDefImpl) + " cannot find " + String.valueOf(childPath)));
        }
        return typeDefImpl.getChildDefImpl(childPath, searchSubTypes);
    }

    private PropertyParamDefImpl createPropertyParamDefImpl(CustomizerSourceUtils.Parameter parameter) {
        Type expectedType = this.isSettableParams() ? SETTABLE_PROPERTY_ARGUMENT_TYPE : NONSETTABLE_PROPERTY_ARGUMENT_TYPE;
        this.verifyParamType(expectedType, parameter);
        Source source = parameter.getSource();
        if (source.properties() != null && source.properties().length > 0) {
            throw new AssertionError((Object)(this.getMethodName() + " " + String.valueOf(parameter) + " must not specify properties since it does not specify collection"));
        }
        if (StringUtils.isEmpty((String)source.property())) {
            throw new AssertionError((Object)(this.getMethodName() + " " + String.valueOf(parameter) + " must specify property"));
        }
        BeanPropertyDefImpl argumentPropertyDefImpl = this.findPropertyDefImpl(parameter, this.getTypeDefImpl(), this.containedBeanPath, source.property());
        return new PropertyParamDefImpl(this, argumentPropertyDefImpl);
    }

    private BeanPropertyDefImpl findPropertyDefImpl(CustomizerSourceUtils.Parameter parameter, BaseBeanTypeDefImpl typeDefImpl, Path pathPrefix, String property) {
        boolean searchSubTypes;
        Path propertyPath = pathPrefix.childPath(new Path(property));
        if (!typeDefImpl.hasPropertyDef(propertyPath, searchSubTypes = true)) {
            throw new AssertionError((Object)(this.getMethodName() + " " + String.valueOf(parameter) + " can't find " + property));
        }
        return typeDefImpl.getPropertyDefImpl(propertyPath, searchSubTypes);
    }

    private void verifyParamType(Type typeWant, CustomizerSourceUtils.Parameter parameter) {
        if (!typeWant.equals(parameter.getType())) {
            throw new AssertionError((Object)(this.getMethodName() + " " + String.valueOf(parameter) + " must return a " + String.valueOf(typeWant)));
        }
    }
}

