/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.PageRepoDef;
import weblogic.remoteconsole.common.repodef.SliceDef;
import weblogic.remoteconsole.common.repodef.SlicesDef;
import weblogic.remoteconsole.common.repodef.schema.SliceDefSource;
import weblogic.remoteconsole.common.repodef.schema.SlicesDefSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanRepoDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageRepoDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.SliceDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.UsageTracker;

public class SlicesDefImpl
implements SlicesDef {
    private PageRepoDefImpl pageRepoDefImpl;
    private BaseBeanTypeDefImpl typeDefImpl;
    private SlicesDefSource source;
    private List<SliceDefImpl> contentDefImpls = new ArrayList<SliceDefImpl>();
    private List<SliceDef> contentDefs;

    SlicesDefImpl(PageRepoDefImpl pageRepoDefImpl, SlicesDefSource source, BaseBeanTypeDefImpl typeDefImpl) {
        this.pageRepoDefImpl = pageRepoDefImpl;
        this.source = source;
        this.typeDefImpl = typeDefImpl;
        for (SliceDefSource sliceDefSource : this.getSource().getSlices()) {
            if (!this.getBeanRepoDefImpl().supportsCapabilities(sliceDefSource.getRequiredCapabilities())) continue;
            String usageId = "slice " + typeDefImpl.getTypeName() + " " + sliceDefSource.getName();
            SliceDefImpl sliceDefImpl = SliceDefImpl.createSliceDefImpl(this, sliceDefSource, null);
            if (sliceDefImpl != null) {
                UsageTracker.used(usageId);
                this.getContentDefImpls().add(sliceDefImpl);
                continue;
            }
            UsageTracker.notFound(usageId);
        }
        this.contentDefs = Collections.unmodifiableList(this.getContentDefImpls());
    }

    PageRepoDefImpl getPageRepoDefImpl() {
        return this.pageRepoDefImpl;
    }

    BeanRepoDefImpl getBeanRepoDefImpl() {
        return this.getPageRepoDefImpl().getBeanRepoDefImpl();
    }

    @Override
    public PageRepoDef getPageRepoDef() {
        return this.getPageRepoDefImpl();
    }

    private SlicesDefSource getSource() {
        return this.source;
    }

    BaseBeanTypeDefImpl getTypeDefImpl() {
        return this.typeDefImpl;
    }

    @Override
    public BeanTypeDef getTypeDef() {
        return this.getTypeDefImpl();
    }

    List<SliceDefImpl> getContentDefImpls() {
        return this.contentDefImpls;
    }

    @Override
    public List<SliceDef> getContentDefs() {
        return this.contentDefs;
    }

    List<String> getAlternateSliceSources() {
        return this.getSource().getAlternateSliceSources();
    }
}

