/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.Collections;
import java.util.List;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.SliceDef;
import weblogic.remoteconsole.common.repodef.SliceTableDef;
import weblogic.remoteconsole.common.repodef.schema.SliceTableDefSource;
import weblogic.remoteconsole.common.repodef.yaml.PageDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageRepoDefImpl;

public class SliceTableDefImpl
extends PageDefImpl
implements SliceTableDef {
    private List<PagePropertyDefImpl> displayedColumnDefImpls;
    private List<PagePropertyDef> displayedColumnDefs;
    private List<PagePropertyDefImpl> hiddenColumnDefImpls;
    private List<PagePropertyDef> hiddenColumnDefs;
    private String getTableRowsMethod;
    private boolean supportsNavigation;

    public SliceTableDefImpl(PageRepoDefImpl pageRepoDefImpl, PagePath pagePath, SliceTableDefSource source) {
        super(pageRepoDefImpl, pagePath, source, "slice." + pagePath.asSlicePagePath().getSlicePath().getDotSeparatedPath());
        this.displayedColumnDefImpls = this.createPropertyDefImpls(source.getDisplayedColumns());
        this.hiddenColumnDefImpls = this.createPropertyDefImpls(source.getHiddenColumns());
        this.displayedColumnDefs = Collections.unmodifiableList(this.getDisplayedColumnDefImpls());
        this.hiddenColumnDefs = Collections.unmodifiableList(this.getHiddenColumnDefImpls());
        this.getTableRowsMethod = source.getGetTableRowsMethod();
        this.supportsNavigation = source.isSupportsNavigation();
        this.finishPropertyBasedInitialization();
    }

    @Override
    protected void createUsedIfDefImpls() {
    }

    List<PagePropertyDefImpl> getDisplayedColumnDefImpls() {
        return this.displayedColumnDefImpls;
    }

    @Override
    public List<PagePropertyDef> getDisplayedColumnDefs() {
        return this.displayedColumnDefs;
    }

    List<PagePropertyDefImpl> getHiddenColumnDefImpls() {
        return this.hiddenColumnDefImpls;
    }

    @Override
    public List<PagePropertyDef> getHiddenColumnDefs() {
        return this.hiddenColumnDefs;
    }

    @Override
    protected String getEnglishHelpPageTitle(String typeInstanceName) {
        StringBuilder sb = new StringBuilder();
        sb.append(typeInstanceName);
        List<SliceDef> sliceDefs = this.getPagePath().getPagesPath().getPageRepoDef().getSlicesDef(this.getTypeDefImpl()).getContentDefs();
        if (sliceDefs.size() != 1 || !sliceDefs.get(0).getContentDefs().isEmpty()) {
            for (String sliceName : this.getPagePath().asSlicePagePath().getSlicePath().getComponents()) {
                SliceDef sliceDef = this.getSliceDef(sliceDefs, sliceName);
                sb.append(": ");
                sb.append(sliceDef.getLabel().getEnglishText(new Object[0]));
                sliceDefs = sliceDef.getContentDefs();
            }
        }
        return sb.toString();
    }

    private SliceDef getSliceDef(List<SliceDef> sliceDefs, String sliceName) {
        for (SliceDef sliceDef : sliceDefs) {
            if (!sliceDef.getName().equals(sliceName)) continue;
            return sliceDef;
        }
        throw new AssertionError((Object)("Can't find slice " + sliceName + " " + String.valueOf(this)));
    }

    @Override
    public String getGetTableRowsMethod() {
        return this.getTableRowsMethod;
    }

    @Override
    public boolean isSupportsNavigation() {
        return this.supportsNavigation;
    }

    @Override
    public boolean isUseRowIdentities() {
        return false;
    }
}

