/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.Collections;
import java.util.List;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.SliceDef;
import weblogic.remoteconsole.common.repodef.SliceFormDef;
import weblogic.remoteconsole.common.repodef.SliceFormPresentationDef;
import weblogic.remoteconsole.common.repodef.schema.SliceFormDefSource;
import weblogic.remoteconsole.common.repodef.yaml.FormDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageRepoDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.SliceFormPresentationDefImpl;

public class SliceFormDefImpl
extends FormDefImpl
implements SliceFormDef {
    private List<PagePropertyDefImpl> advancedPropertyDefImpls;
    private List<PagePropertyDef> advancedPropertyDefs;
    private SliceFormPresentationDefImpl presentationDefImpl;

    public SliceFormDefImpl(PageRepoDefImpl pageRepoDefImpl, PagePath pagePath, SliceFormDefSource source) {
        super(pageRepoDefImpl, pagePath, source, "slice." + pagePath.asSlicePagePath().getSlicePath().getDotSeparatedPath());
        this.advancedPropertyDefImpls = this.createPropertyDefImpls(source.getAdvancedProperties());
        this.advancedPropertyDefs = Collections.unmodifiableList(this.getAdvancedPropertyDefImpls());
        this.presentationDefImpl = new SliceFormPresentationDefImpl(this, source.getPresentation());
        this.finishPropertyBasedInitialization();
    }

    List<PagePropertyDefImpl> getAdvancedPropertyDefImpls() {
        return this.advancedPropertyDefImpls;
    }

    @Override
    public List<PagePropertyDef> getAdvancedPropertyDefs() {
        return this.advancedPropertyDefs;
    }

    SliceFormPresentationDefImpl getPresentationDefImpl() {
        return this.presentationDefImpl;
    }

    @Override
    public SliceFormPresentationDef getPresentationDef() {
        return this.getPresentationDefImpl();
    }

    @Override
    protected String getEnglishHelpPageTitle(String typeInstanceName) {
        StringBuilder sb = new StringBuilder();
        sb.append(typeInstanceName);
        List<SliceDef> sliceDefs = this.getPagePath().getPagesPath().getPageRepoDef().getSlicesDef(this.getTypeDefImpl()).getContentDefs();
        if (sliceDefs.size() != 1 || !sliceDefs.get(0).getContentDefs().isEmpty()) {
            for (String sliceName : this.getPagePath().asSlicePagePath().getSlicePath().getComponents()) {
                SliceDef sliceDef = this.getSliceDef(sliceDefs, sliceName);
                sb.append(": ");
                sb.append(sliceDef.getLabel().getEnglishText(new Object[0]));
                sliceDefs = sliceDef.getContentDefs();
            }
        }
        return sb.toString();
    }

    private SliceDef getSliceDef(List<SliceDef> sliceDefs, String sliceName) {
        for (SliceDef sliceDef : sliceDefs) {
            if (!sliceDef.getName().equals(sliceName)) continue;
            return sliceDef;
        }
        throw new AssertionError((Object)("Can't find slice " + sliceName + " " + String.valueOf(this)));
    }
}

