/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.SliceDef;
import weblogic.remoteconsole.common.repodef.SlicePagePath;
import weblogic.remoteconsole.common.repodef.SlicesDef;
import weblogic.remoteconsole.common.repodef.schema.SliceDefSource;
import weblogic.remoteconsole.common.repodef.yaml.PageRepoDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.SlicesDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.YamlReader;

class SliceDefImpl
implements SliceDef {
    private SlicesDefImpl slicesDefImpl;
    private SliceDefSource source;
    private SliceDefImpl sliceDefImpl;
    private LocalizableString label;
    private Path slice = new Path();
    private List<SliceDef> contentDefs = new ArrayList<SliceDef>();

    static SliceDefImpl createSliceDefImpl(SlicesDefImpl slicesDefImpl, SliceDefSource source, SliceDefImpl sliceDefImpl) {
        SliceDefImpl newSliceDefImpl = new SliceDefImpl(slicesDefImpl, source, sliceDefImpl);
        if (newSliceDefImpl.getSource().getSlices().isEmpty()) {
            PageRepoDefImpl pageRepo = slicesDefImpl.getPageRepoDefImpl();
            SlicePagePath pagePath = pageRepo.newSlicePagePath(slicesDefImpl.getTypeDef(), newSliceDefImpl.getSlice());
            YamlReader reader = pageRepo.getYamlReader();
            if (reader.getSliceFormDefSource(pagePath, slicesDefImpl) == null && reader.getSliceTableDefSource(pagePath, slicesDefImpl) == null) {
                return null;
            }
        } else if (newSliceDefImpl.getContentDefs().isEmpty()) {
            return null;
        }
        return newSliceDefImpl;
    }

    private SliceDefImpl(SlicesDefImpl slicesDefImpl, SliceDefSource source, SliceDefImpl sliceDefImpl) {
        this.slicesDefImpl = slicesDefImpl;
        this.source = source;
        this.sliceDefImpl = sliceDefImpl;
        if (sliceDefImpl != null) {
            this.slice = sliceDefImpl.getSlice();
        }
        this.slice = this.slice.childPath(source.getName());
        String englishLabel = this.getSource().getLabel();
        if (StringUtils.isEmpty((String)englishLabel)) {
            englishLabel = StringUtils.camelCaseToUpperCaseWords((String)this.getName());
        }
        this.label = new LocalizableString(this.getLocalizationKey("label"), englishLabel);
        for (SliceDefSource sliceDefSource : this.getSource().getSlices()) {
            SliceDefImpl newSliceDefImpl;
            if (!slicesDefImpl.getBeanRepoDefImpl().supportsCapabilities(sliceDefSource.getRequiredCapabilities()) || (newSliceDefImpl = SliceDefImpl.createSliceDefImpl(this.getSlicesDefImpl(), sliceDefSource, this)) == null) continue;
            this.getContentDefs().add(newSliceDefImpl);
        }
    }

    private SlicesDefImpl getSlicesDefImpl() {
        return this.slicesDefImpl;
    }

    @Override
    public SlicesDef getSlicesDef() {
        return this.getSlicesDefImpl();
    }

    private SliceDefSource getSource() {
        return this.source;
    }

    private SliceDefImpl getSliceDefImpl() {
        return this.sliceDefImpl;
    }

    private Path getSlice() {
        return this.slice;
    }

    @Override
    public SliceDef getSliceDef() {
        return this.getSliceDefImpl();
    }

    @Override
    public LocalizableString getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.getSource().getName();
    }

    @Override
    public List<SliceDef> getContentDefs() {
        return this.contentDefs;
    }

    private String getLocalizationKey(String key) {
        return "slices." + this.getName() + "." + key;
    }

    public String toString() {
        return "slice<" + String.valueOf(this.slice) + ">";
    }
}

