/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import weblogic.console.schema.beaninfo.BeanActionDefSource;
import weblogic.console.schema.beaninfo.BeanPropertyDefSource;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.schema.beaninfo.RolesDefSource;
import weblogic.remoteconsole.common.repodef.schema.NavTreeNodeDefSource;
import weblogic.remoteconsole.common.utils.WebLogicRoles;

class RoleUtils {
    private RoleUtils() {
    }

    static Set<String> computeGetRoles(BeanTypeDefSource typeSource, BeanPropertyDefSource propertySource) {
        Set<String> roles = RoleUtils.computeRoles(propertySource.getGetRoles());
        if (roles == null) {
            roles = propertySource.isEncrypted() || propertySource.isSensitive() ? WebLogicRoles.ADMIN_ROLES : WebLogicRoles.ALL;
        }
        return roles;
    }

    static Set<String> computeNavTreeNodeRoles(NavTreeNodeDefSource nodeSource) {
        Set<String> roles = RoleUtils.computeRoles(nodeSource.getRoles());
        if (roles == null) {
            roles = WebLogicRoles.ALL;
        }
        return roles;
    }

    static Set<String> computeSetRoles(BeanTypeDefSource typeSource, BeanPropertyDefSource propertySource) {
        Set<String> roles = RoleUtils.computeRoles(propertySource.getSetRoles());
        if (roles == null) {
            roles = RoleUtils.computeRoles(typeSource.getRoles());
        }
        if (roles == null) {
            roles = WebLogicRoles.ADMIN_ROLES;
        }
        return roles;
    }

    static Set<String> computeCreateRoles(BeanTypeDefSource typeSource, BeanPropertyDefSource propertySource) {
        Set<String> roles = RoleUtils.computeRoles(typeSource.getRoles());
        if (roles == null) {
            roles = WebLogicRoles.ADMIN_ROLES;
        }
        return roles;
    }

    static Set<String> computeDeleteRoles(BeanTypeDefSource typeSource, BeanPropertyDefSource propertySource) {
        return RoleUtils.computeCreateRoles(typeSource, propertySource);
    }

    static Set<String> computeInvokeRoles(BeanTypeDefSource typeSource, BeanActionDefSource actionSource) {
        Set<String> roles = RoleUtils.computeRoles(actionSource.getRoles());
        if (roles == null) {
            roles = RoleUtils.computeRoles(typeSource.getRoles());
        }
        if (roles == null) {
            roles = WebLogicRoles.ADMIN_ROLES;
        }
        return roles;
    }

    private static Set<String> computeRoles(RolesDefSource rolesSource) {
        if (rolesSource != null) {
            List allowed = rolesSource.getAllowed();
            if (!allowed.isEmpty()) {
                HashSet<String> roles = new HashSet<String>(allowed);
                roles.add("Admin");
                return roles;
            }
            if (rolesSource.isPermitAll()) {
                return WebLogicRoles.ALL;
            }
        }
        return null;
    }
}

