/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.DeleteBeanCustomizerDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.schema.PseudoBeanTypeDefSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanChildDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanActionDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanChildDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanPropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanRepoDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.YamlBasedBeanTypeDefImpl;

public class PseudoBeanTypeDefImpl
extends YamlBasedBeanTypeDefImpl {
    private PseudoBeanTypeDefSource source;
    private YamlBasedBeanTypeDefImpl baseTypeDefImpl;
    private List<BaseBeanTypeDefImpl> inheritedTypeDefImpls = new ArrayList<BaseBeanTypeDefImpl>();

    public PseudoBeanTypeDefImpl(BeanRepoDefImpl beanRepoDefImpl, PseudoBeanTypeDefSource source) {
        super(beanRepoDefImpl, source.getName());
        this.initializeInstanceName(null);
        this.source = source;
        this.baseTypeDefImpl = this.getBeanRepoDefImpl().getTypeDefImpl(StringUtils.getLeafClassName((String)this.getSource().getBaseType())).asYamlBasedBeanTypeDefImpl();
        if (this.getBaseTypeDefImpl() == null) {
            throw new AssertionError((Object)("Can't find base type " + this.getSource().getBaseType() + " for " + this.getTypeName()));
        }
        this.inheritedTypeDefImpls.add(this.baseTypeDefImpl);
        this.copyPropertyDefImpls();
        this.copyChildDefImpls();
        this.copyActionDefImpls();
        this.initializeContainedDefsAndImpls();
    }

    private void copyPropertyDefImpls() {
        HashSet<String> include = new HashSet<String>();
        HashSet<String> exclude = new HashSet<String>();
        include.addAll(this.getSource().getInclude());
        exclude.addAll(this.getSource().getExclude());
        if (!include.isEmpty() && !exclude.isEmpty()) {
            throw new AssertionError((Object)("Both include and exclude are specified for " + this.getTypeName()));
        }
        for (BeanPropertyDefImpl propertyDefImpl : this.getBaseTypeDefImpl().getPropertyNameToPropertyDefImplMap().values()) {
            String propertyName = propertyDefImpl.getPropertyPath().getDotSeparatedPath();
            boolean copy = false;
            if (!include.isEmpty()) {
                if (include.contains(propertyName)) {
                    copy = true;
                }
            } else if (!exclude.isEmpty()) {
                if (!exclude.contains(propertyName)) {
                    copy = true;
                }
            } else {
                copy = true;
            }
            if (!copy) continue;
            this.addPropertyDefImpl(this.createBeanPropertyDefImpl(propertyDefImpl.getParentPath(), propertyDefImpl.getSource(), propertyDefImpl.getCustomizerSource()));
        }
    }

    private void copyChildDefImpls() {
        for (BaseBeanChildDefImpl baseBeanChildDefImpl : this.getBaseTypeDefImpl().getChildNameToChildDefImplMap().values()) {
            BeanChildDefImpl childDefImpl = baseBeanChildDefImpl.asBeanChildDefImpl();
            this.addChildDefImpl(this.createBeanChildDefImpl(childDefImpl.getParentPath(), childDefImpl.getSource(), childDefImpl.getCustomizerSource()));
        }
    }

    private void copyActionDefImpls() {
        for (BeanActionDefImpl actionDefImpl : this.getBaseTypeDefImpl().getActionNameToActionDefImplMap().values()) {
            this.addActionDefImpl(this.createBeanActionDefImpl(actionDefImpl.getParentPath(), actionDefImpl.getSource(), actionDefImpl.getCustomizerSource()));
        }
    }

    @Override
    LocalizableString getDescriptionHTML() {
        return this.getBaseTypeDefImpl().getDescriptionHTML();
    }

    private PseudoBeanTypeDefSource getSource() {
        return this.source;
    }

    private YamlBasedBeanTypeDefImpl getBaseTypeDefImpl() {
        return this.baseTypeDefImpl;
    }

    @Override
    List<BaseBeanTypeDefImpl> getInheritedTypeDefImpls() {
        return this.inheritedTypeDefImpls;
    }

    @Override
    boolean isType(String desiredTypeName) {
        if (this.getTypeName().equals(desiredTypeName)) {
            return true;
        }
        return this.getBaseTypeDefImpl().isType(desiredTypeName);
    }

    @Override
    public boolean isReferenceable() {
        return this.getBaseTypeDefImpl().isReferenceable();
    }

    @Override
    public boolean isOrdered() {
        return this.getBaseTypeDefImpl().isOrdered();
    }

    @Override
    public boolean isAllowSearch() {
        return this.getBaseTypeDefImpl().isAllowSearch();
    }

    @Override
    BeanPropertyDefImpl getKeyPropertyDefImpl() {
        return this.getBaseTypeDefImpl().getKeyPropertyDefImpl();
    }

    @Override
    BeanPropertyDefImpl getIdentityPropertyDefImpl() {
        return this.getBaseTypeDefImpl().getIdentityPropertyDefImpl();
    }

    @Override
    public boolean isHomogeneous() {
        return this.getBaseTypeDefImpl().isHomogeneous();
    }

    @Override
    BeanPropertyDefImpl getSubTypeDiscriminatorPropertyDefImpl() {
        return this.getBaseTypeDefImpl().getSubTypeDiscriminatorPropertyDefImpl();
    }

    @Override
    public List<String> getSubTypeDiscriminatorLegalValues() {
        return this.getBaseTypeDefImpl().getSubTypeDiscriminatorLegalValues();
    }

    @Override
    BaseBeanTypeDefImpl getDefaultSubTypeDefImpl() {
        return this.getBaseTypeDefImpl().getDefaultSubTypeDefImpl();
    }

    @Override
    BaseBeanTypeDefImpl getSubTypeDefImpl(String subTypeDiscriminator) {
        return this.getBaseTypeDefImpl().getSubTypeDefImpl(subTypeDiscriminator);
    }

    @Override
    public boolean isSettable() {
        return this.getBaseTypeDefImpl().isSettable();
    }

    @Override
    public DeleteBeanCustomizerDef getDeleteCustomizerDef() {
        return this.getBaseTypeDefImpl().getDeleteCustomizerDef();
    }

    @Override
    public String getCreateResourceMethod() {
        return this.getBaseTypeDefImpl().getCreateResourceMethod();
    }

    @Override
    public String getGetCollectionMethod() {
        return this.getBaseTypeDefImpl().getGetCollectionMethod();
    }

    @Override
    boolean isDisableMBeanJavadoc() {
        return this.getBaseTypeDefImpl().isDisableMBeanJavadoc();
    }

    @Override
    BeanTypeDefSource getTypeDefSource() {
        return this.baseTypeDefImpl.getTypeDefSource();
    }

    @Override
    boolean isEditable() {
        return this.baseTypeDefImpl.isEditable();
    }
}

