/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.ActionInputFormPagePath;
import weblogic.remoteconsole.common.repodef.BeanRepoDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CreateFormPagePath;
import weblogic.remoteconsole.common.repodef.LinksDef;
import weblogic.remoteconsole.common.repodef.NavTreeDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PageRepoDef;
import weblogic.remoteconsole.common.repodef.PagesPath;
import weblogic.remoteconsole.common.repodef.SliceDef;
import weblogic.remoteconsole.common.repodef.SlicePagePath;
import weblogic.remoteconsole.common.repodef.SlicesDef;
import weblogic.remoteconsole.common.repodef.TablePagePath;
import weblogic.remoteconsole.common.repodef.schema.CreateFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.NavTreeDefSource;
import weblogic.remoteconsole.common.repodef.schema.PageDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceTableDefSource;
import weblogic.remoteconsole.common.repodef.schema.SlicesDefSource;
import weblogic.remoteconsole.common.repodef.schema.TableDefSource;
import weblogic.remoteconsole.common.repodef.yaml.ActionInputFormDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanRepoDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.CreateFormDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.LinksDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.NavTreeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageActionDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.SliceFormDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.SliceTableDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.SlicesDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.TableDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.YamlReader;

public abstract class PageRepoDefImpl
implements PageRepoDef {
    private String name;
    private BeanRepoDefImpl beanRepoDefImpl;
    private YamlReader yamlReader;
    private String rootName;
    private Optional<NavTreeDefImpl> rootNavTreeDefImpl;
    private Map<String, Optional<PageDefImpl>> pagePathToPageDefImplMap = new ConcurrentHashMap<String, Optional<PageDefImpl>>();
    private Map<String, Optional<NavTreeDefImpl>> pagesPathToNavTreeDefImplMap = new ConcurrentHashMap<String, Optional<NavTreeDefImpl>>();
    private Map<String, Optional<LinksDefImpl>> pagesPathToLinksDefImplMap = new ConcurrentHashMap<String, Optional<LinksDefImpl>>();
    private Map<String, Optional<SlicesDefImpl>> pagesPathToSlicesDefImplMap = new ConcurrentHashMap<String, Optional<SlicesDefImpl>>();

    protected PageRepoDefImpl(String name, BeanRepoDefImpl beanRepoImpl, YamlReader yamlReader, String rootName) {
        this.name = name;
        this.beanRepoDefImpl = beanRepoImpl;
        this.yamlReader = yamlReader;
        this.rootName = rootName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    BeanRepoDefImpl getBeanRepoDefImpl() {
        return this.beanRepoDefImpl;
    }

    @Override
    public BeanRepoDef getBeanRepoDef() {
        return this.getBeanRepoDefImpl();
    }

    YamlReader getYamlReader() {
        return this.yamlReader;
    }

    private Map<String, Optional<PageDefImpl>> getPagePathToPageDefImplMap() {
        return this.pagePathToPageDefImplMap;
    }

    private Map<String, Optional<NavTreeDefImpl>> getPagesPathToNavTreeDefImplMap() {
        return this.pagesPathToNavTreeDefImplMap;
    }

    private Map<String, Optional<LinksDefImpl>> getPagesPathToLinksDefImplMap() {
        return this.pagesPathToLinksDefImplMap;
    }

    private Map<String, Optional<SlicesDefImpl>> getPagesPathToSlicesDefImplMap() {
        return this.pagesPathToSlicesDefImplMap;
    }

    PageDefImpl getPageDefImpl(PagePath pagePath) {
        String key = pagePath.getKey();
        Optional<PageDefImpl> opt = this.getPagePathToPageDefImplMap().get(key);
        if (opt == null) {
            opt = Optional.ofNullable(this.createPageDefImpl(pagePath));
            this.getPagePathToPageDefImplMap().put(key, opt);
        }
        return opt.isPresent() ? opt.get() : null;
    }

    @Override
    public PageDef getPageDef(PagePath pagePath) {
        return this.getPageDefImpl(pagePath);
    }

    private PageDefImpl createPageDefImpl(PagePath pagePath) {
        if (pagePath.isSlicePagePath()) {
            return this.createSliceDefImpl(pagePath.asSlicePagePath());
        }
        if (pagePath.isCreateFormPagePath()) {
            return this.createCreateFormDefImpl(pagePath.asCreateFormPagePath());
        }
        if (pagePath.isTablePagePath()) {
            return this.createTableDefImpl(pagePath.asTablePagePath());
        }
        if (pagePath.isActionInputFormPagePath()) {
            return this.createActionInputFormDefImpl(pagePath.asActionInputFormPagePath());
        }
        throw new AssertionError((Object)("Not a table, slice form or create form : " + String.valueOf(pagePath)));
    }

    private CreateFormDefImpl createCreateFormDefImpl(CreateFormPagePath pagePath) {
        CreateFormDefSource source = this.getYamlReader().getCreateFormDefSource(pagePath);
        return source != null ? new CreateFormDefImpl(this, pagePath, source) : null;
    }

    private TableDefImpl createTableDefImpl(TablePagePath pagePath) {
        TableDefSource source = this.getYamlReader().getTableDefSource(pagePath);
        return source != null ? new TableDefImpl(this, pagePath, source) : null;
    }

    private PageDefImpl createSliceDefImpl(SlicePagePath pagePath) {
        SlicesDefImpl slicesDefImpl = this.getSlicesDefImpl(pagePath.getPagesPath().getTypeDef());
        if (slicesDefImpl == null) {
            return null;
        }
        SlicePagePath resolvedPagePath = this.resolveSlicePagePath(pagePath, slicesDefImpl);
        PageDefSource source = this.getYamlReader().getSliceFormDefSource(resolvedPagePath, slicesDefImpl);
        if (source != null) {
            return new SliceFormDefImpl(this, resolvedPagePath, (SliceFormDefSource)source);
        }
        source = this.getYamlReader().getSliceTableDefSource(resolvedPagePath, slicesDefImpl);
        if (source != null) {
            return new SliceTableDefImpl(this, resolvedPagePath, (SliceTableDefSource)source);
        }
        return null;
    }

    private ActionInputFormDefImpl createActionInputFormDefImpl(ActionInputFormPagePath pagePath) {
        PageDefImpl parentPageDefImpl = this.getPageDefImpl(pagePath.getParentPagePath());
        if (parentPageDefImpl == null) {
            return null;
        }
        PageActionDefImpl actionDefImpl = parentPageDefImpl.findActionDefImpl(pagePath.getAction());
        return actionDefImpl != null ? actionDefImpl.getInputFormDefImpl() : null;
    }

    private SlicePagePath resolveSlicePagePath(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        PagesPath pagesPath = pagePath.getPagesPath();
        Path actualSlicePath = this.computeActualSlicePath(pagesPath, new Path(), pagePath.getSlicePath(), slicesDefImpl.getContentDefs());
        return PagePath.newSlicePagePath(pagesPath, actualSlicePath);
    }

    private Path computeActualSlicePath(PagesPath pagesPath, Path parentSlicePath, Path relativeSlicePath, List<SliceDef> sliceDefs) {
        if (relativeSlicePath.isEmpty()) {
            if (sliceDefs.isEmpty()) {
                throw new AssertionError((Object)("Empty slices " + String.valueOf(pagesPath) + " " + String.valueOf(parentSlicePath)));
            }
            SliceDef sliceDef = sliceDefs.get(0);
            return this.computeActualSlicePath(pagesPath, parentSlicePath, relativeSlicePath, sliceDef);
        }
        String sliceName = relativeSlicePath.getFirstComponent();
        for (SliceDef sliceDef : sliceDefs) {
            if (!sliceDef.getName().equals(sliceName)) continue;
            return this.computeActualSlicePath(pagesPath, parentSlicePath, relativeSlicePath, sliceDef);
        }
        throw new AssertionError((Object)("Can't find slice " + String.valueOf(pagesPath) + " " + String.valueOf(parentSlicePath) + " " + sliceName));
    }

    private Path computeActualSlicePath(PagesPath pagesPath, Path parentSlicePath, Path relativeSlicePath, SliceDef sliceDef) {
        Path slicePath = parentSlicePath.childPath(sliceDef.getName());
        List<SliceDef> nextSliceDefs = sliceDef.getContentDefs();
        if (nextSliceDefs.isEmpty()) {
            return slicePath;
        }
        Path nextParentSlicePath = slicePath;
        Path nextRelativeSlicePath = relativeSlicePath.isEmpty() ? new Path() : relativeSlicePath.subPath(1, -1);
        return this.computeActualSlicePath(pagesPath, nextParentSlicePath, nextRelativeSlicePath, nextSliceDefs);
    }

    NavTreeDefImpl getNavTreeDefImpl(BeanTypeDef typeDef) {
        String key = typeDef.getTypeName();
        Optional<NavTreeDefImpl> opt = this.getPagesPathToNavTreeDefImplMap().get(key);
        if (opt == null) {
            opt = Optional.ofNullable(this.createNavTreeDefImpl(typeDef));
            this.getPagesPathToNavTreeDefImplMap().put(key, opt);
        }
        return opt.isPresent() ? opt.get() : null;
    }

    @Override
    public NavTreeDef getNavTreeDef(BeanTypeDef typeDef) {
        return this.getNavTreeDefImpl(typeDef);
    }

    synchronized NavTreeDefImpl getRootNavTreeDefImpl() {
        if (this.rootNavTreeDefImpl == null) {
            this.rootNavTreeDefImpl = Optional.ofNullable(this.createRootNavTreeDefImpl());
        }
        return this.rootNavTreeDefImpl.isPresent() ? this.rootNavTreeDefImpl.get() : null;
    }

    @Override
    public NavTreeDef getRootNavTreeDef() {
        return this.getRootNavTreeDefImpl();
    }

    private NavTreeDefImpl createRootNavTreeDefImpl() {
        NavTreeDefSource source = this.getYamlReader().getRootNavTreeDefSource(this.rootName);
        if (source == null) {
            return null;
        }
        return new NavTreeDefImpl(this, source, this.getBeanRepoDefImpl().getRootTypeDefImpl());
    }

    private NavTreeDefImpl createNavTreeDefImpl(BeanTypeDef typeDef) {
        NavTreeDefSource source = this.getYamlReader().getNavTreeDefSource(typeDef.getTypeName());
        if (source == null) {
            return null;
        }
        return new NavTreeDefImpl(this, source, this.getTypeDefImpl(typeDef));
    }

    LinksDefImpl getLinksDefImpl(BeanTypeDef typeDef) {
        String key = typeDef.getTypeName();
        Optional<LinksDefImpl> opt = this.getPagesPathToLinksDefImplMap().get(key);
        if (opt == null) {
            opt = Optional.ofNullable(this.createLinksDefImpl(typeDef));
            this.getPagesPathToLinksDefImplMap().put(key, opt);
        }
        return opt.isPresent() ? opt.get() : null;
    }

    @Override
    public LinksDef getLinksDef(BeanTypeDef typeDef) {
        return this.getLinksDefImpl(typeDef);
    }

    private LinksDefImpl createLinksDefImpl(BeanTypeDef typeDef) {
        LinksDefImpl rtn = new LinksDefImpl(this, this.getYamlReader().getLinksDefSource(typeDef), this.getTypeDefImpl(typeDef));
        return rtn.getInstanceLinkDefs().isEmpty() && rtn.getCollectionLinkDefs().isEmpty() ? null : rtn;
    }

    SlicesDefImpl getSlicesDefImpl(BeanTypeDef typeDef) {
        String key = typeDef.getTypeName();
        Optional<SlicesDefImpl> opt = this.getPagesPathToSlicesDefImplMap().get(key);
        if (opt == null) {
            opt = Optional.ofNullable(this.createSlicesDefImpl(typeDef));
            this.getPagesPathToSlicesDefImplMap().put(key, opt);
        }
        return opt.isPresent() ? opt.get() : null;
    }

    @Override
    public SlicesDef getSlicesDef(BeanTypeDef typeDef) {
        return this.getSlicesDefImpl(typeDef);
    }

    private SlicesDefImpl createSlicesDefImpl(BeanTypeDef typeDef) {
        SlicesDefSource source = this.getYamlReader().getSlicesDefSource(typeDef);
        if (source == null) {
            return null;
        }
        return new SlicesDefImpl(this, source, this.getTypeDefImpl(typeDef));
    }

    String getLocalizationKey(String key) {
        return key;
    }

    private BaseBeanTypeDefImpl getTypeDefImpl(BeanTypeDef typeDef) {
        return this.getBeanRepoDefImpl().getTypeDefImpl(typeDef.getTypeName());
    }
}

