/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.BeanValueDef;
import weblogic.remoteconsole.common.repodef.GetPropertyOptionsCustomizerDef;
import weblogic.remoteconsole.common.repodef.GetPropertyValueCustomizerDef;
import weblogic.remoteconsole.common.repodef.LegalValueDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PageFieldPresentationDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.PagePropertyExternalHelpDef;
import weblogic.remoteconsole.common.repodef.PagePropertyUsedIfDef;
import weblogic.remoteconsole.common.repodef.schema.BeanPropertyDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.LegalValueDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.MBeanAttributeDefSource;
import weblogic.remoteconsole.common.repodef.schema.UsedIfDefSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanPropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.HealthStateLegalValueDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.HelpHTMLUtils;
import weblogic.remoteconsole.common.repodef.yaml.NormalLegalValueDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyExternalHelpDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyLegalValueDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyPresentationDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyUsedIfDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.UsageTracker;
import weblogic.remoteconsole.server.repo.Value;

class PagePropertyDefImpl
implements PagePropertyDef {
    private static final Logger LOGGER = Logger.getLogger(PagePropertyDefImpl.class.getName());
    private static final String HEALTH_STATE_OK = "ok";
    private static final String HEALTH_STATE_WARN = "warn";
    private static final String HEALTH_STATE_CRITICAL = "critical";
    private static final String HEALTH_STATE_FAILED = "failed";
    private static final String HEALTH_STATE_OVERLOADED = "overloaded";
    private static final String HEALTH_STATE_UNKNOWN = "unknown";
    private PageDefImpl pageDefImpl;
    private BeanPropertyDefImpl beanPropertyDefImpl;
    BeanPropertyDefCustomizerSource pageLevelCustomizerSource;
    private LocalizableString helpSummaryHTML;
    private LocalizableString detailedHelpHTML;
    private LocalizableString label;
    private PagePropertyExternalHelpDefImpl externalHelpDefImpl;
    private PagePropertyPresentationDefImpl presentationDefImpl;
    private List<PagePropertyLegalValueDefImpl> legalValueDefImpls = new ArrayList<PagePropertyLegalValueDefImpl>();
    private List<LegalValueDef> legalValueDefs;
    private PagePropertyUsedIfDefImpl usedIfDefImpl;

    PagePropertyDefImpl(PageDefImpl pageDefImpl, BeanPropertyDefImpl beanPropertyDefImpl, BeanPropertyDefCustomizerSource pageLevelCustomizerSource) {
        this.beanPropertyDefImpl = beanPropertyDefImpl.clone(PagePropertyDefImpl.mergeCustomizerSources(beanPropertyDefImpl.getCustomizerSource(), pageLevelCustomizerSource));
        this.initialize(pageDefImpl, pageLevelCustomizerSource);
    }

    PagePropertyDefImpl(PageDefImpl pageDefImpl, BeanPropertyDefCustomizerSource pageLevelCustomizerSource) {
        this.beanPropertyDefImpl = pageDefImpl.getTypeDefImpl().asYamlBasedBeanTypeDefImpl().createBeanPropertyDefImpl(new Path(), pageLevelCustomizerSource.getDefinition(), pageLevelCustomizerSource);
        this.initialize(pageDefImpl, pageLevelCustomizerSource);
    }

    private void initialize(PageDefImpl pageDefImpl, BeanPropertyDefCustomizerSource pageLevelCustomizerSource) {
        this.pageLevelCustomizerSource = pageLevelCustomizerSource;
        this.pageDefImpl = pageDefImpl;
        this.initializeHelp();
        this.initializeLabel();
        this.initializeLegalValueDefs();
        this.initializePresentationDef();
    }

    void createUsedIfDefImpl() {
        UsedIfDefSource usedIfSource = this.beanPropertyDefImpl.getCustomizerSource().getUsedIf();
        if (usedIfSource != null) {
            this.usedIfDefImpl = new PagePropertyUsedIfDefImpl(this, usedIfSource);
        }
    }

    PagePropertyUsedIfDefImpl getUsedIfDefImpl() {
        return this.usedIfDefImpl;
    }

    @Override
    public PagePropertyUsedIfDef getUsedIfDef() {
        return this.getUsedIfDefImpl();
    }

    PageDefImpl getPageDefImpl() {
        return this.pageDefImpl;
    }

    @Override
    public PageDef getPageDef() {
        return this.getPageDefImpl();
    }

    @Override
    public LocalizableString getHelpSummaryHTML() {
        return this.helpSummaryHTML;
    }

    @Override
    public LocalizableString getDetailedHelpHTML() {
        return this.detailedHelpHTML;
    }

    PagePropertyPresentationDefImpl getPresentationDefImpl() {
        return this.presentationDefImpl;
    }

    @Override
    public PageFieldPresentationDef getPresentationDef() {
        return this.presentationDefImpl;
    }

    List<PagePropertyLegalValueDefImpl> getLegalValueDefImpls() {
        return this.legalValueDefImpls;
    }

    @Override
    public List<LegalValueDef> getLegalValueDefs() {
        return this.legalValueDefs;
    }

    @Override
    public boolean isSupportsOptions() {
        return this.isReference();
    }

    @Override
    public List<String> getOptionsSources() {
        if (this.isSupportsOptions()) {
            return this.beanPropertyDefImpl.getCustomizerSource().getOptionsSources();
        }
        return null;
    }

    @Override
    public boolean isAllowNoneOption() {
        if (!this.isSupportsOptions()) {
            return false;
        }
        return this.isReference() && (this.isReferenceAsReferences() || !this.isArray()) && this.beanPropertyDefImpl.getCustomizerSource().isAllowNullReference();
    }

    @Override
    public LocalizableString getLabel() {
        return this.label;
    }

    PagePropertyExternalHelpDefImpl getExternalHelpDefImpl() {
        return this.externalHelpDefImpl;
    }

    @Override
    public PagePropertyExternalHelpDef getExternalHelpDef() {
        return this.getExternalHelpDefImpl();
    }

    @Override
    public boolean isSupportsModelTokens() {
        if (this.isPageLevelField() && !this.beanPropertyDefImpl.getCustomizerSource().isSupportsModelTokensSpecifiedInYaml()) {
            return false;
        }
        return this.beanPropertyDefImpl.isSupportsModelTokens();
    }

    private static BeanPropertyDefCustomizerSource mergeCustomizerSources(BeanPropertyDefCustomizerSource typeLevelCustomizerSource, BeanPropertyDefCustomizerSource pageLevelCustomizerSource) {
        BeanPropertyDefCustomizerSource rtn = new BeanPropertyDefCustomizerSource();
        rtn.merge(typeLevelCustomizerSource, new Path());
        rtn.merge(pageLevelCustomizerSource, new Path());
        return rtn;
    }

    private void initializeLabel() {
        String lbl = this.beanPropertyDefImpl.getCustomizerSource().getLabel();
        if (this.beanPropertyDefImpl.getCustomizerSource().isUseUnlocalizedNameAsLabel()) {
            if (StringUtils.isEmpty((String)lbl)) {
                lbl = this.getPropertyName();
            }
            this.label = new LocalizableString(lbl);
        } else {
            if (StringUtils.isEmpty((String)lbl)) {
                lbl = StringUtils.camelCaseToUpperCaseWords((String)this.getPropertyName());
            }
            this.label = new LocalizableString(this.getLabelLocalizationKey(), lbl);
        }
    }

    private void initializePresentationDef() {
        this.presentationDefImpl = new PagePropertyPresentationDefImpl(this, this.beanPropertyDefImpl.getCustomizerSource().getPresentation());
    }

    private void initializeLegalValueDefs() {
        if (this.isHealthState()) {
            this.getLegalValueDefImpls().add(new HealthStateLegalValueDefImpl(this, HEALTH_STATE_OK));
            this.getLegalValueDefImpls().add(new HealthStateLegalValueDefImpl(this, HEALTH_STATE_WARN));
            this.getLegalValueDefImpls().add(new HealthStateLegalValueDefImpl(this, HEALTH_STATE_CRITICAL));
            this.getLegalValueDefImpls().add(new HealthStateLegalValueDefImpl(this, HEALTH_STATE_FAILED));
            this.getLegalValueDefImpls().add(new HealthStateLegalValueDefImpl(this, HEALTH_STATE_OVERLOADED));
            this.getLegalValueDefImpls().add(new HealthStateLegalValueDefImpl(this, HEALTH_STATE_UNKNOWN));
        } else {
            this.mergePagePropertyLegalValueDefImpls(this.createSourceLevelPagePropertyLegalValueDefImpls(), this.createCustomizerSourceLevelPagePropertyLegalValueDefImpls());
        }
        this.legalValueDefs = Collections.unmodifiableList(this.getLegalValueDefImpls());
    }

    private void mergePagePropertyLegalValueDefImpls(List<PagePropertyLegalValueDefImpl> sourceVals, List<PagePropertyLegalValueDefImpl> customizerVals) {
        if (sourceVals.isEmpty()) {
            this.getLegalValueDefImpls().addAll(customizerVals);
        } else {
            for (PagePropertyLegalValueDefImpl sourceVal : sourceVals) {
                PagePropertyLegalValueDefImpl customizerVal = this.findPagePropertyLegalValueDefImpl(sourceVal, customizerVals);
                if (customizerVal != null) {
                    if (customizerVal.isOmit()) continue;
                    this.getLegalValueDefImpls().add(customizerVal);
                    continue;
                }
                this.getLegalValueDefImpls().add(sourceVal);
            }
            for (PagePropertyLegalValueDefImpl customizerVal : customizerVals) {
                String usageId = "property legal value " + this.getTypeDef().getTypeName() + " " + String.valueOf(this.getPropertyPath()) + " " + customizerVal.getValueAsString();
                if (this.findPagePropertyLegalValueDefImpl(customizerVal, sourceVals) == null) {
                    UsageTracker.notFound(usageId);
                    continue;
                }
                UsageTracker.used(usageId);
            }
        }
    }

    private List<PagePropertyLegalValueDefImpl> createSourceLevelPagePropertyLegalValueDefImpls() {
        ArrayList<PagePropertyLegalValueDefImpl> rtn = new ArrayList<PagePropertyLegalValueDefImpl>();
        for (Object legalValue : this.beanPropertyDefImpl.getSource().getLegalValues()) {
            if (this.beanPropertyDefImpl.getCustomizerSource().isUseUnlocalizedLegalValuesAsLabels()) {
                rtn.add(new NormalLegalValueDefImpl(this, legalValue, null));
                continue;
            }
            rtn.add(new NormalLegalValueDefImpl(this, legalValue));
        }
        return rtn;
    }

    private List<PagePropertyLegalValueDefImpl> createCustomizerSourceLevelPagePropertyLegalValueDefImpls() {
        ArrayList<PagePropertyLegalValueDefImpl> rtn = new ArrayList<PagePropertyLegalValueDefImpl>();
        for (LegalValueDefCustomizerSource src : this.beanPropertyDefImpl.getCustomizerSource().getLegalValues()) {
            boolean supported = this.beanPropertyDefImpl.getTypeDefImpl().getBeanRepoDefImpl().supportsCapabilities(src.getRequiredCapabilities());
            if (!supported) continue;
            rtn.add(new NormalLegalValueDefImpl(this, src.getValue(), src.getLabel(), src.isOmit()));
        }
        return rtn;
    }

    private PagePropertyLegalValueDefImpl findPagePropertyLegalValueDefImpl(PagePropertyLegalValueDefImpl want, List<PagePropertyLegalValueDefImpl> vals) {
        for (PagePropertyLegalValueDefImpl have : vals) {
            if (!StringUtils.nonNull((String)want.getValueAsString()).equals(StringUtils.nonNull((String)have.getValueAsString()))) continue;
            return have;
        }
        return null;
    }

    private void initializeHelp() {
        this.initializeHelpSummaryHTML();
        this.initializeDetailedHelpHTML();
        this.initializePagePropertyExternalHelpDef();
    }

    private void initializePagePropertyExternalHelpDef() {
        BeanPropertyDef mbeanAttributePropertyDef = this.getMBeanAttributePropertyDef();
        if (mbeanAttributePropertyDef == null) {
            return;
        }
        this.externalHelpDefImpl = new PagePropertyExternalHelpDefImpl(this, mbeanAttributePropertyDef);
    }

    private BeanPropertyDef getMBeanAttributePropertyDef() {
        if (this.getPageDefImpl().getPageRepoDefImpl().getBeanRepoDefImpl().getMBeansVersion().getWebLogicVersion() == null) {
            return null;
        }
        MBeanAttributeDefSource source = this.beanPropertyDefImpl.getCustomizerSource().getMbeanAttribute();
        String attributeName = source.getAttribute();
        if (StringUtils.isEmpty((String)attributeName) && this.isPageLevelField()) {
            return null;
        }
        String typeName = source.getType();
        BaseBeanTypeDefImpl typeDefImpl = StringUtils.isEmpty((String)typeName) ? this.getPageDefImpl().getTypeDefImpl() : this.getPageDefImpl().getTypeDefImpl().getBeanRepoDefImpl().getTypeDefImpl(typeName);
        BeanPropertyDefImpl propertyDefImpl = StringUtils.isEmpty((String)attributeName) ? this.beanPropertyDefImpl : typeDefImpl.getPropertyDefImpl(new Path(attributeName));
        Path parentPath = propertyDefImpl.getParentPath();
        if (!parentPath.isEmpty()) {
            boolean searchSubTypes = true;
            propertyDefImpl = typeDefImpl.getChildDefImpl(parentPath, searchSubTypes).getChildTypeDefImpl().getPropertyDefImpl(new Path(propertyDefImpl.getPropertyName()), searchSubTypes);
        }
        if (propertyDefImpl.getCustomizerSource().isDisableMBeanJavadoc() || propertyDefImpl.getTypeDefImpl().isDisableMBeanJavadoc()) {
            return null;
        }
        return propertyDefImpl;
    }

    private void initializeHelpSummaryHTML() {
        this.helpSummaryHTML = new LocalizableString(this.getHelpSummaryHTMLLocalizationKey(), this.getEnglishHelpSummaryHTML());
    }

    private void initializeDetailedHelpHTML() {
        this.detailedHelpHTML = new LocalizableString(this.getDetailedHelpHTMLLocalizationKey(), this.getEnglishDetailedHelpHTML());
    }

    private String getEnglishHelpSummaryHTML() {
        return HelpHTMLUtils.getEnglishHelpSummaryHTML(this.beanPropertyDefImpl.getSource().getDescriptionHTML(), this.beanPropertyDefImpl.getCustomizerSource().getHelpHTML(), this.beanPropertyDefImpl.getCustomizerSource().getHelpSummaryHTML(), this.beanPropertyDefImpl.getCustomizerSource().getHelpDetailsHTML());
    }

    private String getEnglishDetailedHelpHTML() {
        return HelpHTMLUtils.getEnglishDetailedHelpHTML(this.beanPropertyDefImpl.getSource().getDescriptionHTML(), this.beanPropertyDefImpl.getCustomizerSource().getHelpHTML(), this.beanPropertyDefImpl.getCustomizerSource().getHelpSummaryHTML(), this.beanPropertyDefImpl.getCustomizerSource().getHelpDetailsHTML());
    }

    private String getLabelLocalizationKey() {
        boolean pageLevel = StringUtils.notEmpty((String)this.pageLevelCustomizerSource.getLabel());
        return this.getLocalizationKey("label", pageLevel);
    }

    String getLegalValueLocalizationKey(String legalValue) {
        boolean pageLevel = !this.pageLevelCustomizerSource.getLegalValues().isEmpty();
        return this.getLocalizationKey("legalValues." + legalValue, pageLevel);
    }

    private String getHelpSummaryHTMLLocalizationKey() {
        boolean pageLevel = StringUtils.notEmpty((String)this.pageLevelCustomizerSource.getHelpHTML()) || StringUtils.notEmpty((String)this.pageLevelCustomizerSource.getHelpSummaryHTML());
        return this.getLocalizationKey("helpSummaryHTML", pageLevel);
    }

    private String getDetailedHelpHTMLLocalizationKey() {
        boolean pageLevel = StringUtils.notEmpty((String)this.pageLevelCustomizerSource.getHelpHTML()) || StringUtils.notEmpty((String)this.pageLevelCustomizerSource.getHelpSummaryHTML()) || StringUtils.notEmpty((String)this.pageLevelCustomizerSource.getHelpDetailsHTML());
        return this.getLocalizationKey("detailedHelpHTML", pageLevel);
    }

    String getInlineFieldHelpLocalizationKey() {
        boolean pageLevel = StringUtils.notEmpty((String)this.pageLevelCustomizerSource.getPresentation().getInlineFieldHelp());
        return this.getLocalizationKey("inlineFieldHelp", pageLevel);
    }

    private String getLocalizationKey(String key, boolean pageLevel) {
        if (pageLevel || this.isPageLevelField()) {
            return this.getPageDefImpl().getLocalizationKey("properties." + this.getPropertyPath().getDotSeparatedPath() + "." + key);
        }
        return this.beanPropertyDefImpl.getLocalizationKey(key);
    }

    @Override
    public boolean isPageLevelField() {
        return this.pageLevelCustomizerSource.getDefinition() != null;
    }

    @Override
    public BeanTypeDef getTypeDef() {
        return this.beanPropertyDefImpl.getTypeDef();
    }

    @Override
    public String getPropertyName() {
        return this.beanPropertyDefImpl.getPropertyName();
    }

    @Override
    public String getFormFieldName() {
        return this.beanPropertyDefImpl.getFormFieldName();
    }

    @Override
    public String getOnlinePropertyName() {
        return this.beanPropertyDefImpl.getOnlinePropertyName();
    }

    @Override
    public String getOfflinePropertyName() {
        return this.beanPropertyDefImpl.getOfflinePropertyName();
    }

    @Override
    public Path getParentPath() {
        return this.beanPropertyDefImpl.getParentPath();
    }

    @Override
    public boolean isOrdered() {
        return this.beanPropertyDefImpl.isOrdered();
    }

    @Override
    public boolean isMultiLineString() {
        return this.beanPropertyDefImpl.isMultiLineString();
    }

    @Override
    public boolean isDynamicEnum() {
        return this.beanPropertyDefImpl.isDynamicEnum();
    }

    @Override
    public boolean isKey() {
        return this.beanPropertyDefImpl.isKey();
    }

    @Override
    public boolean isCreateWritable() {
        return this.beanPropertyDefImpl.isCreateWritable();
    }

    @Override
    public boolean isUpdateWritable() {
        return this.beanPropertyDefImpl.isUpdateWritable();
    }

    @Override
    public boolean isRequired() {
        return this.beanPropertyDefImpl.isRequired();
    }

    @Override
    public GetPropertyValueCustomizerDef getGetValueCustomizerDef() {
        return this.beanPropertyDefImpl.getGetValueCustomizerDef();
    }

    @Override
    public GetPropertyOptionsCustomizerDef getGetOptionsCustomizerDef() {
        return this.beanPropertyDefImpl.getGetOptionsCustomizerDef();
    }

    @Override
    public boolean isRestartNeeded() {
        return this.beanPropertyDefImpl.isRestartNeeded();
    }

    @Override
    public boolean isSupportsUnresolvedReferences() {
        if (this.isPageLevelField()) {
            return false;
        }
        return this.beanPropertyDefImpl.isSupportsUnresolvedReferences();
    }

    @Override
    public Value getSecureDefaultValue() {
        return this.beanPropertyDefImpl.getSecureDefaultValue();
    }

    @Override
    public Value getProductionDefaultValue() {
        return this.beanPropertyDefImpl.getProductionDefaultValue();
    }

    @Override
    public Value getStandardDefaultValue() {
        return this.beanPropertyDefImpl.getStandardDefaultValue();
    }

    @Override
    public BeanValueDef.ValueKind getValueKind() {
        return this.beanPropertyDefImpl.getValueKind();
    }

    @Override
    public boolean isArray() {
        return this.beanPropertyDefImpl.isArray();
    }

    @Override
    public BeanTypeDef getReferenceTypeDef() {
        return this.beanPropertyDefImpl.getReferenceTypeDef();
    }

    @Override
    public boolean isReferenceAsReferences() {
        return this.beanPropertyDefImpl.isReferenceAsReferences();
    }

    @Override
    public boolean isDateAsLong() {
        return this.beanPropertyDefImpl.isDateAsLong();
    }

    @Override
    public Set<String> getGetRoles() {
        return this.beanPropertyDefImpl.getGetRoles();
    }

    @Override
    public Set<String> getSetRoles() {
        return this.beanPropertyDefImpl.getSetRoles();
    }

    @Override
    public boolean isDontReturnIfHiddenColumn() {
        return this.beanPropertyDefImpl.getCustomizerSource().isDontReturnIfHiddenColumn();
    }

    public String toString() {
        return String.valueOf(this.getPageDef()) + " property=" + String.valueOf(this.getPropertyPath());
    }
}

